/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.lang.reflect.Field;
import java.util.Map;
import org.drools.core.FactHandle;
import org.drools.core.QueryResult;
import org.drools.core.QueryResults;
import org.drools.core.RuleBaseFactory;
import org.drools.core.StatefulSession;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.FieldFactory;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.MvelConstraintTestUtil;
import org.drools.core.rule.Package;
import org.drools.core.rule.Query;
import org.drools.core.rule.Rule;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="phreak")
public class QueryTerminalNodeTest {
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        this.entryPoint = new EntryPointNode(0, (ObjectSource)this.ruleBase.getRete(), this.buildContext);
        this.entryPoint.attach(this.buildContext);
    }

    @Test
    public void testQueryTerminalNode() {
        ClassObjectType queryObjectType = new ClassObjectType(DroolsQuery.class);
        ObjectTypeNode queryObjectTypeNode = new ObjectTypeNode(this.buildContext.getNextId(), this.entryPoint, (ObjectType)queryObjectType, this.buildContext);
        queryObjectTypeNode.attach(this.buildContext);
        ClassFieldReader extractor = this.store.getReader(DroolsQuery.class, "name", DroolsQuery.class.getClassLoader());
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("name == \"query-1\"", FieldFactory.getInstance().getFieldValue((Object)"query-1"), (InternalReadAccessor)extractor);
        AlphaNode alphaNode = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)constraint, (ObjectSource)queryObjectTypeNode, this.buildContext);
        alphaNode.attach(this.buildContext);
        LeftInputAdapterNode liaNode = new LeftInputAdapterNode(this.buildContext.getNextId(), (ObjectSource)alphaNode, this.buildContext);
        liaNode.attach(this.buildContext);
        ClassObjectType cheeseObjectType = new ClassObjectType(Cheese.class);
        ObjectTypeNode cheeseObjectTypeNode = new ObjectTypeNode(this.buildContext.getNextId(), this.entryPoint, (ObjectType)cheeseObjectType, this.buildContext);
        cheeseObjectTypeNode.attach(this.buildContext);
        extractor = this.store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        constraint = new MvelConstraintTestUtil("type == \"stilton\"", FieldFactory.getInstance().getFieldValue((Object)"stilton"), (InternalReadAccessor)extractor);
        alphaNode = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)constraint, (ObjectSource)cheeseObjectTypeNode, this.buildContext);
        alphaNode.attach(this.buildContext);
        BuildContext buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        buildContext.setTupleMemoryEnabled(false);
        JoinNode joinNode = new JoinNode(this.buildContext.getNextId(), (LeftTupleSource)liaNode, (ObjectSource)alphaNode, EmptyBetaConstraints.getInstance(), buildContext);
        joinNode.attach(buildContext);
        Query query = new Query("query-1");
        QueryTerminalNode queryNode = new QueryTerminalNode(this.buildContext.getNextId(), (LeftTupleSource)joinNode, (Rule)query, query.getLhs(), 0, buildContext);
        queryNode.attach(buildContext);
        Package pkg = new Package("com.drools.test");
        pkg.addRule((Rule)query);
        try {
            Field pkgField = this.ruleBase.getClass().getSuperclass().getDeclaredField("pkgs");
            pkgField.setAccessible(true);
            Map pkgs = (Map)pkgField.get(this.ruleBase);
            pkgs.put(pkg.getName(), pkg);
        }
        catch (Exception e) {
            Assert.fail((String)("Should not throw any exception: " + e.getMessage()));
        }
        StatefulSession workingMemory = this.ruleBase.newStatefulSession();
        QueryResults results = workingMemory.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)0L, (long)results.size());
        Cheese stilton1 = new Cheese("stilton", 100);
        FactHandle handle1 = workingMemory.insert((Object)stilton1);
        results = workingMemory.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        Cheese cheddar = new Cheese("cheddar", 55);
        workingMemory.insert((Object)cheddar);
        results = workingMemory.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        Cheese stilton2 = new Cheese("stilton", 5);
        FactHandle handle2 = workingMemory.insert((Object)stilton2);
        results = workingMemory.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)2L, (long)results.size());
        QueryResult result2 = results.get(0);
        Assert.assertEquals((long)1L, (long)result2.size());
        Assert.assertEquals((Object)stilton1, (Object)result2.get(0));
        result2 = results.get(1);
        Assert.assertEquals((long)1L, (long)result2.size());
        Assert.assertEquals((Object)stilton2, (Object)result2.get(0));
        int i = 0;
        for (QueryResult result2 : results) {
            Assert.assertEquals((long)1L, (long)result2.size());
            if (i == 1) {
                Assert.assertSame((Object)stilton2, (Object)result2.get(0));
            } else {
                Assert.assertSame((Object)stilton1, (Object)result2.get(0));
            }
            ++i;
        }
        workingMemory.retract((org.kie.api.runtime.rule.FactHandle)handle1);
        results = workingMemory.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        workingMemory.retract((org.kie.api.runtime.rule.FactHandle)handle2);
        results = workingMemory.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    public class Cheese {
        private String type;
        private int price;

        public Cheese(String type, int price) {
            this.type = type;
            this.price = price;
        }

        public int getPrice() {
            return this.price;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "[Cheese type='" + this.type + "' price='" + this.price + "']";
        }
    }
}

