/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.test.dsl;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.antlr.tool.Rule;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.EvaluatorWrapper;
import org.drools.core.base.accumulators.MVELAccumulatorFunctionExecutor;
import org.drools.core.base.accumulators.SumAccumulateFunction;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.DefaultBetaConstraints;
import org.drools.core.common.DoubleBetaConstraints;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.QuadroupleBetaConstraints;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.common.TripleBetaConstraints;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.test.dsl.NodeTestCase;
import org.drools.core.reteoo.test.dsl.ReteTesterHelper;
import org.drools.core.reteoo.test.dsl.Step;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.KnowledgeHelper;
import org.kie.api.runtime.rule.AccumulateFunction;

public class AccumulateNodeStep
implements Step {
    private ReteTesterHelper reteTesterHelper;

    public AccumulateNodeStep(ReteTesterHelper reteTesterHelper) {
        this.reteTesterHelper = reteTesterHelper;
    }

    @Override
    public void execute(Map<String, Object> context, List<String[]> args) {
        MVELDialectRuntimeData data;
        EmptyBetaConstraints betaSourceConstraints;
        AlphaNodeFieldConstraint[] alphaResultConstraint;
        Pattern sourcePattern;
        ObjectSource rightObjectSource;
        LeftTupleSource leftTupleSource;
        String expr;
        String name;
        BuildContext buildContext = (BuildContext)context.get("BuildContext");
        if (args.size() >= 1) {
            Pattern resultPattern;
            Object[] a = args.get(0);
            name = a[0];
            String string = a[1];
            String rightInput = a[2];
            String sourceType = a[3];
            expr = a[4];
            Class<?> cls = null;
            leftTupleSource = string.startsWith("mock") ? new MockTupleSource(buildContext.getNextId()) : (LeftTupleSource)context.get(string);
            if (rightInput.startsWith("mock")) {
                String type = rightInput.substring(5, rightInput.length() - 1);
                try {
                    cls = this.reteTesterHelper.getTypeResolver().resolveType(type);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                rightObjectSource = new MockObjectSource(buildContext.getNextId());
            } else {
                ObjectSource source = rightObjectSource = (ObjectSource)context.get(rightInput);
                while (!(source instanceof ObjectTypeNode)) {
                    source = source.getParentObjectSource();
                }
                cls = ((ClassObjectType)((ObjectTypeNode)source).getObjectType()).getClassType();
            }
            try {
                sourcePattern = this.reteTesterHelper.getPattern(0, sourceType);
                resultPattern = this.reteTesterHelper.getPattern(buildContext.getNextId(), Number.class.getName());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Not possible to process arguments: " + Arrays.toString(a));
            }
            ArrayList<BetaNodeFieldConstraint> list = new ArrayList<BetaNodeFieldConstraint>();
            alphaResultConstraint = new AlphaNodeFieldConstraint[]{};
            for (int i = 1; i < args.size(); ++i) {
                a = args.get(i);
                Object type = a[0];
                Object fieldName = a[1];
                Object operator = a[2];
                Object val = a[3];
                if ("source".equals(type)) {
                    Declaration declr = (Declaration)context.get(val);
                    try {
                        BetaNodeFieldConstraint sourceBetaConstraint = this.reteTesterHelper.getBoundVariableConstraint(cls, (String)fieldName, declr, (String)operator);
                        list.add(sourceBetaConstraint);
                        continue;
                    }
                    catch (IntrospectionException e) {
                        throw new IllegalArgumentException();
                    }
                }
                if (!"result".equals(type)) continue;
                alphaResultConstraint = new AlphaNodeFieldConstraint[1];
                try {
                    alphaResultConstraint[0] = this.reteTesterHelper.getLiteralConstraint(resultPattern, (String)fieldName, (String)operator, (String)val);
                    continue;
                }
                catch (IntrospectionException e) {
                    throw new IllegalArgumentException("Unable to configure alpha constraint: " + Arrays.toString(a), e);
                }
            }
            switch (list.size()) {
                case 0: {
                    betaSourceConstraints = new EmptyBetaConstraints();
                    break;
                }
                case 1: {
                    betaSourceConstraints = new SingleBetaConstraints((BetaNodeFieldConstraint)list.get(0), buildContext.getRuleBase().getConfiguration());
                    break;
                }
                case 2: {
                    betaSourceConstraints = new DoubleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[2]), buildContext.getRuleBase().getConfiguration());
                    break;
                }
                case 3: {
                    betaSourceConstraints = new TripleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[2]), buildContext.getRuleBase().getConfiguration());
                    break;
                }
                case 4: {
                    betaSourceConstraints = new QuadroupleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[2]), buildContext.getRuleBase().getConfiguration());
                    break;
                }
                default: {
                    betaSourceConstraints = new DefaultBetaConstraints(list.toArray(new BetaNodeFieldConstraint[2]), buildContext.getRuleBase().getConfiguration());
                }
            }
            data = (MVELDialectRuntimeData)buildContext.getRuleBase().getPackage(buildContext.getRule().getPackageName()).getDialectRuntimeRegistry().getDialectData("mvel");
            data.onAdd(null, buildContext.getRuleBase().getRootClassLoader());
            NodeTestCase testCase = (NodeTestCase)context.get("TestCase");
            try {
                for (String imp : testCase.getImports()) {
                    if (imp.endsWith(".*")) {
                        data.addPackageImport(imp.substring(0, imp.lastIndexOf(46)));
                        continue;
                    }
                    cls = data.getRootClassLoader().loadClass(imp);
                    data.addImport(cls.getSimpleName(), cls);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load class", e);
            }
        }
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append("Can not parse AccumulateNode step arguments: \n");
        for (Object[] objectArray : args) {
            msgBuilder.append("    ");
            msgBuilder.append(Arrays.toString(objectArray));
            msgBuilder.append("\n");
        }
        throw new IllegalArgumentException(msgBuilder.toString());
        Declaration decl = (Declaration)context.get(expr);
        MVELCompilationUnit compilationUnit = new MVELCompilationUnit(name, expr, new String[0], new EvaluatorWrapper[0], new Declaration[0], new Declaration[]{decl}, new String[0], new String[]{"this", "drools", "kcontext", "rule", decl.getIdentifier()}, new String[]{Object.class.getName(), KnowledgeHelper.class.getName(), KnowledgeHelper.class.getName(), Rule.class.getName(), decl.getValueType().getClassType().getName()}, 4, false, false);
        SumAccumulateFunction accFunction = new SumAccumulateFunction();
        MVELAccumulatorFunctionExecutor accumulator = new MVELAccumulatorFunctionExecutor(compilationUnit, (AccumulateFunction)accFunction);
        ((MVELCompileable)accumulator).compile(data);
        Accumulate accumulate = new Accumulate((RuleConditionElement)sourcePattern, new Declaration[0], new Accumulator[]{accumulator}, false);
        AccumulateNode accNode = new AccumulateNode(buildContext.getNextId(), leftTupleSource, rightObjectSource, alphaResultConstraint, (BetaConstraints)betaSourceConstraints, (BetaConstraints)new EmptyBetaConstraints(), accumulate, false, buildContext);
        accNode.attach(buildContext);
        context.put(name, accNode);
    }
}

