/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.drools.core.base.ClassObjectType;
import org.drools.core.beliefsystem.abductive.AbductedStatus;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Query;
import org.drools.core.spi.AcceptsClassObjectType;

public class AbductiveQuery
extends Query
implements Externalizable,
AcceptsClassObjectType {
    private ClassObjectType returnType;
    private transient Constructor constructor;
    private String[] params;
    private Object value;
    private boolean returnBound;

    public AbductiveQuery() {
    }

    public AbductiveQuery(String name, Object value) {
        super(name);
        this.value = value != null ? value : AbductedStatus.ABDUCTED;
    }

    @Override
    public boolean isAbductive() {
        return true;
    }

    public void setReturnType(ClassObjectType objectType, String[] params) throws NoSuchMethodException {
        this.returnType = objectType;
        this.params = params;
        this.findConstructor();
    }

    protected void findConstructor() throws NoSuchMethodException {
        int N = this.params.length - 1;
        this.constructor = null;
        ArrayList availableArgs = new ArrayList(N);
        for (int j = 0; j < N; ++j) {
            Declaration decl = this.getDeclaration(this.params[j]);
            if (decl == null) continue;
            availableArgs.add(decl.getExtractor().getExtractToClass());
        }
        Class<?> klass = this.returnType.getClassType();
        while (this.constructor == null) {
            try {
                this.constructor = klass.getConstructor(availableArgs.toArray(new Class[availableArgs.size()]));
            }
            catch (NoSuchMethodException nsme) {
                if (klass == Object.class) {
                    throw nsme;
                }
                klass = klass.getSuperclass();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.returnType);
        out.writeObject(this.params);
        out.writeObject(this.value);
        out.writeBoolean(this.returnBound);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.returnType = (ClassObjectType)in.readObject();
        this.params = (String[])in.readObject();
        this.value = in.readObject();
        this.returnBound = in.readBoolean();
    }

    public Object abduce(Object ... args) {
        if (this.constructor == null) {
            return null;
        }
        try {
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null || !this.constructor.getParameterTypes()[j].isPrimitive()) continue;
                args[j] = Boolean.TYPE == this.constructor.getParameterTypes()[j] ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
            }
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ClassObjectType getReturnType() {
        return this.returnType;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void setClassObjectType(ClassObjectType classObjectType) {
        this.returnType = classObjectType;
        if (this.params != null) {
            try {
                this.findConstructor();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                this.constructor = null;
                this.returnType = null;
            }
        }
    }

    public void setReturnBound(boolean returnBound) {
        this.returnBound = returnBound;
    }

    public boolean isReturnBound() {
        return this.returnBound;
    }
}

