/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import org.drools.core.base.BaseEvaluator;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.CodedHierarchy;
import org.drools.core.util.HierarchyEncoder;
import org.drools.core.util.HierarchyEncoderImpl;
import org.kie.api.runtime.ObjectFilter;

public class IsAEvaluatorDefinition
implements EvaluatorDefinition {
    protected static final String isAOp = "isA";
    public static Operator ISA;
    public static Operator NOT_ISA;
    private static String[] SUPPORTED_IDS;
    private Evaluator[] evaluator;

    public IsAEvaluatorDefinition() {
        IsAEvaluatorDefinition.init();
    }

    static void init() {
        if (Operator.determineOperator(isAOp, false) == null) {
            ISA = Operator.addOperatorToRegistry(isAOp, false);
            NOT_ISA = Operator.addOperatorToRegistry(isAOp, true);
            SUPPORTED_IDS = new String[]{isAOp};
        }
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target leftTarget, EvaluatorDefinition.Target rightTarget) {
        IsAEvaluator evaluator = new IsAEvaluator(type, isNegated);
        evaluator.setParameterText(parameterText);
        return evaluator;
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return type.equals(ValueType.TRAIT_TYPE);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluator = (Evaluator[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluator);
    }

    public static class IsAEvaluator
    extends BaseEvaluator {
        private BitSet cachedLiteral;
        private Object cachedValue;

        public IsAEvaluator() {
            IsAEvaluatorDefinition.init();
        }

        public void setParameterText(String parameterText) {
        }

        public IsAEvaluator(ValueType type, boolean isNegated) {
            super(type, isNegated ? NOT_ISA : ISA);
            IsAEvaluatorDefinition.init();
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle handle, FieldValue value) {
            Object objectValue = extractor.getValue(workingMemory, handle.getObject());
            Object literal = value.getValue();
            if (this.cachedValue != literal) {
                this.cachedValue = literal;
                this.cacheLiteral(literal, workingMemory);
            }
            if (objectValue == null) {
                return this.getOperator().isNegated();
            }
            if (objectValue instanceof Thing) {
                Thing thing = (Thing)objectValue;
                TraitableBean core = (TraitableBean)thing.getCore();
                BitSet code = core.getCurrentTypeCode();
                if (code != null) {
                    return this.getOperator().isNegated() ^ this.isA(code, this.cachedLiteral);
                }
                return this.getOperator().isNegated() ^ this.hasTrait(core, literal);
            }
            if (objectValue instanceof TraitableBean) {
                TraitableBean core = (TraitableBean)objectValue;
                BitSet code = core.getCurrentTypeCode();
                if (code != null) {
                    return this.getOperator().isNegated() ^ this.isA(code, this.cachedLiteral);
                }
                return this.getOperator().isNegated() ^ this.hasTrait(core, literal);
            }
            TraitableBean core = this.lookForWrapper(objectValue, workingMemory);
            if (core == null) {
                return this.getOperator().isNegated();
            }
            BitSet code = core.getCurrentTypeCode();
            if (code != null) {
                return this.getOperator().isNegated() ^ this.isA(code, this.cachedLiteral);
            }
            return this.getOperator().isNegated() ^ this.hasTrait(core, literal);
        }

        private boolean hasTrait(TraitableBean core, Object value) {
            if (value instanceof Class) {
                return core.hasTrait(((Class)value).getName());
            }
            if (value instanceof String) {
                return core.hasTrait((String)value);
            }
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    if (this.hasTrait(core, o)) continue;
                    return false;
                }
                return true;
            }
            throw new UnsupportedOperationException(" IsA Operator : Unsupported literal " + value);
        }

        private void cacheLiteral(Object value, InternalWorkingMemory workingMemory) {
            HierarchyEncoder<String> x = ((ReteooRuleBase)workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
            this.cachedLiteral = this.getCode(value, x);
        }

        private BitSet getCode(Object value, CodedHierarchy x) {
            if (value instanceof Class) {
                String typeName = ((Class)value).getName();
                return x.getCode(typeName);
            }
            if (value instanceof String) {
                return x.getCode(value);
            }
            if (value instanceof Collection) {
                BitSet code = null;
                for (Object o : (Collection)value) {
                    if (code == null) {
                        code = (BitSet)this.getCode(o, x).clone();
                        continue;
                    }
                    code.and(this.getCode(o, x));
                }
                return code;
            }
            throw new UnsupportedOperationException(" IsA Operator : Unsupported literal " + value);
        }

        protected TraitableBean lookForWrapper(final Object objectValue, InternalWorkingMemory workingMemory) {
            Iterator iter = workingMemory.getObjectStore().iterateObjects(new ObjectFilter(){

                public boolean accept(Object object) {
                    if (object instanceof TraitProxy) {
                        TraitableBean core = ((TraitProxy)object).getObject();
                        if (core instanceof CoreWrapper) {
                            core = ((CoreWrapper)core).getCore();
                        }
                        return core == objectValue;
                    }
                    return false;
                }
            });
            if (iter.hasNext()) {
                return ((TraitProxy)iter.next()).getObject();
            }
            return null;
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor leftExtractor, InternalFactHandle left, InternalReadAccessor rightExtractor, InternalFactHandle right) {
            Object value1 = leftExtractor.getValue(workingMemory, left != null ? left.getObject() : left);
            Object value2 = rightExtractor.getValue(workingMemory, right != null ? right.getObject() : right);
            Object target = value1;
            Object source = value2;
            return this.compare(source, target, workingMemory);
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            Object target = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object source = context.getFieldExtractor().getValue(workingMemory, right.getObject());
            return this.compare(source, target, workingMemory);
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            Object target = context.getFieldExtractor().getValue(workingMemory, left.getObject());
            Object source = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            return this.compare(source, target, workingMemory);
        }

        private boolean compare(Object source, Object target, InternalWorkingMemory workingMemory) {
            TraitableBean tbean;
            HierarchyEncoder<String> x;
            BitSet sourceTraits = null;
            BitSet targetTraits = null;
            if (source instanceof Thing) {
                sourceTraits = ((TraitableBean)((Thing)source).getCore()).getCurrentTypeCode();
                if (sourceTraits == null && source instanceof TraitType) {
                    x = ((ReteooRuleBase)workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                    sourceTraits = x.getCode(((TraitType)source).getTraitName());
                }
            } else if (source instanceof TraitableBean) {
                sourceTraits = ((TraitableBean)source).getCurrentTypeCode();
            } else if (source instanceof String) {
                x = ((ReteooRuleBase)workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                sourceTraits = x.getCode((String)source);
            } else {
                tbean = this.lookForWrapper(source, workingMemory);
                if (tbean != null) {
                    sourceTraits = tbean.getCurrentTypeCode();
                }
            }
            if (target instanceof Class) {
                x = ((ReteooRuleBase)workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                targetTraits = x.getCode(((Class)target).getName());
            } else if (target instanceof String) {
                x = ((ReteooRuleBase)workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                targetTraits = x.getCode((String)target);
            } else if (target instanceof Thing) {
                targetTraits = ((TraitableBean)((Thing)target).getCore()).getCurrentTypeCode();
                if (targetTraits == null && target instanceof TraitType) {
                    x = ((ReteooRuleBase)workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
                    targetTraits = x.getCode(((TraitType)target).getTraitName());
                }
            } else if (target instanceof TraitableBean) {
                targetTraits = ((TraitableBean)target).getCurrentTypeCode();
            } else {
                tbean = this.lookForWrapper(target, workingMemory);
                if (tbean != null) {
                    targetTraits = tbean.getCurrentTypeCode();
                }
            }
            if (sourceTraits == null || targetTraits == null) {
                return this.getOperator().isNegated();
            }
            return this.isA(sourceTraits, targetTraits) ^ this.getOperator().isNegated();
        }

        private boolean isA(BitSet sourceTraits, BitSet targetTraits) {
            if (sourceTraits == null) {
                return false;
            }
            if (targetTraits == null) {
                return true;
            }
            return HierarchyEncoderImpl.supersetOrEqualset(sourceTraits, targetTraits);
        }

        @Override
        public String toString() {
            return "IsAEvaluatorDefinition isA";
        }
    }
}

