/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.UpdateContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufInputMarshaller;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.FromNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.From;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.index.LeftTupleList;

public class FromNode
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory {
    private static final long serialVersionUID = 510L;
    protected DataProvider dataProvider;
    protected AlphaNodeFieldConstraint[] alphaConstraints;
    protected BetaConstraints betaConstraints;
    protected LeftTupleSinkNode previousTupleSinkNode;
    protected LeftTupleSinkNode nextTupleSinkNode;
    protected From from;
    protected Class<?> resultClass;
    protected boolean tupleMemoryEnabled;
    protected transient ObjectTypeConf objectTypeConf;

    public FromNode() {
    }

    public FromNode(int id, DataProvider dataProvider, LeftTupleSource tupleSource, AlphaNodeFieldConstraint[] constraints, BetaConstraints binder, boolean tupleMemoryEnabled, BuildContext context, From from) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.dataProvider = dataProvider;
        this.setLeftTupleSource(tupleSource);
        this.alphaConstraints = constraints;
        this.betaConstraints = binder == null ? EmptyBetaConstraints.getInstance() : binder;
        this.tupleMemoryEnabled = tupleMemoryEnabled;
        this.from = from;
        this.resultClass = ((ClassObjectType)this.from.getResultPattern().getObjectType()).getClassType();
        this.initMasks(context, tupleSource);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.dataProvider = (DataProvider)in.readObject();
        this.alphaConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.betaConstraints = (BetaConstraints)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.from = (From)in.readObject();
        this.resultClass = ((ClassObjectType)this.from.getResultPattern().getObjectType()).getClassType();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.dataProvider);
        out.writeObject(this.alphaConstraints);
        out.writeObject(this.betaConstraints);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.from);
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public AlphaNodeFieldConstraint[] getAlphaConstraints() {
        return this.alphaConstraints;
    }

    public BetaConstraints getBetaConstraints() {
        return this.betaConstraints;
    }

    public Class<?> getResultClass() {
        return this.resultClass;
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    public RightTuple createRightTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, Object object) {
        ProtobufInputMarshaller.TupleKey key;
        List list;
        Map map;
        ProtobufMessages.FactHandle _handle = null;
        if (this.objectTypeConf == null) {
            this.objectTypeConf = new ClassObjectTypeConf(workingMemory.getEntryPoint(), this.resultClass, (InternalRuleBase)workingMemory.getRuleBase());
        }
        if (context.getReaderContext() != null && (map = (Map)context.getReaderContext().nodeMemories.get(this.getId())) != null && (list = (List)map.get(key = PersisterHelper.createTupleKey(leftTuple))) != null && !list.isEmpty()) {
            _handle = (ProtobufMessages.FactHandle)((LinkedList)list).removeFirst();
            if (list.isEmpty()) {
                map.remove(key);
            }
        }
        InternalFactHandle handle = _handle != null ? workingMemory.getFactHandleFactory().newFactHandle(_handle.getId(), object, _handle.getRecency(), this.objectTypeConf, workingMemory, null) : workingMemory.getFactHandleFactory().newFactHandle(object, this.objectTypeConf, workingMemory, null);
        RightTuple rightTuple = this.newRightTuple(handle, null);
        return rightTuple;
    }

    protected RightTuple newRightTuple(InternalFactHandle handle, Object o) {
        return new RightTuple(handle, null);
    }

    public void addToCreatedHandlesMap(Map<Object, RightTuple> matches, RightTuple rightTuple) {
        if (rightTuple.getFactHandle().isValid()) {
            Object object = rightTuple.getFactHandle().getObject();
            RightTuple existingMatch = matches.get(object);
            if (existingMatch != null) {
                rightTuple.setNext(existingMatch);
            }
            matches.put(object, rightTuple);
        }
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        BetaMemory beta = new BetaMemory(new LeftTupleList(), null, this.betaConstraints.createContext(), 151);
        return new FromMemory(beta, this.dataProvider.createContext(), this.alphaConstraints);
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        FromNodeLeftTuple peer = new FromNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 151;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        return new FromNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void attach(BuildContext context) {
        this.betaConstraints.init(context, this.getType());
        this.leftInput.addTupleSink(this, context);
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
        }
    }

    public static class FromMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Serializable,
    Memory {
        private static final long serialVersionUID = 510L;
        public BetaMemory betaMemory;
        public Object providerContext;
        public ContextEntry[] alphaContexts;

        public FromMemory(BetaMemory betaMemory, Object providerContext, AlphaNodeFieldConstraint[] constraints) {
            this.betaMemory = betaMemory;
            this.providerContext = providerContext;
            this.alphaContexts = new ContextEntry[constraints.length];
            for (int i = 0; i < constraints.length; ++i) {
                this.alphaContexts[i] = constraints[i].createContextEntry();
            }
        }

        @Override
        public short getNodeType() {
            return 151;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.betaMemory.getSegmentMemory();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            this.betaMemory.setSegmentMemory(segmentMemory);
        }

        public BetaMemory getBetaMemory() {
            return this.betaMemory;
        }

        public void setBetaMemory(BetaMemory betaMemory) {
            this.betaMemory = betaMemory;
        }
    }
}

