/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.test.dsl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.test.dsl.ReteTesterHelper;
import org.drools.core.reteoo.test.dsl.Step;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EvalCondition;
import org.drools.core.spi.EvalExpression;
import org.drools.core.spi.Tuple;
import org.mockito.Mockito;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class EvalNodeStep
implements Step {
    public EvalNodeStep(ReteTesterHelper reteTesterHelper) {
    }

    @Override
    public void execute(Map<String, Object> context, List<String[]> args) {
        Object[] c;
        BuildContext buildContext = (BuildContext)context.get("BuildContext");
        if (args.size() == 1) {
            c = args.get(0);
            if (c.length != 3) {
                throw new IllegalArgumentException("Cannot execute arguments " + Arrays.toString(c));
            }
        } else {
            throw new IllegalArgumentException("Cannot execute arguments " + args);
        }
        String name = c[0].trim();
        String source = c[1].trim();
        String expr = ((String)c[2]).trim();
        LeftTupleSource pnode = null;
        pnode = source.startsWith("mock") ? (LeftTupleSource)Mockito.mock(LeftTupleSource.class) : (LeftTupleSource)context.get(source);
        EvalCondition eval = new EvalCondition((EvalExpression)new InstrumentedEvalExpression(expr, context), new Declaration[0]);
        EvalConditionNode evalNode = new EvalConditionNode(buildContext.getNextId(), pnode, eval, buildContext);
        evalNode.attach(buildContext);
        context.put(name, evalNode);
    }

    public static class InstrumentedEvalExpression
    implements EvalExpression {
        private String expr;
        private Map<String, Object> context;

        public InstrumentedEvalExpression(String expr, Map<String, Object> context) {
            this.expr = expr.replaceAll("h(\\d+)", "Handles[$1]");
            this.context = context;
        }

        public Object createContext() {
            return null;
        }

        public boolean evaluate(Tuple tuple, Declaration[] requiredDeclarations, WorkingMemory workingMemory, Object ctx) throws Exception {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.putAll(this.context);
            vars.put("tuple", ((LeftTuple)tuple).toFactHandles());
            ParserContext mvelctx = new ParserContext();
            Serializable compiled = MVEL.compileExpression((String)this.expr, (ParserContext)mvelctx);
            Boolean result = (Boolean)MVEL.executeExpression((Object)compiled, vars);
            return result;
        }

        public Declaration[] getRequiredDeclarations() {
            return null;
        }

        public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        }

        public EvalExpression clone() {
            return this;
        }
    }
}

