/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.EqualityKeyComparator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.ObjectHashMap;

public class TruthMaintenanceSystem {
    private StatefulKnowledgeSessionImpl wm;
    private NamedEntryPoint ep;
    private ObjectHashMap equalityKeyMap;
    private BeliefSystem beliefSystem;

    public TruthMaintenanceSystem() {
    }

    public TruthMaintenanceSystem(StatefulKnowledgeSessionImpl wm, NamedEntryPoint ep) {
        this.wm = wm;
        this.equalityKeyMap = new ObjectHashMap();
        this.equalityKeyMap.setComparator(EqualityKeyComparator.getInstance());
        this.beliefSystem = wm.getKnowledgeBase().getConfiguration().getComponentFactory().getBeliefSystemFactory().createBeliefSystem(wm.getSessionConfiguration().getBeliefSystemType(), ep, this);
    }

    public ObjectHashMap getEqualityKeyMap() {
        return this.equalityKeyMap;
    }

    public Object put(EqualityKey key) {
        return this.equalityKeyMap.put(key, key, false);
    }

    public EqualityKey get(EqualityKey key) {
        return (EqualityKey)this.equalityKeyMap.get(key);
    }

    public EqualityKey get(Object object) {
        return (EqualityKey)this.equalityKeyMap.get(object);
    }

    public EqualityKey remove(EqualityKey key) {
        return (EqualityKey)this.equalityKeyMap.remove(key);
    }

    public void readLogicalDependency(InternalFactHandle handle, Object object, Object value, Activation activation, PropagationContext context, RuleImpl rule, ObjectTypeConf typeConf) {
        this.addLogicalDependency(handle, object, value, activation, context, rule, typeConf, true);
    }

    public void addLogicalDependency(InternalFactHandle handle, Object object, Object value, Activation activation, PropagationContext context, RuleImpl rule, ObjectTypeConf typeConf) {
        this.addLogicalDependency(handle, object, value, activation, context, rule, typeConf, false);
    }

    public void addLogicalDependency(InternalFactHandle handle, Object object, Object value, Activation activation, PropagationContext context, RuleImpl rule, ObjectTypeConf typeConf, boolean read) {
        BeliefSet beliefSet = handle.getEqualityKey().getBeliefSet();
        if (beliefSet == null) {
            if (context.getType() == 2) {
                // empty if block
            }
            beliefSet = this.beliefSystem.newBeliefSet(handle);
            handle.getEqualityKey().setBeliefSet(beliefSet);
        }
        LogicalDependency node = this.beliefSystem.newLogicalDependency(activation, beliefSet, object, value);
        activation.getRule().setHasLogicalDependency(true);
        activation.addLogicalDependency(node);
        if (read) {
            this.beliefSystem.read(node, beliefSet, context, typeConf);
        } else {
            this.beliefSystem.insert(node, beliefSet, context, typeConf);
        }
    }

    public void clear() {
        this.equalityKeyMap.clear();
    }

    public BeliefSystem getBeliefSystem() {
        return this.beliefSystem;
    }
}

