/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.definitions.rule.impl;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.base.EnabledBoolean;
import org.drools.core.base.SalienceInteger;
import org.drools.core.base.mvel.MVELSalienceExpression;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.ConsequenceMetaData;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Dialectable;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.GroupElementFactory;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.LogicTransformer;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.CompiledInvoker;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.Enabled;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Salience;
import org.drools.core.spi.Tuple;
import org.drools.core.spi.Wireable;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.StringUtils;
import org.drools.core.util.asm.MethodComparator;
import org.kie.api.definition.KieDefinition;
import org.kie.api.definition.rule.Query;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.Resource;
import org.kie.internal.security.KiePolicyHelper;
import org.mvel2.asm.ClassReader;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.util.TraceMethodVisitor;

public class RuleImpl
implements Externalizable,
Wireable,
Dialectable,
Rule,
Query {
    public static final String DEFAULT_CONSEQUENCE_NAME = "default";
    private String pkg;
    private String name;
    private RuleImpl parent;
    private Salience salience;
    private boolean dirty;
    private Map<String, Declaration> declarations;
    private Map<String, String[]> requiredDeclarations = new HashMap<String, String[]>();
    private GroupElement lhsRoot;
    private String dialect;
    private String agendaGroup;
    private Map<String, Object> metaAttributes;
    private Consequence consequence;
    private Map<String, Consequence> namedConsequence;
    private Timer timer;
    private int loadOrder;
    private boolean noLoop;
    private boolean autoFocus;
    private String activationGroup;
    private String ruleFlowGroup;
    private boolean lockOnActive;
    private boolean hasLogicalDependency;
    private boolean semanticallyValid;
    private String[] calendars;
    private Calendar dateEffective;
    private Calendar dateExpires;
    private Enabled enabled;
    private Resource resource;
    private boolean eager;
    protected String activationListener;
    private ConsequenceMetaData consequenceMetaData = new ConsequenceMetaData();

    public RuleImpl() {
    }

    public RuleImpl(String name, String pkg, String agendaGroup) {
        this.name = name;
        this.pkg = pkg;
        this.agendaGroup = agendaGroup == null ? "MAIN" : agendaGroup;
        this.lhsRoot = GroupElementFactory.newAndInstance();
        this.semanticallyValid = true;
        this.enabled = EnabledBoolean.ENABLED_TRUE;
        this.salience = SalienceInteger.DEFAULT_SALIENCE;
        this.metaAttributes = new HashMap<String, Object>();
        this.setActivationListener("agenda");
    }

    public RuleImpl(String name, String agendaGroup) {
        this(name, null, agendaGroup);
    }

    public RuleImpl(String name) {
        this(name, null, "MAIN");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.pkg);
        out.writeObject(this.name);
        out.writeObject(this.parent);
        out.writeObject(this.salience);
        out.writeBoolean(this.dirty);
        out.writeObject(this.declarations);
        out.writeObject(this.lhsRoot);
        out.writeObject(this.dialect);
        out.writeObject(this.agendaGroup);
        out.writeObject(this.metaAttributes);
        out.writeObject(this.requiredDeclarations);
        if (this.consequence instanceof CompiledInvoker) {
            out.writeObject(null);
            out.writeObject(null);
        } else {
            out.writeObject(this.consequence);
            out.writeObject(this.namedConsequence);
        }
        out.writeObject(this.timer);
        out.writeInt(this.loadOrder);
        out.writeBoolean(this.noLoop);
        out.writeBoolean(this.autoFocus);
        out.writeObject(this.activationGroup);
        out.writeObject(this.ruleFlowGroup);
        out.writeBoolean(this.lockOnActive);
        out.writeBoolean(this.hasLogicalDependency);
        out.writeBoolean(this.semanticallyValid);
        out.writeObject(this.calendars);
        out.writeObject(this.dateEffective);
        out.writeObject(this.dateExpires);
        out.writeObject(this.enabled);
        out.writeObject(this.resource);
        out.writeObject(this.activationListener);
        out.writeObject(this.consequenceMetaData);
        out.writeBoolean(this.eager);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.pkg = (String)in.readObject();
        this.name = (String)in.readObject();
        this.parent = (RuleImpl)in.readObject();
        this.salience = (Salience)in.readObject();
        this.dirty = in.readBoolean();
        this.declarations = (Map)in.readObject();
        this.lhsRoot = (GroupElement)in.readObject();
        this.dialect = (String)in.readObject();
        this.agendaGroup = (String)in.readObject();
        this.metaAttributes = (Map)in.readObject();
        this.requiredDeclarations = (Map)in.readObject();
        this.consequence = (Consequence)in.readObject();
        this.namedConsequence = (Map)in.readObject();
        this.timer = (Timer)in.readObject();
        this.loadOrder = in.readInt();
        this.noLoop = in.readBoolean();
        this.autoFocus = in.readBoolean();
        this.activationGroup = (String)in.readObject();
        this.ruleFlowGroup = (String)in.readObject();
        this.lockOnActive = in.readBoolean();
        this.hasLogicalDependency = in.readBoolean();
        this.semanticallyValid = in.readBoolean();
        this.calendars = (String[])in.readObject();
        this.dateEffective = (Calendar)in.readObject();
        this.dateExpires = (Calendar)in.readObject();
        this.enabled = (Enabled)in.readObject();
        this.resource = (Resource)in.readObject();
        this.activationListener = (String)in.readObject();
        this.consequenceMetaData = (ConsequenceMetaData)in.readObject();
        this.eager = in.readBoolean();
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Override
    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public boolean isValid() {
        return this.consequence != null && this.isSemanticallyValid();
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }

    public String getPackageName() {
        return this.pkg;
    }

    public String getName() {
        return this.name;
    }

    public Salience getSalience() {
        return this.salience;
    }

    public void setSalience(Salience salience) {
        this.salience = salience;
        if (salience instanceof MVELSalienceExpression) {
            this.eager = true;
        }
    }

    public String getAgendaGroup() {
        if (this.agendaGroup.equals("")) {
            return "MAIN";
        }
        return this.agendaGroup;
    }

    public void setAgendaGroup(String agendaGroup) {
        this.agendaGroup = agendaGroup;
    }

    public boolean isNoLoop() {
        return this.noLoop;
    }

    public boolean isEffective(Tuple tuple, RuleTerminalNode rtn, WorkingMemory workingMemory) {
        if (!this.enabled.getValue(tuple, rtn.getEnabledDeclarations(), this, workingMemory)) {
            return false;
        }
        if (this.dateEffective == null && this.dateExpires == null) {
            return true;
        }
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(workingMemory.getSessionClock().getCurrentTime());
        if (this.dateEffective != null && this.dateExpires != null) {
            return now.after(this.dateEffective) && now.before(this.dateExpires);
        }
        if (this.dateEffective != null) {
            return now.after(this.dateEffective);
        }
        return now.before(this.dateExpires);
    }

    public void setNoLoop(boolean noLoop) {
        this.noLoop = noLoop;
    }

    public boolean getAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
        this.eager = autoFocus;
    }

    public String getActivationGroup() {
        return this.activationGroup;
    }

    public void setActivationGroup(String activationGroup) {
        this.activationGroup = activationGroup;
        this.eager = !StringUtils.isEmpty(activationGroup);
    }

    public String getRuleFlowGroup() {
        return this.ruleFlowGroup;
    }

    public void setRuleFlowGroup(String ruleFlowGroup) {
        this.ruleFlowGroup = ruleFlowGroup;
    }

    public Declaration getDeclaration(String identifier) {
        if (this.dirty || this.declarations == null) {
            this.declarations = this.getExtendedLhs(this, null).getOuterDeclarations();
            this.dirty = false;
        }
        return this.declarations.get(identifier);
    }

    public String[] getRequiredDeclarationsForConsequence(String consequenceName) {
        String[] declarations = this.requiredDeclarations.get(consequenceName);
        return declarations != null ? declarations : new String[]{};
    }

    public void setRequiredDeclarationsForConsequence(String consequenceName, String[] requiredDeclarations) {
        this.requiredDeclarations.put(consequenceName, requiredDeclarations);
    }

    public boolean hasLogicalDependency() {
        return this.hasLogicalDependency;
    }

    public void setHasLogicalDependency(boolean hasLogicalDependency) {
        this.hasLogicalDependency = hasLogicalDependency;
    }

    public boolean isLockOnActive() {
        return this.lockOnActive;
    }

    public void setLockOnActive(boolean lockOnActive) {
        this.lockOnActive = lockOnActive;
    }

    public Map<String, Declaration> getDeclarations() {
        if (this.dirty || this.declarations == null) {
            this.declarations = this.getExtendedLhs(this, null).getOuterDeclarations();
            this.dirty = false;
        }
        return this.declarations;
    }

    public void addPattern(RuleConditionElement element) {
        this.dirty = true;
        this.lhsRoot.addChild(element);
    }

    public GroupElement getLhs() {
        return this.lhsRoot;
    }

    public void setLhs(GroupElement lhsRoot) {
        this.dirty = true;
        this.lhsRoot = lhsRoot;
    }

    private GroupElement getExtendedLhs(RuleImpl rule, GroupElement fromChild) {
        GroupElement lhs = rule.lhsRoot.cloneOnlyGroup();
        if (null != fromChild) {
            lhs.getChildren().addAll(fromChild.getChildren());
        }
        if (rule.parent != null) {
            return this.getExtendedLhs(rule.parent, lhs);
        }
        return lhs;
    }

    public GroupElement[] getTransformedLhs(LogicTransformer transformer) throws InvalidPatternException {
        return transformer.transform(this.getExtendedLhs(this, null));
    }

    public int getSpecifity() {
        return this.getSpecifity(this.lhsRoot);
    }

    private int getSpecifity(GroupElement ce) {
        int specificity = 0;
        for (RuleConditionElement object : ce.getChildren()) {
            if (object instanceof Pattern) {
                specificity += this.getSpecifity((Pattern)object);
                continue;
            }
            if (!(object instanceof GroupElement)) continue;
            specificity += this.getSpecifity((GroupElement)object);
        }
        return specificity;
    }

    private int getSpecifity(Pattern pattern) {
        int specificity = 0;
        for (Constraint constraint : pattern.getConstraints()) {
            if (constraint instanceof Declaration) continue;
            ++specificity;
        }
        return specificity;
    }

    @Override
    public void wire(Object object) {
        if (object instanceof Consequence) {
            Consequence c;
            Consequence consequence = c = KiePolicyHelper.isPolicyEnabled() ? new SafeConsequence((Consequence)object) : (Consequence)object;
            if (DEFAULT_CONSEQUENCE_NAME.equals(c.getName())) {
                this.setConsequence(c);
            } else {
                this.addNamedConsequence(c.getName(), c);
            }
        } else if (object instanceof Salience) {
            this.setSalience(KiePolicyHelper.isPolicyEnabled() ? new SafeSalience((Salience)object) : (Salience)object);
        } else if (object instanceof Enabled) {
            this.setEnabled(KiePolicyHelper.isPolicyEnabled() ? new SafeEnabled((Enabled)object) : (Enabled)object);
        }
    }

    public void setConsequence(Consequence consequence) {
        this.consequence = consequence;
    }

    public Consequence getConsequence() {
        return this.consequence;
    }

    public boolean hasNamedConsequences() {
        return this.namedConsequence != null && !this.namedConsequence.isEmpty();
    }

    public Map<String, Consequence> getNamedConsequences() {
        return this.namedConsequence;
    }

    public Consequence getNamedConsequence(String consequenceName) {
        return this.namedConsequence.get(consequenceName);
    }

    public void addNamedConsequence(String name, Consequence consequence) {
        if (this.namedConsequence == null) {
            this.namedConsequence = new HashMap<String, Consequence>();
        }
        this.namedConsequence.put(name, consequence);
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }

    public void setLoadOrder(int loadOrder) {
        this.loadOrder = loadOrder;
    }

    public boolean isEager() {
        return this.eager;
    }

    public void setEager(boolean eager) {
        this.eager = eager;
    }

    public String toString() {
        return "[Rule name=" + this.name + ", agendaGroup=" + this.agendaGroup + ", salience=" + this.salience + ", no-loop=" + this.noLoop + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pkg == null ? 0 : this.pkg.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RuleImpl other = (RuleImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.pkg == null ? other.pkg != null : !this.pkg.equals(other.pkg));
    }

    public void setSemanticallyValid(boolean valid) {
        this.semanticallyValid = valid;
    }

    public boolean isSemanticallyValid() {
        return this.semanticallyValid;
    }

    public String[] getCalendars() {
        return this.calendars;
    }

    public void setCalendars(String[] calendars) {
        this.calendars = calendars;
    }

    public void setDateEffective(Calendar effectiveDate) {
        this.dateEffective = effectiveDate;
    }

    public void setDateExpires(Calendar expiresDate) {
        this.dateExpires = expiresDate;
    }

    public Calendar getDateEffective() {
        return this.dateEffective;
    }

    public Calendar getDateExpires() {
        return this.dateExpires;
    }

    public void setEnabled(Enabled b) {
        this.enabled = b;
    }

    public Enabled getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled(Tuple tuple, RuleTerminalNode rtn, WorkingMemory workingMemory) {
        return this.enabled.getValue(tuple, rtn.getEnabledDeclarations(), this, workingMemory);
    }

    public void addMetaAttribute(String key, Object value) {
        this.metaAttributes.put(key, value);
    }

    public String getActivationListener() {
        return this.activationListener;
    }

    public void setActivationListener(String activationListener) {
        this.activationListener = activationListener;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaAttributes);
    }

    @Deprecated
    public Map<String, Object> getMetaAttributes() {
        return Collections.unmodifiableMap(this.metaAttributes);
    }

    @Deprecated
    public String getMetaAttribute(String identifier) {
        return this.metaAttributes.get(identifier).toString();
    }

    @Deprecated
    public Collection<String> listMetaAttributes() {
        return this.metaAttributes.keySet();
    }

    public void setParent(RuleImpl parent) {
        this.parent = parent;
    }

    public RuleImpl getParent() {
        return this.parent;
    }

    public static List getMethodBytecode(Class cls, String ruleClassName, String packageName, String methodName, String resource) {
        MethodComparator.Tracer visit = new MethodComparator.Tracer(methodName);
        InputStream is = cls.getClassLoader().getResourceAsStream(resource);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int byteCount;
            byte[] data = new byte[1024];
            while ((byteCount = is.read(data, 0, 1024)) > -1) {
                bos.write(data, 0, byteCount);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable getResourceAsStream for Class '" + ruleClassName + "' ");
        }
        ClassReader classReader = new ClassReader(bos.toByteArray());
        classReader.accept((ClassVisitor)visit, 2);
        TraceMethodVisitor trace = visit.getTrace();
        return trace.getText();
    }

    public boolean isQuery() {
        return false;
    }

    public KieDefinition.KnowledgeType getKnowledgeType() {
        return KieDefinition.KnowledgeType.RULE;
    }

    public String getNamespace() {
        return this.getPackage();
    }

    public String getId() {
        return this.getName();
    }

    public ConsequenceMetaData getConsequenceMetaData() {
        return this.consequenceMetaData;
    }

    public static class SafeEnabled
    implements Enabled,
    Serializable {
        private static final long serialVersionUID = -8361753962814039574L;
        private final Enabled delegate;

        public SafeEnabled(Enabled delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean getValue(final Tuple tuple, final Declaration[] declrs, final RuleImpl rule, final WorkingMemory workingMemory) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return SafeEnabled.this.delegate.getValue(tuple, declrs, rule, workingMemory);
                }
            }, KiePolicyHelper.getAccessContext());
        }
    }

    public static class SafeSalience
    implements Salience,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Salience delegate;

        public SafeSalience(Salience delegate) {
            this.delegate = delegate;
        }

        @Override
        public int getValue(final KnowledgeHelper khelper, final Rule rule, final WorkingMemory workingMemory) {
            return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    return SafeSalience.this.delegate.getValue(khelper, rule, workingMemory);
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public int getValue() {
            return this.delegate.getValue();
        }

        @Override
        public boolean isDynamic() {
            return this.delegate.isDynamic();
        }
    }

    public static class SafeConsequence
    implements Consequence,
    Serializable {
        private static final long serialVersionUID = -8109957972163261899L;
        private final Consequence delegate;

        public SafeConsequence(Consequence delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public void evaluate(final KnowledgeHelper knowledgeHelper, final WorkingMemory workingMemory) throws Exception {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    SafeConsequence.this.delegate.evaluate(knowledgeHelper, workingMemory);
                    return null;
                }
            }, KiePolicyHelper.getAccessContext());
        }
    }
}

