/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Collection;
import org.drools.core.common.BaseNode;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.Sink;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.runtime.KnowledgeRuntime;

public class ReteDumper {
    private ReteDumper() {
    }

    public static void dumpRete(KnowledgeBase kbase) {
        ReteDumper.dumpRete((InternalKnowledgeBase)kbase);
    }

    public static void dumpRete(KnowledgeRuntime session) {
        ReteDumper.dumpRete((InternalKnowledgeBase)session.getKieBase());
    }

    public static void dumpRete(InternalKnowledgeBase kBase) {
        ReteDumper.dumpRete(kBase.getRete());
    }

    public static void dumpRete(Rete rete) {
        for (EntryPointNode entryPointNode : rete.getEntryPointNodes().values()) {
            ReteDumper.dumpNode((BaseNode)entryPointNode, "");
        }
    }

    private static void dumpNode(BaseNode node, String ident) {
        EntryPointNode source;
        System.out.println(ident + node);
        ObjectSink[] sinks = null;
        if (node instanceof EntryPointNode) {
            source = (EntryPointNode)node;
            Collection otns = source.getObjectTypeNodes().values();
            sinks = otns.toArray(new Sink[otns.size()]);
        } else if (node instanceof ObjectSource) {
            source = (ObjectSource)node;
            sinks = source.getSinkPropagator().getSinks();
        } else if (node instanceof LeftTupleSource) {
            source = (LeftTupleSource)node;
            sinks = source.getSinkPropagator().getSinks();
        }
        if (sinks != null) {
            for (ObjectSink sink : sinks) {
                if (!(sink instanceof BaseNode)) continue;
                ReteDumper.dumpNode((BaseNode)sink, ident + "    ");
            }
        }
    }
}

