/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.TimerServiceFactory;
import org.drools.core.time.Trigger;
import org.junit.Assert;
import org.junit.Test;

public class JDKTimerServiceTest {
    @Test
    public void testSingleExecutionJob() throws Exception {
        SessionConfiguration config = new SessionConfiguration();
        config.setClockType(ClockType.REALTIME_CLOCK);
        TimerService timeService = TimerServiceFactory.getTimerService((SessionConfiguration)config);
        DelayedTrigger trigger = new DelayedTrigger(100L);
        HelloWorldJobContext ctx = new HelloWorldJobContext("hello world", timeService);
        timeService.scheduleJob((Job)new HelloWorldJob(), (JobContext)ctx, (Trigger)trigger);
        Thread.sleep(500L);
        timeService.shutdown();
        Assert.assertEquals((long)1L, (long)ctx.getList().size());
    }

    @Test
    public void testRepeatedExecutionJob() throws Exception {
        SessionConfiguration config = new SessionConfiguration();
        config.setClockType(ClockType.REALTIME_CLOCK);
        TimerService timeService = TimerServiceFactory.getTimerService((SessionConfiguration)config);
        DelayedTrigger trigger = new DelayedTrigger(new long[]{100L, 100L, 100L});
        HelloWorldJobContext ctx = new HelloWorldJobContext("hello world", timeService);
        timeService.scheduleJob((Job)new HelloWorldJob(), (JobContext)ctx, (Trigger)trigger);
        Thread.sleep(500L);
        timeService.shutdown();
        Assert.assertEquals((long)3L, (long)ctx.getList().size());
    }

    @Test
    public void testRepeatedExecutionJobWithRemove() throws Exception {
        SessionConfiguration config = new SessionConfiguration();
        config.setClockType(ClockType.REALTIME_CLOCK);
        TimerService timeService = TimerServiceFactory.getTimerService((SessionConfiguration)config);
        DelayedTrigger trigger = new DelayedTrigger(new long[]{100L, 100L, 100L, 100L, 100L, 100L, 100L, 100L});
        HelloWorldJobContext ctx = new HelloWorldJobContext("hello world", timeService);
        ctx.setLimit(3);
        timeService.scheduleJob((Job)new HelloWorldJob(), (JobContext)ctx, (Trigger)trigger);
        Thread.sleep(1000L);
        timeService.shutdown();
        Assert.assertEquals((long)5L, (long)ctx.getList().size());
    }

    public static class DelayedTrigger
    implements Trigger {
        private Stack<Date> stack = new Stack();

        public DelayedTrigger(long delay) {
            this(new long[]{delay});
        }

        public DelayedTrigger(long[] delay) {
            for (int i = delay.length - 1; i >= 0; --i) {
                this.stack.push(new Date(new Date().getTime() + delay[i]));
            }
        }

        public Date hasNextFireTime() {
            return this.stack.isEmpty() ? null : this.stack.peek();
        }

        public Date nextFireTime() {
            return this.stack.isEmpty() ? null : this.stack.pop();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.stack = (Stack)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.stack);
        }
    }

    public static class HelloWorldJobContext
    implements JobContext {
        private String message;
        private TimerService timeService;
        private JobHandle jobHandle;
        private List list;
        private int counter;
        private int limit;

        public HelloWorldJobContext(String message, TimerService timeService) {
            this.message = message;
            this.timeService = timeService;
            this.list = new ArrayList();
        }

        public String getMessage() {
            return this.message;
        }

        public int increaseCounter() {
            return this.counter++;
        }

        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public List getList() {
            return this.list;
        }
    }

    public static class HelloWorldJob
    implements Job {
        public void execute(JobContext c) {
            HelloWorldJobContext ctx = (HelloWorldJobContext)c;
            int counter = ctx.increaseCounter();
            if (counter > 3) {
                ctx.timeService.removeJob(ctx.getJobHandle());
            }
            ctx.getList().add(ctx.getMessage() + " : " + counter);
        }
    }
}

