/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.UpdateCommand;
import org.drools.core.common.DisconnectedFactHandle;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.FactHandle;

public class CommandSerializationTest {
    @Test
    public void updateCommandTest() throws Exception {
        DisconnectedFactHandle discFactHandle = new DisconnectedFactHandle(2, 3, 4, 5L, "entry-point-id", (Object)"str-obj", true);
        DisconnectedFactHandle copyDiscFactHandle = this.roundTrip(discFactHandle, DisconnectedFactHandle.class);
        this.verifyDisconnectedFactHandle(discFactHandle, copyDiscFactHandle);
        UpdateCommand cmd = new UpdateCommand((FactHandle)discFactHandle, (Object)"new-str-object");
        UpdateCommand copyCmd = this.roundTrip(cmd, UpdateCommand.class);
        this.verifyDisconnectedFactHandle(discFactHandle, copyCmd.getHandle());
        Assert.assertEquals((String)"entry point", (Object)cmd.getEntryPoint(), (Object)copyCmd.getEntryPoint());
        Assert.assertEquals((String)"object", (Object)cmd.getObject(), (Object)copyCmd.getObject());
    }

    @Test
    public void insertObjectCommandTest() throws Exception {
        InsertObjectCommand cmd = new InsertObjectCommand((Object)"obj", "out-id");
        cmd.setReturnObject(false);
        cmd.setEntryPoint("entry-point");
        InsertObjectCommand copyCmd = this.roundTrip(cmd, InsertObjectCommand.class);
        Assert.assertEquals((String)"object", (Object)cmd.getObject(), (Object)copyCmd.getObject());
        Assert.assertEquals((String)"out id", (Object)cmd.getOutIdentifier(), (Object)copyCmd.getOutIdentifier());
        Assert.assertEquals((String)"return obj", (Object)cmd.isReturnObject(), (Object)copyCmd.isReturnObject());
        Assert.assertEquals((String)"entry point", (Object)cmd.getEntryPoint(), (Object)copyCmd.getEntryPoint());
        Assert.assertEquals((String)"disconnected", (Object)cmd.isDisconnected(), (Object)copyCmd.isDisconnected());
    }

    private void verifyDisconnectedFactHandle(DisconnectedFactHandle orig, DisconnectedFactHandle copy) {
        Assert.assertNotNull((String)"copy disconnected fact handle is null", (Object)copy);
        Assert.assertEquals((String)"id", (long)orig.getId(), (long)copy.getId());
        Assert.assertEquals((String)"identity hash code", (long)orig.getIdentityHashCode(), (long)copy.getIdentityHashCode());
        Assert.assertEquals((String)"object hash code", (long)orig.getObjectHashCode(), (long)copy.getObjectHashCode());
        Assert.assertEquals((String)"recency", (long)orig.getRecency(), (long)copy.getRecency());
        Assert.assertEquals((String)"entry point id", (Object)orig.getEntryPointId(), (Object)copy.getEntryPointId());
        Assert.assertEquals((String)"object", (Object)orig.getObject(), (Object)copy.getObject());
        Assert.assertEquals((String)"trait type", (Object)orig.getTraitType(), (Object)copy.getTraitType());
    }

    private <T> T roundTrip(Object obj, Class<T> objClass) throws Exception {
        Class[] classes = new Class[]{objClass};
        JAXBContext ctx = this.getJaxbContext(classes);
        String xmlOut = this.marshall(ctx, obj);
        return this.unmarshall(ctx, xmlOut, objClass);
    }

    private <T> T unmarshall(JAXBContext ctx, String xmlIn, Class<T> objClass) throws Exception {
        ByteArrayInputStream xmlStrInputStream = new ByteArrayInputStream(xmlIn.getBytes(Charset.forName("UTF-8")));
        Object out = ctx.createUnmarshaller().unmarshal((InputStream)xmlStrInputStream);
        return (T)out;
    }

    private String marshall(JAXBContext ctx, Object obj) throws Exception {
        StringWriter writer = new StringWriter();
        ctx.createMarshaller().marshal(obj, (Writer)writer);
        return writer.getBuffer().toString();
    }

    private JAXBContext getJaxbContext(Class ... classes) throws Exception {
        return JAXBContext.newInstance((Class[])classes);
    }
}

