/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule.constraint;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.builder.dialect.asm.ClassGenerator;
import org.drools.core.rule.builder.dialect.asm.GeneratorHelper;
import org.drools.core.rule.constraint.ConditionAnalyzer;
import org.drools.core.rule.constraint.ConditionEvaluator;
import org.drools.core.rule.constraint.EvaluatorHelper;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.util.NullType;

public class ASMConditionEvaluatorJitter {
    public static ConditionEvaluator jitEvaluator(String expression, ConditionAnalyzer.Condition condition, Declaration[] declarations, ClassLoader classLoader, LeftTuple leftTuple) {
        ClassGenerator generator = new ClassGenerator(ASMConditionEvaluatorJitter.getUniqueClassName(), classLoader).setInterfaces(ConditionEvaluator.class).addStaticField(18, "EXPRESSION", String.class, expression).addField(18, "declarations", Declaration[].class).addDefaultConstructor(new ClassGenerator.MethodBody(){

            @Override
            public void body(MethodVisitor mv) {
                this.putFieldInThisFromRegistry("declarations", Declaration[].class, 1);
                mv.visitInsn(177);
            }
        }, Declaration[].class);
        generator.addMethod(1, "evaluate", generator.methodDescr(Boolean.TYPE, InternalFactHandle.class, InternalWorkingMemory.class, LeftTuple.class), new EvaluateMethodGenerator(condition, declarations, leftTuple));
        return (ConditionEvaluator)generator.newInstance(Declaration[].class, declarations);
    }

    private static String getUniqueClassName() {
        return ASMConditionEvaluatorJitter.getUniqueName("ConditionEvaluator");
    }

    private static String getUniqueName(String prefix) {
        return prefix + StringUtils.generateUUID();
    }

    private static class EvaluateMethodGenerator
    extends GeneratorHelper.DeclarationAccessorMethod {
        private static final int LEFT_OPERAND = 5;
        private static final int RIGHT_OPERAND = 7;
        private static final int ARGUMENTS = 9;
        private final ConditionAnalyzer.Condition condition;
        private final Declaration[] declarations;
        private final LeftTuple leftTuple;
        private int[] declPositions;

        public EvaluateMethodGenerator(ConditionAnalyzer.Condition condition, Declaration[] declarations, LeftTuple leftTuple) {
            this.condition = condition;
            this.declarations = declarations;
            this.leftTuple = leftTuple;
        }

        @Override
        public void body(MethodVisitor mv) {
            this.jitArguments();
            this.jitCondition(this.condition);
            mv.visitInsn(172);
        }

        private void jitArguments() {
            if (this.declarations == null || this.declarations.length == 0) {
                return;
            }
            this.declPositions = new int[this.declarations.length];
            List<GeneratorHelper.DeclarationMatcher> declarationMatchers = GeneratorHelper.matchDeclarationsToTuple(this.declarations);
            LeftTuple currentLeftTuple = this.leftTuple;
            this.mv.visitVarInsn(25, 3);
            this.store(4, LeftTuple.class);
            int decPos = 9;
            for (GeneratorHelper.DeclarationMatcher declarationMatcher : declarationMatchers) {
                int i = declarationMatcher.getOriginalIndex();
                if (currentLeftTuple == null || declarationMatcher.getRootDistance() > currentLeftTuple.getIndex()) {
                    this.getFieldFromThis("declarations", Declaration[].class);
                    this.push(i);
                    this.mv.visitInsn(50);
                    this.mv.visitVarInsn(25, 2);
                    this.mv.visitVarInsn(25, 1);
                    this.invokeInterface(InternalFactHandle.class, "getObject", Object.class, new Class[0]);
                    this.declPositions[i] = decPos;
                    decPos += this.storeObjectFromDeclaration(declarationMatcher.getDeclaration(), decPos);
                    continue;
                }
                currentLeftTuple = this.traverseTuplesUntilDeclaration(currentLeftTuple, declarationMatcher.getRootDistance(), 4);
                this.getFieldFromThis("declarations", Declaration[].class);
                this.push(i);
                this.mv.visitInsn(50);
                this.mv.visitVarInsn(25, 2);
                this.load(4);
                this.invokeInterface(LeftTuple.class, "getHandle", InternalFactHandle.class, new Class[0]);
                this.invokeInterface(InternalFactHandle.class, "getObject", Object.class, new Class[0]);
                this.declPositions[i] = decPos;
                decPos += this.storeObjectFromDeclaration(declarationMatcher.getDeclaration(), decPos);
            }
        }

        private void jitCondition(ConditionAnalyzer.Condition condition) {
            if (condition instanceof ConditionAnalyzer.FixedValueCondition) {
                this.mv.visitInsn(((ConditionAnalyzer.FixedValueCondition)condition).getFixedValue() ? 4 : 3);
                return;
            }
            if (condition instanceof ConditionAnalyzer.SingleCondition) {
                this.jitSingleCondition((ConditionAnalyzer.SingleCondition)condition);
            } else {
                this.jitCombinedCondition((ConditionAnalyzer.CombinedCondition)condition);
            }
            if (condition.isNegated()) {
                this.jitNegation();
            }
        }

        private void jitSingleCondition(ConditionAnalyzer.SingleCondition singleCondition) {
            if (singleCondition.isBinary()) {
                switch (singleCondition.getOperation()) {
                    case MATCHES: {
                        this.jitMatches(singleCondition);
                        break;
                    }
                    case INSTANCEOF: {
                        this.jitInstanceof(singleCondition);
                        break;
                    }
                    default: {
                        this.jitBinary(singleCondition);
                        break;
                    }
                }
            } else {
                this.jitUnary(singleCondition);
            }
        }

        private void jitCombinedCondition(ConditionAnalyzer.CombinedCondition combinedCondition) {
            boolean isAnd = combinedCondition.isAnd();
            Label shortcut = new Label();
            Label noShortcut = new Label();
            for (ConditionAnalyzer.Condition condition : combinedCondition.getConditions()) {
                this.jitCondition(condition);
                this.mv.visitJumpInsn(isAnd ? 153 : 154, shortcut);
            }
            this.mv.visitInsn(isAnd ? 4 : 3);
            this.mv.visitJumpInsn(167, noShortcut);
            this.mv.visitLabel(shortcut);
            this.mv.visitInsn(isAnd ? 3 : 4);
            this.mv.visitLabel(noShortcut);
        }

        private void jitUnary(ConditionAnalyzer.SingleCondition singleCondition) {
            this.jitExpression(singleCondition.getLeft());
        }

        private void jitBinary(ConditionAnalyzer.SingleCondition singleCondition) {
            Class<Comparable> commonType;
            ConditionAnalyzer.Expression left = singleCondition.getLeft();
            ConditionAnalyzer.Expression right = singleCondition.getRight();
            Class clazz = singleCondition.getOperation().needsSameType() ? this.findCommonClass(left.getType(), !left.canBeNull(), right.getType(), !right.canBeNull(), singleCondition.getOperation().isEquality()) : (commonType = null);
            if (commonType == Object.class && singleCondition.getOperation().isComparison()) {
                commonType = Comparable.class;
            }
            if (commonType != null && commonType.isPrimitive()) {
                this.jitPrimitiveBinary(singleCondition, left, right, commonType);
            } else {
                this.jitObjectBinary(singleCondition, left, right, commonType);
            }
        }

        private void jitMatches(ConditionAnalyzer.SingleCondition singleCondition) {
            if (!(singleCondition.getRight() instanceof ConditionAnalyzer.FixedExpression)) {
                this.jitBinary(singleCondition);
                return;
            }
            final String matchingString = ((ConditionAnalyzer.FixedExpression)singleCondition.getRight()).getValue().toString();
            final String patternVariableName = ASMConditionEvaluatorJitter.getUniqueName("pattern");
            this.getClassGenerator().addStaticField(18, patternVariableName, Pattern.class, null);
            this.getClassGenerator().addStaticInitBlock(new ClassGenerator.MethodBody(){

                @Override
                public void body(MethodVisitor mv) {
                    mv.visitLdcInsn((Object)matchingString);
                    this.invokeStatic(Pattern.class, "compile", Pattern.class, String.class);
                    this.putStaticField(patternVariableName, Pattern.class);
                }
            });
            this.jitExpression(singleCondition.getLeft(), String.class);
            this.store(5, singleCondition.getLeft().getType());
            Label notNullLabel = this.jitLeftIsNull(singleCondition.getLeft().getType() == String.class ? this.jitNullSafeOperationStart() : this.jitNullSafeCoercion(singleCondition.getLeft().getType(), String.class));
            this.mv.visitInsn(3);
            Label nullEvaluation = new Label();
            this.mv.visitJumpInsn(167, nullEvaluation);
            this.mv.visitLabel(notNullLabel);
            this.getStaticField(patternVariableName, Pattern.class);
            this.load(5);
            this.invokeVirtual(Pattern.class, "matcher", Matcher.class, CharSequence.class);
            this.invokeVirtual(Matcher.class, "matches", Boolean.TYPE, new Class[0]);
            this.mv.visitLabel(nullEvaluation);
        }

        private void jitInstanceof(ConditionAnalyzer.SingleCondition singleCondition) {
            Class value = (Class)((ConditionAnalyzer.FixedExpression)singleCondition.getRight()).getValue();
            String internalClassName = this.internalName(value);
            ConditionAnalyzer.Expression left = singleCondition.getLeft();
            Class<?> leftType = this.isDeclarationExpression(left) ? ClassUtils.convertFromPrimitiveType(left.getType()) : left.getType();
            this.jitExpression(left, leftType);
            this.mv.visitTypeInsn(193, internalClassName);
        }

        private void jitPrimitiveBinary(ConditionAnalyzer.SingleCondition singleCondition, ConditionAnalyzer.Expression left, ConditionAnalyzer.Expression right, Class<?> type) {
            if (ConditionAnalyzer.isFixed(right) && right.canBeNull()) {
                this.mv.visitInsn(singleCondition.getOperation() == ConditionAnalyzer.BooleanOperator.NE ? 4 : 3);
                return;
            }
            Label nullArg = new Label();
            this.ensureNotNullArgs(left, right, nullArg);
            this.jitExpression(left, type);
            this.castExpressionResultToPrimitive(left, type);
            this.jitExpression(right, type);
            this.castExpressionResultToPrimitive(right, type);
            this.jitPrimitiveOperation(singleCondition.getOperation(), type);
            Label nonNullArg = new Label();
            this.mv.visitJumpInsn(167, nonNullArg);
            this.mv.visitLabel(nullArg);
            this.mv.visitInsn(3);
            this.mv.visitLabel(nonNullArg);
        }

        private void ensureNotNullArgs(ConditionAnalyzer.Expression left, ConditionAnalyzer.Expression right, Label nullArg) {
            this.ensureNotNullArgs(left, nullArg);
            this.ensureNotNullArgs(right, nullArg);
        }

        private void ensureNotNullArgs(ConditionAnalyzer.Expression exp, Label nullArg) {
            if (exp instanceof ConditionAnalyzer.FixedExpression) {
                if (((ConditionAnalyzer.FixedExpression)exp).canBeNull()) {
                    this.mv.visitJumpInsn(167, nullArg);
                }
            } else if (exp instanceof ConditionAnalyzer.EvaluatedExpression) {
                if (!exp.getType().isPrimitive()) {
                    this.jitEvaluatedExpression((ConditionAnalyzer.EvaluatedExpression)exp, true, Object.class);
                    this.mv.visitJumpInsn(198, nullArg);
                }
            } else if (exp instanceof ConditionAnalyzer.VariableExpression) {
                if (!exp.getType().isPrimitive()) {
                    this.jitVariableExpression((ConditionAnalyzer.VariableExpression)exp);
                    this.mv.visitJumpInsn(198, nullArg);
                }
            } else if (exp instanceof ConditionAnalyzer.AritmeticExpression) {
                this.ensureNotNullInAritmeticExpression((ConditionAnalyzer.AritmeticExpression)exp, nullArg);
            }
        }

        private void ensureNotNullInAritmeticExpression(ConditionAnalyzer.AritmeticExpression aritmeticExpression, Label nullArg) {
            if (!aritmeticExpression.isStringConcat()) {
                this.ensureNotNullArgs(aritmeticExpression.left, nullArg);
                this.ensureNotNullArgs(aritmeticExpression.right, nullArg);
            }
        }

        private void castExpressionResultToPrimitive(ConditionAnalyzer.Expression expression, Class<?> type) {
            if (!ConditionAnalyzer.isFixed(expression)) {
                this.cast(expression.getType(), type);
            }
        }

        private void jitObjectBinary(ConditionAnalyzer.SingleCondition singleCondition, ConditionAnalyzer.Expression left, ConditionAnalyzer.Expression right, Class<?> type) {
            Class<?> leftType = this.isDeclarationExpression(left) ? ClassUtils.convertFromPrimitiveType(left.getType()) : left.getType();
            Class<?> rightType = this.isDeclarationExpression(right) ? ClassUtils.convertFromPrimitiveType(right.getType()) : right.getType();
            this.jitExpression(left, type != null ? type : leftType);
            if (this.isDeclarationExpression(left) && left.getType().isPrimitive()) {
                this.castFromPrimitive(left.getType());
            }
            this.store(5, leftType);
            this.jitExpression(right, type != null ? type : rightType);
            if (this.isDeclarationExpression(right) && right.getType().isPrimitive()) {
                this.castFromPrimitive(right.getType());
            }
            this.store(7, rightType);
            Label shortcutEvaluation = new Label();
            ConditionAnalyzer.BooleanOperator operation = singleCondition.getOperation();
            this.prepareLeftOperand(operation, type, leftType, rightType, shortcutEvaluation);
            this.prepareRightOperand(right, type, rightType, shortcutEvaluation);
            this.load(5);
            this.load(7);
            switch (operation) {
                case CONTAINS: {
                    if (leftType == String.class && CharSequence.class.isAssignableFrom(rightType)) {
                        this.invokeVirtual(String.class, "contains", Boolean.TYPE, CharSequence.class);
                        break;
                    }
                    this.invokeStatic(EvaluatorHelper.class, "contains", Boolean.TYPE, Object.class, rightType.isPrimitive() ? rightType : Object.class);
                    break;
                }
                case MATCHES: {
                    this.invokeVirtual(type, "matches", Boolean.TYPE, String.class);
                    break;
                }
                case SOUNDSLIKE: {
                    this.invokeStatic(EvaluatorHelper.class, "soundslike", Boolean.TYPE, String.class, String.class);
                    break;
                }
                default: {
                    if (operation.isEquality() && type != BigDecimal.class) {
                        if (type.isInterface()) {
                            this.invokeInterface(type, "equals", Boolean.TYPE, Object.class);
                        } else {
                            this.invokeVirtual(type, "equals", Boolean.TYPE, Object.class);
                        }
                    } else {
                        if (type.isInterface()) {
                            this.invokeInterface(type, "compareTo", Integer.TYPE, type == Comparable.class ? Object.class : this.findComparingClass(type));
                        } else {
                            this.invokeVirtual(type, "compareTo", Integer.TYPE, this.findComparingClass(type));
                        }
                        this.mv.visitInsn(3);
                        this.jitPrimitiveOperation(operation == ConditionAnalyzer.BooleanOperator.NE ? ConditionAnalyzer.BooleanOperator.EQ : operation, Integer.TYPE);
                    }
                    if (operation != ConditionAnalyzer.BooleanOperator.NE) break;
                    singleCondition.toggleNegation();
                }
            }
            this.mv.visitLabel(shortcutEvaluation);
        }

        private Class<?> findComparingClass(Class<?> type) {
            return this.findComparingClass(type, type);
        }

        private Class<?> findComparingClass(Class<?> type, Class<?> originalType) {
            if (type == null) {
                return originalType;
            }
            for (Type interfaze : type.getGenericInterfaces()) {
                Class<?> comparingClass = this.findComparingParameterClass(interfaze);
                if (comparingClass == null) continue;
                return comparingClass;
            }
            return this.findComparingClass(type.getSuperclass(), originalType);
        }

        private Class<?> findComparingParameterClass(Type interfaze) {
            ParameterizedType pType;
            if (interfaze instanceof ParameterizedType && (pType = (ParameterizedType)interfaze).getRawType() == Comparable.class) {
                return (Class)pType.getActualTypeArguments()[0];
            }
            if (interfaze instanceof Class) {
                for (Type superInterfaze : ((Class)interfaze).getGenericInterfaces()) {
                    Class<?> comparingClass = this.findComparingParameterClass(superInterfaze);
                    if (comparingClass == null) continue;
                    return comparingClass;
                }
            }
            return null;
        }

        private void prepareLeftOperand(ConditionAnalyzer.BooleanOperator operation, Class<?> type, Class<?> leftType, Class<?> rightType, Label shortcutEvaluation) {
            if (leftType.isPrimitive()) {
                if (type != null) {
                    this.castOrCoercePrimitive(5, leftType, type);
                }
                return;
            }
            Label notNullLabel = this.jitLeftIsNull(type == null || leftType == type ? this.jitNullSafeOperationStart() : this.jitNullSafeCoercion(leftType, type));
            if (operation.isEquality() && !rightType.isPrimitive()) {
                this.checkNullEquality();
            } else {
                this.mv.visitInsn(3);
            }
            this.mv.visitJumpInsn(167, shortcutEvaluation);
            this.mv.visitLabel(notNullLabel);
        }

        private void prepareRightOperand(ConditionAnalyzer.Expression right, Class<?> type, Class<?> rightType, Label shortcutEvaluation) {
            if (rightType.isPrimitive()) {
                if (type != null) {
                    this.castOrCoercePrimitive(7, rightType, type);
                }
                return;
            }
            Label nullLabel = new Label();
            Label notNullLabel = new Label();
            this.load(7);
            this.mv.visitJumpInsn(198, nullLabel);
            if (type != null && !ConditionAnalyzer.isFixed(right) && rightType != type) {
                this.castOrCoerceTo(7, rightType, type, nullLabel);
            }
            this.mv.visitJumpInsn(167, notNullLabel);
            this.mv.visitLabel(nullLabel);
            this.mv.visitInsn(3);
            this.mv.visitJumpInsn(167, shortcutEvaluation);
            this.mv.visitLabel(notNullLabel);
        }

        private void checkNullEquality() {
            Label rightNullLabel = new Label();
            Label rightNotNullLabel = new Label();
            this.load(7);
            this.mv.visitJumpInsn(198, rightNullLabel);
            this.mv.visitInsn(3);
            this.mv.visitJumpInsn(167, rightNotNullLabel);
            this.mv.visitLabel(rightNullLabel);
            this.mv.visitInsn(4);
            this.mv.visitLabel(rightNotNullLabel);
        }

        private Label jitNullSafeOperationStart() {
            Label nullLabel = new Label();
            this.load(5);
            this.mv.visitJumpInsn(198, nullLabel);
            return nullLabel;
        }

        private Label jitNullSafeCoercion(Class<?> fromType, Class<?> toType) {
            Label nullLabel = new Label();
            this.load(5);
            this.mv.visitJumpInsn(198, nullLabel);
            this.castOrCoerceTo(5, fromType, toType, nullLabel);
            return nullLabel;
        }

        private Label jitLeftIsNull(Label nullLabel) {
            Label notNullLabel = new Label();
            this.mv.visitJumpInsn(167, notNullLabel);
            this.mv.visitLabel(nullLabel);
            return notNullLabel;
        }

        private void castOrCoerceTo(int regNr, Class<?> fromType, Class<?> toType, Label nullLabel) {
            Label nonInstanceOfLabel = new Label();
            Label endOfCoercionLabel = new Label();
            this.load(regNr);
            this.instanceOf(toType);
            this.mv.visitJumpInsn(153, nonInstanceOfLabel);
            this.load(regNr);
            this.cast(toType);
            this.store(regNr, toType);
            this.mv.visitJumpInsn(167, endOfCoercionLabel);
            this.mv.visitLabel(nonInstanceOfLabel);
            boolean isNumber = Number.class.isAssignableFrom(toType);
            Label tryOk = null;
            Label inCatch = null;
            if (isNumber) {
                Label beforeTry = new Label();
                tryOk = new Label();
                inCatch = new Label();
                this.mv.visitTryCatchBlock(beforeTry, tryOk, inCatch, "java/lang/NumberFormatException");
                this.mv.visitLabel(beforeTry);
            }
            if (!toType.isAssignableFrom(fromType)) {
                this.mv.visitTypeInsn(187, this.internalName(toType));
                this.mv.visitInsn(89);
                this.load(regNr);
                this.coerceByConstructor(fromType, toType);
                this.store(regNr, toType);
            }
            if (isNumber) {
                Label afterCatch = new Label();
                this.mv.visitLabel(tryOk);
                this.mv.visitJumpInsn(167, afterCatch);
                this.mv.visitLabel(inCatch);
                this.mv.visitInsn(87);
                this.mv.visitInsn(1);
                this.mv.visitVarInsn(58, regNr);
                this.mv.visitJumpInsn(167, nullLabel);
                this.mv.visitLabel(afterCatch);
            }
            this.mv.visitLabel(endOfCoercionLabel);
        }

        private void coerceByConstructor(Class<?> fromType, Class<?> toType) {
            this.invokeVirtual(fromType, "toString", String.class, new Class[0]);
            if (toType == Character.class) {
                this.mv.visitInsn(3);
                this.invokeVirtual(String.class, "charAt", Character.TYPE, Integer.TYPE);
                this.invokeSpecial(Character.class, "<init>", null, Character.TYPE);
            } else {
                this.invokeSpecial(toType, "<init>", null, String.class);
            }
        }

        private void castOrCoercePrimitive(int regNr, Class<?> fromType, Class<?> toType) {
            if (fromType == toType) {
                return;
            }
            this.load(regNr);
            if (toType.isPrimitive()) {
                this.castPrimitiveToPrimitive(fromType, toType);
            } else {
                Class<?> toTypeAsPrimitive = ClassUtils.convertToPrimitiveType(toType);
                this.castPrimitiveToPrimitive(fromType, toTypeAsPrimitive);
                this.invokeStatic(toType, "valueOf", toType, toTypeAsPrimitive);
            }
            this.store(regNr, toType);
        }

        private Class<?> jitExpression(ConditionAnalyzer.Expression exp) {
            return this.jitExpression(exp, exp.getType());
        }

        private Class<?> jitExpression(ConditionAnalyzer.Expression exp, Class<?> requiredClass) {
            if (exp instanceof ConditionAnalyzer.FixedExpression) {
                this.push(((ConditionAnalyzer.FixedExpression)exp).getValue(), requiredClass);
                return exp.getType();
            }
            if (exp instanceof ConditionAnalyzer.EvaluatedExpression) {
                return this.jitEvaluatedExpression((ConditionAnalyzer.EvaluatedExpression)exp, true, Object.class);
            }
            if (exp instanceof ConditionAnalyzer.VariableExpression) {
                return this.jitVariableExpression((ConditionAnalyzer.VariableExpression)exp);
            }
            if (exp instanceof ConditionAnalyzer.AritmeticExpression) {
                return this.jitAritmeticExpression((ConditionAnalyzer.AritmeticExpression)exp);
            }
            if (exp instanceof ConditionAnalyzer.ArrayCreationExpression) {
                return this.jitArrayCreationExpression((ConditionAnalyzer.ArrayCreationExpression)exp);
            }
            if (exp instanceof ConditionAnalyzer.CastExpression) {
                return this.jitCastExpression((ConditionAnalyzer.CastExpression)exp);
            }
            throw new RuntimeException("Unknown expression: " + exp);
        }

        private Class<?> jitCastExpression(ConditionAnalyzer.CastExpression exp) {
            this.jitExpression(exp.expression, Object.class);
            this.cast(exp.expression instanceof ConditionAnalyzer.FixedExpression ? ((ConditionAnalyzer.FixedExpression)exp.expression).getTypeAsPrimitive() : exp.expression.getType(), exp.getType());
            return exp.getType();
        }

        private Class<?> jitArrayCreationExpression(ConditionAnalyzer.ArrayCreationExpression exp) {
            this.createArray(exp.getComponentType(), exp.items.size());
            for (int i = 0; i < exp.items.size(); ++i) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn((Object)i);
                this.jitExpression(exp.items.get(i));
                this.mv.visitInsn(this.getCodeForType(exp.getComponentType(), 79));
            }
            return exp.getType();
        }

        private Class<?> jitEvaluatedExpression(ConditionAnalyzer.EvaluatedExpression exp, boolean firstInvocation, Class<?> currentClass) {
            if (exp.firstExpression != null) {
                currentClass = this.jitExpression(exp.firstExpression, currentClass);
                if (exp.firstExpression instanceof ConditionAnalyzer.FixedExpression || exp.firstExpression instanceof ConditionAnalyzer.CastExpression) {
                    firstInvocation = false;
                }
            }
            Iterator<ConditionAnalyzer.Invocation> invocations = exp.invocations.iterator();
            currentClass = this.jitInvocation(invocations.next(), currentClass, firstInvocation);
            while (invocations.hasNext()) {
                currentClass = this.jitInvocation(invocations.next(), currentClass, false);
            }
            return currentClass;
        }

        private Class<?> jitVariableExpression(ConditionAnalyzer.VariableExpression exp) {
            this.jitReadVariable(exp.variableName);
            return exp.subsequentInvocations != null ? this.jitEvaluatedExpression(exp.subsequentInvocations, false, exp.getVariableType()) : exp.getType();
        }

        private void jitReadVariable(String variableName) {
            for (int i = 0; i < this.declarations.length; ++i) {
                if (!this.declarations[i].getBindingName().equals(variableName)) continue;
                this.load(this.declPositions[i]);
                return;
            }
            throw new RuntimeException("Unknown variable name: " + variableName);
        }

        private Class<?> jitAritmeticExpression(ConditionAnalyzer.AritmeticExpression aritmeticExpression) {
            if (aritmeticExpression.isStringConcat()) {
                this.jitStringConcat(aritmeticExpression.left, aritmeticExpression.right);
                return String.class;
            }
            Class<?> operationType = aritmeticExpression.getType();
            if (operationType == BigDecimal.class || operationType == BigInteger.class) {
                this.jitExpression(aritmeticExpression.left, operationType);
                this.jitExpression(aritmeticExpression.right, operationType);
            } else {
                this.jitExpressionToPrimitiveType(aritmeticExpression.left, operationType);
                this.jitExpressionToPrimitiveType(aritmeticExpression.right, aritmeticExpression.operator.isBitwiseOperation() ? Integer.TYPE : operationType);
            }
            this.jitAritmeticOperation(operationType, aritmeticExpression.operator);
            return aritmeticExpression.getType();
        }

        private void jitStringConcat(ConditionAnalyzer.Expression left, ConditionAnalyzer.Expression right) {
            this.invokeConstructor(StringBuilder.class);
            this.jitExpression(left, String.class);
            this.invokeVirtual(StringBuilder.class, "append", StringBuilder.class, left.getType());
            this.jitExpression(right, String.class);
            this.invokeVirtual(StringBuilder.class, "append", StringBuilder.class, right.getType());
            this.invokeVirtual(StringBuilder.class, "toString", String.class, new Class[0]);
        }

        private void jitExpressionToPrimitiveType(ConditionAnalyzer.Expression expression, Class<?> primitiveType) {
            this.jitExpression(expression, primitiveType);
            if (!ConditionAnalyzer.isFixed(expression)) {
                this.cast(expression.getType(), primitiveType);
            }
        }

        private boolean isDeclarationExpression(ConditionAnalyzer.Expression expression) {
            return expression instanceof ConditionAnalyzer.VariableExpression && ((ConditionAnalyzer.VariableExpression)expression).subsequentInvocations == null;
        }

        private void jitAritmeticOperation(Class<?> operationType, ConditionAnalyzer.AritmeticOperator operator) {
            if (operationType == Integer.TYPE) {
                this.mv.visitInsn(operator.getIntOp());
            } else if (operationType == Long.TYPE) {
                this.mv.visitInsn(operator.getLongOp());
            } else if (operationType == Double.TYPE) {
                switch (operator) {
                    case ADD: {
                        this.mv.visitInsn(99);
                        break;
                    }
                    case SUB: {
                        this.mv.visitInsn(103);
                        break;
                    }
                    case MUL: {
                        this.mv.visitInsn(107);
                        break;
                    }
                    case DIV: {
                        this.mv.visitInsn(111);
                        break;
                    }
                    case MOD: {
                        this.mv.visitInsn(115);
                    }
                }
            } else if (operationType == BigDecimal.class || operationType == BigInteger.class) {
                try {
                    switch (operator) {
                        case ADD: {
                            this.invoke(operationType.getMethod("add", operationType));
                            break;
                        }
                        case SUB: {
                            this.invoke(operationType.getMethod("subtract", operationType));
                            break;
                        }
                        case MUL: {
                            this.invoke(operationType.getMethod("multiply", operationType));
                            break;
                        }
                        case DIV: {
                            this.invoke(operationType.getMethod("divide", operationType));
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new RuntimeException("Unknown operation type" + operationType);
            }
        }

        private Class<?> jitInvocation(ConditionAnalyzer.Invocation invocation, Class<?> currentClass, boolean firstInvocation) {
            if (invocation instanceof ConditionAnalyzer.MethodInvocation) {
                this.jitMethodInvocation((ConditionAnalyzer.MethodInvocation)invocation, currentClass, firstInvocation);
            } else if (invocation instanceof ConditionAnalyzer.ConstructorInvocation) {
                this.jitConstructorInvocation((ConditionAnalyzer.ConstructorInvocation)invocation);
            } else if (invocation instanceof ConditionAnalyzer.ArrayAccessInvocation) {
                this.jitArrayAccessInvocation((ConditionAnalyzer.ArrayAccessInvocation)invocation);
            } else if (invocation instanceof ConditionAnalyzer.ArrayLengthInvocation) {
                this.jitArrayLenghtInvocation();
            } else if (invocation instanceof ConditionAnalyzer.ListAccessInvocation) {
                this.jitListAccessInvocation((ConditionAnalyzer.ListAccessInvocation)invocation);
            } else if (invocation instanceof ConditionAnalyzer.MapAccessInvocation) {
                this.jitMapAccessInvocation((ConditionAnalyzer.MapAccessInvocation)invocation, firstInvocation);
            } else {
                this.jitFieldAccessInvocation((ConditionAnalyzer.FieldAccessInvocation)invocation, currentClass, firstInvocation);
            }
            return invocation.getReturnType();
        }

        private void jitMethodInvocation(ConditionAnalyzer.MethodInvocation invocation, Class<?> currentClass, boolean firstInvocation) {
            Method method = invocation.getMethod();
            if (firstInvocation && (method == null || (method.getModifiers() & 8) == 0)) {
                this.mv.visitVarInsn(25, 1);
                this.invokeInterface(InternalFactHandle.class, "getObject", Object.class, new Class[0]);
            }
            if (method == null) {
                if (!firstInvocation) {
                    this.mv.visitVarInsn(25, 1);
                    this.invokeInterface(InternalFactHandle.class, "getObject", Object.class, new Class[0]);
                }
                if (!invocation.getReturnType().isAssignableFrom(currentClass)) {
                    this.cast(invocation.getReturnType());
                }
                return;
            }
            if (!method.getDeclaringClass().isAssignableFrom(currentClass) && (method.getModifiers() & 8) == 0) {
                this.cast(method.getDeclaringClass());
            }
            int argumentCounter = 0;
            for (ConditionAnalyzer.Expression argument : invocation.getArguments()) {
                this.cast(this.jitExpression(argument), method.getParameterTypes()[argumentCounter++]);
            }
            this.invoke(method);
        }

        private void jitConstructorInvocation(ConditionAnalyzer.ConstructorInvocation invocation) {
            Constructor constructor = invocation.getConstructor();
            Class<?> clazz = invocation.getReturnType();
            this.mv.visitTypeInsn(187, this.internalName(clazz));
            this.mv.visitInsn(89);
            int argumentCounter = 0;
            for (ConditionAnalyzer.Expression argument : invocation.getArguments()) {
                this.cast(this.jitExpression(argument), constructor.getParameterTypes()[argumentCounter++]);
            }
            this.invokeSpecial(clazz, "<init>", null, constructor.getParameterTypes());
        }

        private void jitArrayAccessInvocation(ConditionAnalyzer.ArrayAccessInvocation invocation) {
            this.cast(invocation.getArrayType());
            this.jitExpression(invocation.getIndex(), Integer.TYPE);
            this.mv.visitInsn(this.getCodeForType(invocation.getReturnType(), 46));
        }

        private void jitArrayLenghtInvocation() {
            this.invokeStatic(EvaluatorHelper.class, "arrayLenght", Integer.TYPE, Object.class);
        }

        private void jitListAccessInvocation(ConditionAnalyzer.ListAccessInvocation invocation) {
            this.jitExpression(invocation.getIndex(), Integer.TYPE);
            this.invokeInterface(List.class, "get", Object.class, Integer.TYPE);
            if (invocation.getReturnType() != Object.class) {
                this.cast(invocation.getReturnType());
            }
        }

        private void jitMapAccessInvocation(ConditionAnalyzer.MapAccessInvocation invocation, boolean firstInvocation) {
            Class<?> keyClass;
            if (firstInvocation) {
                this.mv.visitVarInsn(25, 1);
                this.invokeInterface(InternalFactHandle.class, "getObject", Object.class, new Class[0]);
                this.cast(Map.class);
            }
            if ((keyClass = this.jitExpression(invocation.getKey(), invocation.getKeyType())).isPrimitive()) {
                this.convertPrimitiveToObject(keyClass);
            }
            this.invokeInterface(Map.class, "get", Object.class, Object.class);
            if (invocation.getReturnType() != Object.class) {
                this.cast(invocation.getReturnType());
            }
        }

        private void jitFieldAccessInvocation(ConditionAnalyzer.FieldAccessInvocation invocation, Class<?> currentClass, boolean firstInvocation) {
            boolean isStatic;
            Field field = invocation.getField();
            boolean bl = isStatic = (field.getModifiers() & 8) != 0;
            if (firstInvocation && !isStatic) {
                this.mv.visitVarInsn(25, 1);
                this.invokeInterface(InternalFactHandle.class, "getObject", Object.class, new Class[0]);
            }
            if (!isStatic && !field.getDeclaringClass().isAssignableFrom(currentClass)) {
                this.cast(field.getDeclaringClass());
            }
            this.readField(field);
        }

        private void jitPrimitiveOperation(ConditionAnalyzer.BooleanOperator op, Class<?> type) {
            int opCode = this.toOpCode(op, type);
            Label trueBranchLabel = new Label();
            Label returnLabel = new Label();
            if (type == Double.TYPE) {
                this.mv.visitInsn(151);
            } else if (type == Long.TYPE) {
                this.mv.visitInsn(148);
            } else if (type == Float.TYPE) {
                this.mv.visitInsn(149);
            }
            this.mv.visitJumpInsn(opCode, trueBranchLabel);
            this.mv.visitInsn(3);
            this.mv.visitJumpInsn(167, returnLabel);
            this.mv.visitLabel(trueBranchLabel);
            this.mv.visitInsn(4);
            this.mv.visitLabel(returnLabel);
        }

        private void jitNegation() {
            Label trueBranch = new Label();
            Label falseBranch = new Label();
            this.mv.visitJumpInsn(154, trueBranch);
            this.mv.visitInsn(4);
            this.mv.visitJumpInsn(167, falseBranch);
            this.mv.visitLabel(trueBranch);
            this.mv.visitInsn(3);
            this.mv.visitLabel(falseBranch);
        }

        private int toOpCode(ConditionAnalyzer.BooleanOperator op, Class<?> type) {
            if (type == Double.TYPE || type == Long.TYPE || type == Float.TYPE) {
                switch (op) {
                    case EQ: {
                        return 153;
                    }
                    case NE: {
                        return 154;
                    }
                    case GT: {
                        return 157;
                    }
                    case GE: {
                        return 156;
                    }
                    case LT: {
                        return 155;
                    }
                    case LE: {
                        return 158;
                    }
                }
            } else {
                switch (op) {
                    case EQ: {
                        return 159;
                    }
                    case NE: {
                        return 160;
                    }
                    case GT: {
                        return 163;
                    }
                    case GE: {
                        return 162;
                    }
                    case LT: {
                        return 161;
                    }
                    case LE: {
                        return 164;
                    }
                }
            }
            throw new RuntimeException("Unknown operator: " + (Object)((Object)op));
        }

        private Class<?> findCommonClass(Class<?> class1, boolean primitive1, Class<?> class2, boolean primitive2, boolean forEquality) {
            Class<Object> result = null;
            if (class1 == class2) {
                result = class1;
            } else if (class1 == NullType.class) {
                result = ClassUtils.convertFromPrimitiveType(class2);
            } else if (class2 == NullType.class) {
                result = ClassUtils.convertFromPrimitiveType(class1);
            } else if (class1 == Object.class) {
                result = ClassUtils.convertFromPrimitiveType(class2);
                if (Number.class.isAssignableFrom(result) && !result.getSimpleName().startsWith("Big")) {
                    result = Double.class;
                }
            } else if (class2 == Object.class) {
                result = ClassUtils.convertFromPrimitiveType(class1);
                if (Number.class.isAssignableFrom(result) && !result.getSimpleName().startsWith("Big")) {
                    result = Double.class;
                }
            } else if (class1 == String.class && this.isCoercibleToString(class2)) {
                result = ClassUtils.convertFromPrimitiveType(class2);
            } else if (class2 == String.class && this.isCoercibleToString(class1)) {
                result = ClassUtils.convertFromPrimitiveType(class1);
            }
            if (result == null) {
                result = this.findCommonClass(class1, class2, primitive2);
            }
            if (result == null) {
                result = this.findCommonClass(class2, class1, primitive1);
            }
            if (result == null) {
                if (forEquality) {
                    return Object.class;
                }
                throw new RuntimeException("Cannot find a common class between " + class1.getName() + " and " + class2.getName() + " ||  " + class1.hashCode() + " vs " + class2.hashCode());
            }
            return result == Number.class ? Double.class : result;
        }

        private boolean isCoercibleToString(Class<?> clazz) {
            return clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || Boolean.class == clazz || Character.class == clazz;
        }

        private Class<?> findCommonClass(Class<?> class1, Class<?> class2, boolean canBePrimitive) {
            if (class1.isAssignableFrom(class2)) {
                return class1;
            }
            if (class1 == Boolean.TYPE && class2 == Boolean.class) {
                return canBePrimitive ? Boolean.TYPE : Boolean.class;
            }
            if (class1 == Character.TYPE && class2 == Character.class) {
                return canBePrimitive ? Character.TYPE : Character.class;
            }
            if (class1 == Byte.TYPE && class2 == Byte.class) {
                return canBePrimitive ? Byte.TYPE : Byte.class;
            }
            if (class1 == Short.TYPE && class2 == Short.class) {
                return canBePrimitive ? Short.TYPE : Short.class;
            }
            if (class1 == Number.class && class2.isPrimitive()) {
                return Double.class;
            }
            if (class1 == Integer.TYPE || class1 == Short.TYPE || class1 == Byte.TYPE) {
                if (class2 == Integer.class) {
                    return canBePrimitive ? Integer.TYPE : Integer.class;
                }
                if (class2 == Long.TYPE) {
                    return Long.TYPE;
                }
                if (class2 == Long.class) {
                    return canBePrimitive ? Long.TYPE : Long.class;
                }
                if (class2 == Float.TYPE) {
                    return Float.TYPE;
                }
                if (class2 == Float.class) {
                    return canBePrimitive ? Float.TYPE : Float.class;
                }
                if (class2 == Double.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Double.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigInteger.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Long.TYPE) {
                if (class2 == Integer.TYPE) {
                    return Long.TYPE;
                }
                if (class2 == Integer.class) {
                    return canBePrimitive ? Long.TYPE : Long.class;
                }
                if (class2 == Long.class) {
                    return canBePrimitive ? Long.TYPE : Long.class;
                }
                if (class2 == Float.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Float.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == Double.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Double.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigInteger.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Float.TYPE) {
                if (class2 == Integer.TYPE) {
                    return Float.TYPE;
                }
                if (class2 == Integer.class) {
                    return canBePrimitive ? Float.TYPE : Float.class;
                }
                if (class2 == Long.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Long.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == Float.class) {
                    return canBePrimitive ? Float.TYPE : Float.class;
                }
                if (class2 == Double.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Double.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigDecimal.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Double.TYPE) {
                if (class2 == Integer.TYPE) {
                    return Float.TYPE;
                }
                if (class2 == Integer.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == Long.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Long.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == Float.TYPE) {
                    return Double.TYPE;
                }
                if (class2 == Float.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == Double.class) {
                    return canBePrimitive ? Double.TYPE : Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigDecimal.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Integer.class) {
                if (class2 == Long.class) {
                    return Long.class;
                }
                if (class2 == Float.class) {
                    return Float.class;
                }
                if (class2 == Double.class) {
                    return Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigInteger.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Long.class) {
                if (class2 == Float.class) {
                    return Double.class;
                }
                if (class2 == Double.class) {
                    return Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigInteger.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Float.class) {
                if (class2 == Double.class) {
                    return Double.class;
                }
                if (class2 == BigInteger.class) {
                    return BigDecimal.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == Double.class) {
                if (class2 == BigInteger.class) {
                    return BigDecimal.class;
                }
                if (class2 == BigDecimal.class) {
                    return BigDecimal.class;
                }
            }
            if (class1 == BigInteger.class && class2 == BigDecimal.class) {
                return BigDecimal.class;
            }
            return null;
        }
    }
}

