/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.phreak.PhreakNotNode;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.rule.Rule;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.conf.RuleEngineOption;

public class NodeSegmentUnlinkingTest {
    InternalKnowledgeBase kBase;
    BuildContext buildContext;
    PropagationContext context;
    LeftInputAdapterNode liaNode;
    BetaNode n1;
    BetaNode n2;
    BetaNode n3;
    BetaNode n4;
    BetaNode n5;
    BetaNode n6;
    BetaNode n7;
    BetaNode n8;
    RuleImpl rule1;
    RuleImpl rule2;
    RuleImpl rule3;
    RuleImpl rule4;
    RuleImpl rule5;
    static final int JOIN_NODE = 0;
    static final int EXISTS_NODE = 1;
    static final int NOT_NODE = 2;

    private BetaNode createBetaNode(int id, int type, LeftTupleSource leftTupleSource) {
        MockObjectSource mockObjectSource = new MockObjectSource(8);
        JoinNode betaNode = null;
        switch (type) {
            case 0: {
                betaNode = new JoinNode(id, leftTupleSource, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), this.buildContext);
                break;
            }
            case 1: {
                betaNode = new ExistsNode(id, leftTupleSource, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), this.buildContext);
                break;
            }
            case 2: {
                betaNode = new NotNode(id, leftTupleSource, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), this.buildContext);
            }
        }
        mockObjectSource.attach();
        betaNode.attach();
        return betaNode;
    }

    public void setUp(int type) {
        this.setUp(type, type, type, type, type, type, type, type);
    }

    public void setUp(int ... type) {
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)RuleEngineOption.PHREAK);
        this.kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        this.buildContext = new BuildContext(this.kBase, this.kBase.getReteooBuilder().getIdGenerator());
        PropagationContextFactory pctxFactory = this.kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        this.context = pctxFactory.createPropagationContext(0L, 0, null, null, null);
        MockTupleSource mockTupleSource = new MockTupleSource(9);
        this.rule1 = new RuleImpl("rule1");
        this.rule2 = new RuleImpl("rule2");
        this.rule3 = new RuleImpl("rule3");
        ObjectTypeNode otn = new ObjectTypeNode(3, null, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        this.liaNode = new LeftInputAdapterNode(4, (ObjectSource)otn, this.buildContext);
        this.n1 = this.createBetaNode(10, type[0], (LeftTupleSource)this.liaNode);
        this.n2 = this.createBetaNode(11, type[1], (LeftTupleSource)this.n1);
        RuleTerminalNode rtn1 = new RuleTerminalNode(18, (LeftTupleSource)this.n2, this.rule1, this.rule1.getLhs(), 0, this.buildContext);
        rtn1.attach();
        this.n3 = this.createBetaNode(12, type[2], (LeftTupleSource)this.n1);
        this.n4 = this.createBetaNode(13, type[3], (LeftTupleSource)this.n3);
        this.n5 = this.createBetaNode(14, type[4], (LeftTupleSource)this.n4);
        this.n6 = this.createBetaNode(15, type[5], (LeftTupleSource)this.n5);
        RuleTerminalNode rtn2 = new RuleTerminalNode(19, (LeftTupleSource)this.n6, this.rule2, this.rule2.getLhs(), 0, this.buildContext);
        rtn2.attach();
        this.n7 = this.createBetaNode(16, type[6], (LeftTupleSource)this.n6);
        this.n8 = this.createBetaNode(17, type[7], (LeftTupleSource)this.n7);
        RuleTerminalNode rtn3 = new RuleTerminalNode(20, (LeftTupleSource)this.n8, this.rule3, this.rule3.getLhs(), 0, this.buildContext);
        rtn3.attach();
        this.n1.getAssociations().put(this.rule1, null);
        this.n1.getAssociations().put(this.rule2, null);
        this.n1.getAssociations().put(this.rule3, null);
        this.n2.getAssociations().put(this.rule1, null);
        this.n2.getAssociations().put(this.rule2, null);
        this.n2.getAssociations().put(this.rule3, null);
        this.n3.getAssociations().put(this.rule2, null);
        this.n3.getAssociations().put(this.rule3, null);
        this.n4.getAssociations().put(this.rule2, null);
        this.n4.getAssociations().put(this.rule3, null);
        this.n5.getAssociations().put(this.rule2, null);
        this.n5.getAssociations().put(this.rule3, null);
        this.n6.getAssociations().put(this.rule2, null);
        this.n6.getAssociations().put(this.rule3, null);
        this.n7.getAssociations().put(this.rule3, null);
        this.n8.getAssociations().put(this.rule3, null);
    }

    @Test
    public void testSingleNodeinSegment() {
        this.rule1 = new RuleImpl("rule1");
        this.rule2 = new RuleImpl("rule2");
        this.rule3 = new RuleImpl("rule3");
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)RuleEngineOption.PHREAK);
        this.kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        BuildContext buildContext = new BuildContext(this.kBase, this.kBase.getReteooBuilder().getIdGenerator());
        MockObjectSource mockObjectSource = new MockObjectSource(8);
        MockTupleSource mockTupleSource = new MockTupleSource(9);
        ObjectTypeNode otn = new ObjectTypeNode(2, null, (ObjectType)new ClassObjectType(String.class), buildContext);
        JoinNode n1 = new JoinNode(10, (LeftTupleSource)new LeftInputAdapterNode(3, (ObjectSource)otn, buildContext), (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), buildContext);
        JoinNode n2 = new JoinNode(11, (LeftTupleSource)n1, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), buildContext);
        JoinNode n3 = new JoinNode(12, (LeftTupleSource)n1, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), buildContext);
        JoinNode n4 = new JoinNode(13, (LeftTupleSource)n2, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), buildContext);
        JoinNode n5 = new JoinNode(14, (LeftTupleSource)n2, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), buildContext);
        n1.addAssociation((Rule)this.rule1, null);
        n1.addAssociation((Rule)this.rule2, null);
        n1.addAssociation((Rule)this.rule3, null);
        n2.addAssociation((Rule)this.rule2, null);
        n2.addAssociation((Rule)this.rule3, null);
        n3.addAssociation((Rule)this.rule1, null);
        n4.addAssociation((Rule)this.rule2, null);
        n5.addAssociation((Rule)this.rule3, null);
        mockObjectSource.attach();
        mockTupleSource.attach();
        n1.attach();
        n2.attach();
        n3.attach();
        n4.attach();
        n5.attach();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
        NodeSegmentUnlinkingTest.createSegmentMemory((BetaNode)n2, (InternalWorkingMemory)ksession);
        BetaMemory bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)n1);
        Assert.assertNull((Object)bm.getSegmentMemory());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)n3);
        Assert.assertNull((Object)bm.getSegmentMemory());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)n4);
        Assert.assertNull((Object)bm.getSegmentMemory());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)n2);
        Assert.assertEquals((long)1L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)1L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
    }

    @Test
    public void testLiaNodeInitialisation() {
        this.setUp(0);
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)RuleEngineOption.PHREAK);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        SegmentUtilities.createSegmentMemory((LeftTupleSource)this.liaNode, (InternalWorkingMemory)ksession);
        this.liaNode.assertObject((InternalFactHandle)ksession.insert((Object)"str"), this.context, (InternalWorkingMemory)ksession);
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)ksession.getNodeMemory((MemoryFactory)this.liaNode);
        Assert.assertEquals((long)1L, (long)liaMem.getNodePosMaskBit());
        Assert.assertEquals((long)3L, (long)liaMem.getSegmentMemory().getAllLinkedMaskTest());
        BetaMemory bm1 = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assert.assertEquals((long)2L, (long)bm1.getNodePosMaskBit());
        Assert.assertEquals((long)3L, (long)bm1.getSegmentMemory().getAllLinkedMaskTest());
        kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        this.n1.assertObject((InternalFactHandle)ksession.insert((Object)"str"), this.context, (InternalWorkingMemory)ksession);
        liaMem = (LeftInputAdapterNode.LiaNodeMemory)ksession.getNodeMemory((MemoryFactory)this.liaNode);
        Assert.assertEquals((long)1L, (long)liaMem.getNodePosMaskBit());
        Assert.assertEquals((long)3L, (long)liaMem.getSegmentMemory().getAllLinkedMaskTest());
        bm1 = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assert.assertEquals((long)2L, (long)bm1.getNodePosMaskBit());
        Assert.assertEquals((long)3L, (long)bm1.getSegmentMemory().getAllLinkedMaskTest());
    }

    @Test
    public void testLiaNodeLinking() {
        this.setUp(0);
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)RuleEngineOption.PHREAK);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        SegmentUtilities.createSegmentMemory((LeftTupleSource)this.liaNode, (InternalWorkingMemory)ksession);
        InternalFactHandle fh1 = (InternalFactHandle)ksession.insert((Object)"str1");
        this.n1.assertObject(fh1, this.context, (InternalWorkingMemory)ksession);
        LeftInputAdapterNode.LiaNodeMemory liaMem = (LeftInputAdapterNode.LiaNodeMemory)ksession.getNodeMemory((MemoryFactory)this.liaNode);
        Assert.assertEquals((long)1L, (long)liaMem.getNodePosMaskBit());
        Assert.assertEquals((long)3L, (long)liaMem.getSegmentMemory().getAllLinkedMaskTest());
        BetaMemory bm1 = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assert.assertEquals((long)2L, (long)bm1.getNodePosMaskBit());
        Assert.assertEquals((long)3L, (long)bm1.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertFalse((boolean)liaMem.getSegmentMemory().isSegmentLinked());
        InternalFactHandle fh2 = (InternalFactHandle)ksession.insert((Object)"str2");
        this.liaNode.assertObject(fh2, this.context, (InternalWorkingMemory)ksession);
        Assert.assertTrue((boolean)liaMem.getSegmentMemory().isSegmentLinked());
        this.liaNode.retractLeftTuple(fh2.getFirstLeftTuple(), this.context, (InternalWorkingMemory)ksession);
        Assert.assertFalse((boolean)liaMem.getSegmentMemory().isSegmentLinked());
        InternalFactHandle fh3 = (InternalFactHandle)ksession.insert((Object)"str3");
        InternalFactHandle fh4 = (InternalFactHandle)ksession.insert((Object)"str4");
        this.liaNode.assertObject(fh3, this.context, (InternalWorkingMemory)ksession);
        this.liaNode.assertObject(fh4, this.context, (InternalWorkingMemory)ksession);
        Assert.assertTrue((boolean)liaMem.getSegmentMemory().isSegmentLinked());
        this.liaNode.retractLeftTuple(fh3.getFirstLeftTuple(), this.context, (InternalWorkingMemory)ksession);
        Assert.assertTrue((boolean)liaMem.getSegmentMemory().isSegmentLinked());
        this.liaNode.retractLeftTuple(fh4.getFirstLeftTuple(), this.context, (InternalWorkingMemory)ksession);
        Assert.assertFalse((boolean)liaMem.getSegmentMemory().isSegmentLinked());
    }

    @Test
    public void tesMultiNodeSegmentDifferentInitialisationPoints() {
        this.setUp(0);
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)RuleEngineOption.PHREAK);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        NodeSegmentUnlinkingTest.createSegmentMemory(this.n3, (InternalWorkingMemory)ksession);
        BetaMemory bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assert.assertNull((Object)bm.getSegmentMemory());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        Assert.assertEquals((long)1L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n4);
        Assert.assertEquals((long)2L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n5);
        Assert.assertEquals((long)4L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n6);
        Assert.assertEquals((long)8L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        bm = NodeSegmentUnlinkingTest.createSegmentMemory(this.n4, (InternalWorkingMemory)ksession);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assert.assertNull((Object)bm.getSegmentMemory());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        Assert.assertEquals((long)1L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n4);
        Assert.assertEquals((long)2L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n5);
        Assert.assertEquals((long)4L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n6);
        Assert.assertEquals((long)8L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        NodeSegmentUnlinkingTest.createSegmentMemory(this.n5, (InternalWorkingMemory)ksession);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assert.assertNull((Object)bm.getSegmentMemory());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        Assert.assertEquals((long)1L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n4);
        Assert.assertEquals((long)2L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n5);
        Assert.assertEquals((long)4L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n6);
        Assert.assertEquals((long)8L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        NodeSegmentUnlinkingTest.createSegmentMemory(this.n6, (InternalWorkingMemory)ksession);
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n1);
        Assert.assertNull((Object)bm.getSegmentMemory());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        Assert.assertEquals((long)1L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n4);
        Assert.assertEquals((long)2L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n5);
        Assert.assertEquals((long)4L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n6);
        Assert.assertEquals((long)8L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
    }

    @Test
    public void testAllLinkedInWithJoinNodesOnly() {
        this.setUp(0);
        Assert.assertEquals(JoinNode.class, this.n3.getClass());
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)RuleEngineOption.PHREAK);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        DefaultFactHandle f1 = (DefaultFactHandle)ksession.insert((Object)"test1");
        this.n3.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)ksession);
        BetaMemory bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        Assert.assertFalse((boolean)bm.getSegmentMemory().isSegmentLinked());
        this.n4.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)ksession);
        Assert.assertFalse((boolean)bm.getSegmentMemory().isSegmentLinked());
        this.n5.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)ksession);
        Assert.assertFalse((boolean)bm.getSegmentMemory().isSegmentLinked());
        this.n6.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)ksession);
        Assert.assertTrue((boolean)bm.getSegmentMemory().isSegmentLinked());
        this.n6.retractRightTuple(f1.getLastRightTuple(), this.context, (InternalWorkingMemory)ksession);
        Assert.assertFalse((boolean)bm.getSegmentMemory().isSegmentLinked());
    }

    @Test
    public void testAllLinkedInWithExistsNodesOnly() {
        this.setUp(1);
        Assert.assertEquals(ExistsNode.class, this.n3.getClass());
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)RuleEngineOption.PHREAK);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        DefaultFactHandle f1 = (DefaultFactHandle)ksession.insert((Object)"test1");
        this.n3.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)ksession);
        BetaMemory bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        Assert.assertFalse((boolean)bm.getSegmentMemory().isSegmentLinked());
        this.n4.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)ksession);
        Assert.assertFalse((boolean)bm.getSegmentMemory().isSegmentLinked());
        this.n5.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)ksession);
        Assert.assertFalse((boolean)bm.getSegmentMemory().isSegmentLinked());
        this.n6.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)ksession);
        Assert.assertTrue((boolean)bm.getSegmentMemory().isSegmentLinked());
        this.n6.retractRightTuple(f1.getLastRightTuple(), this.context, (InternalWorkingMemory)ksession);
        Assert.assertFalse((boolean)bm.getSegmentMemory().isSegmentLinked());
    }

    private static BetaMemory createSegmentMemory(BetaNode node, InternalWorkingMemory wm) {
        BetaMemory betaMemory = (BetaMemory)wm.getNodeMemory((MemoryFactory)node);
        if (betaMemory.getSegmentMemory() == null) {
            SegmentUtilities.createSegmentMemory((LeftTupleSource)node, (InternalWorkingMemory)wm);
        }
        return betaMemory;
    }

    @Test
    public void testAllLinkedInWithNotNodesOnly() {
        this.setUp(2);
        Assert.assertEquals(NotNode.class, this.n3.getClass());
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)RuleEngineOption.PHREAK);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        BetaMemory bm = (BetaMemory)ksession.getNodeMemory((MemoryFactory)this.n3);
        NodeSegmentUnlinkingTest.createSegmentMemory(this.n3, (InternalWorkingMemory)ksession);
        Assert.assertTrue((boolean)bm.getSegmentMemory().isSegmentLinked());
        DefaultFactHandle f1 = (DefaultFactHandle)ksession.insert((Object)"test1");
        this.n3.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)ksession);
        PhreakNotNode.unlinkNotNodeOnRightInsert((NotNode)((NotNode)this.n3), (BetaMemory)bm, (InternalWorkingMemory)ksession);
        Assert.assertFalse((boolean)bm.getSegmentMemory().isSegmentLinked());
        this.n3.retractRightTuple(f1.getFirstRightTuple(), this.context, (InternalWorkingMemory)ksession);
        Assert.assertTrue((boolean)bm.getSegmentMemory().isSegmentLinked());
    }
}

