/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.drools.core.base.ClassObjectType;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.QueryImpl;
import org.drools.core.spi.AcceptsClassObjectType;

public class AbductiveQuery
extends QueryImpl
implements Externalizable,
AcceptsClassObjectType {
    private ClassObjectType returnType;
    private transient Constructor constructor;
    private String[] params;
    private String[] abducibleArgs;
    private int[] arg2param;
    private Object value;
    private boolean returnBound;

    public AbductiveQuery() {
    }

    public AbductiveQuery(String name, Object value) {
        super(name);
    }

    @Override
    public boolean isAbductive() {
        return true;
    }

    public void setReturnType(ClassObjectType objectType, String[] params, String[] args, Declaration[] declarations) throws NoSuchMethodException, IllegalArgumentException {
        this.returnType = objectType;
        this.params = params;
        if (args != null) {
            this.abducibleArgs = Arrays.copyOf(args, args.length);
            this.arg2param = new int[this.abducibleArgs.length];
            for (int j = 0; j < this.abducibleArgs.length; ++j) {
                boolean matched = false;
                for (int k = 0; k < params.length; ++k) {
                    if (this.abducibleArgs[j].equals(params[k])) {
                        this.arg2param[j] = k;
                        matched = true;
                        break;
                    }
                    if (matched) break;
                }
                if (matched) continue;
                throw new IllegalArgumentException("Constructor argument " + this.abducibleArgs[j] + " cannot be resolved ");
            }
        } else {
            this.abducibleArgs = Arrays.copyOf(params, params.length - 1);
            this.arg2param = new int[this.abducibleArgs.length];
            for (int j = 0; j < this.abducibleArgs.length; ++j) {
                this.arg2param[j] = j;
            }
        }
        this.findConstructor(declarations);
    }

    protected void findConstructor(Declaration[] declarations) throws NoSuchMethodException {
        int N = this.abducibleArgs.length;
        this.constructor = null;
        ArrayList availableArgs = N > 0 ? new ArrayList(N) : Collections.emptyList();
        for (int j = 0; j < N; ++j) {
            Declaration decl;
            Declaration declaration = decl = declarations != null ? declarations[this.mapArgToParam(j)] : this.getDeclaration(this.abducibleArgs[j]);
            if (decl == null) continue;
            availableArgs.add(decl.getExtractor().getExtractToClass());
        }
        Class<?> klass = this.returnType.getClassType();
        while (this.constructor == null) {
            try {
                this.constructor = klass.getConstructor(availableArgs.toArray(new Class[availableArgs.size()]));
            }
            catch (NoSuchMethodException nsme) {
                if (klass == Object.class) {
                    throw nsme;
                }
                klass = klass.getSuperclass();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.returnType);
        out.writeObject(this.params);
        out.writeObject(this.value);
        out.writeBoolean(this.returnBound);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.returnType = (ClassObjectType)in.readObject();
        this.params = (String[])in.readObject();
        this.value = in.readObject();
        this.returnBound = in.readBoolean();
    }

    public Object abduce(Object ... args) {
        if (this.constructor == null) {
            return null;
        }
        try {
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null || !this.constructor.getParameterTypes()[j].isPrimitive()) continue;
                args[j] = Boolean.TYPE == this.constructor.getParameterTypes()[j] ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
            }
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ClassObjectType getReturnType() {
        return this.returnType;
    }

    public Object getValue() {
        return this.value;
    }

    public String[] getAbducibleArgs() {
        return this.abducibleArgs;
    }

    @Override
    public void setClassObjectType(ClassObjectType classObjectType) {
        this.returnType = classObjectType;
        if (this.params != null) {
            try {
                this.findConstructor(null);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                this.constructor = null;
                this.returnType = null;
            }
        }
    }

    public void setReturnBound(boolean returnBound) {
        this.returnBound = returnBound;
    }

    public boolean isReturnBound() {
        return this.returnBound;
    }

    public int mapArgToParam(int j) {
        return this.arg2param[j];
    }
}

