/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.builder.NodeFactory;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.GlobalResolver;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.MockActivation;
import org.drools.core.test.model.Person;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ReteooWorkingMemoryTest {
    @Test
    @Ignore
    public void testBasicWorkingMemoryActions() {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)ksession.getWorkingMemoryEntryPoint(EntryPointId.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
        String string = "test";
        FactHandle fd = ksession.insert((Object)"test");
        InternalFactHandle fz = ksession.getTruthMaintenanceSystem().insert((Object)"test", null, null, new MockActivation());
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        EqualityKey key = tms.get((Object)"test");
        Assert.assertSame((Object)fz, (Object)key.getFactHandle());
        Assert.assertEquals((long)2L, (long)key.size());
        ksession.update(fd, (Object)"test");
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        key = tms.get((Object)"test");
        Assert.assertSame((Object)fz, (Object)key.getFactHandle());
        Assert.assertEquals((long)2L, (long)key.size());
        ksession.retract(fd);
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        key = tms.get((Object)"test");
        fd = ksession.insert((Object)"test");
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        key = tms.get((Object)"test");
        Assert.assertSame((Object)fd, (Object)key.getFactHandle());
        Assert.assertEquals((long)1L, (long)key.size());
    }

    @Test
    public void testId() {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        Assert.assertEquals((long)0L, (long)ksession.getIdentifier());
        ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        Assert.assertEquals((long)1L, (long)ksession.getIdentifier());
    }

    @Test
    public void testGlobalResolver() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("global1", "value1");
        map.put("global2", "value2");
        MapGlobalResolver resolver = new MapGlobalResolver(map);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        ksession.setGlobalResolver((GlobalResolver)resolver);
        Assert.assertEquals((Object)"value1", (Object)ksession.getGlobal("global1"));
        Assert.assertEquals((Object)"value2", (Object)ksession.getGlobal("global2"));
    }

    @Test
    public void testObjectIterator() {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ksession = kBase.newKieSession();
        ksession.insert((Object)new Person("bob", 35));
        ksession.insert((Object)new Cheese("stilton", 35));
        ksession.insert((Object)new Cheese("brie", 35));
        ksession.insert((Object)new Person("steve", 55));
        ksession.insert((Object)new Person("tom", 100));
        int i = 0;
        for (FactHandle fh : ksession.getFactHandles()) {
            if (i++ <= 5) continue;
            Assert.fail((String)"should not iterate for than 3 times");
        }
        i = 0;
        for (FactHandle fh : ksession.getFactHandles()) {
            if (i++ <= 5) continue;
            Assert.fail((String)"should not iterate for than 3 times");
        }
    }

    @Test
    @Ignore
    public void testExecuteQueueActions() {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        ReentrantAction action = new ReentrantAction();
        ksession.queueWorkingMemoryAction((WorkingMemoryAction)action);
        ksession.flushPropagations();
        Assert.assertEquals((long)2L, (long)action.counter.get());
    }

    @Test
    public void testDifferentEntryPointsOnSameFact() {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        Rete rete = kBase.getRete();
        NodeFactory nFacotry = kBase.getConfiguration().getComponentFactory().getNodeFactoryService();
        EntryPointNode epn = nFacotry.buildEntryPointNode(kBase.getReteooBuilder().getIdGenerator().getNextId(), RuleBasePartitionId.MAIN_PARTITION, kBase.getConfiguration().isMultithreadEvaluation(), (ObjectSource)rete, new EntryPointId("xxx"));
        kBase.getRete().addObjectSink((ObjectSink)epn);
        StatefulKnowledgeSession ksession = kBase.newStatefulKnowledgeSession();
        FactHandle f1 = ksession.insert((Object)"f1");
        EntryPoint ep = ksession.getEntryPoint("xxx");
        try {
            ep.update(f1, (Object)"s1");
            Assert.fail((String)"Should throw an exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ep.retract(f1);
            Assert.fail((String)"Should throw an exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ksession.update(f1, (Object)"s1");
        Assert.assertNotNull((Object)ksession.getObject(f1));
        ksession.retract(f1);
        ksession.retract(f1);
        Assert.assertNull((Object)ksession.getObject(f1));
    }

    private static class FinalAction
    extends ReentrantAction {
        public AtomicInteger counter;

        public FinalAction(AtomicInteger counter) {
            this.counter = counter;
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            this.counter.incrementAndGet();
            workingMemory.flushPropagations();
            workingMemory.flushPropagations();
        }
    }

    private static class ReentrantAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        public AtomicInteger counter = new AtomicInteger(0);

        private ReentrantAction() {
        }

        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            throw new IllegalStateException("this method should never be called");
        }

        public void execute(InternalWorkingMemory workingMemory) {
            Assert.assertEquals((long)0L, (long)this.counter.get());
            workingMemory.queueWorkingMemoryAction((WorkingMemoryAction)new FinalAction(this.counter));
            Assert.assertEquals((long)0L, (long)this.counter.get());
            workingMemory.queueWorkingMemoryAction((WorkingMemoryAction)new FinalAction(this.counter));
            Assert.assertEquals((long)0L, (long)this.counter.get());
            workingMemory.flushPropagations();
            Assert.assertEquals((long)0L, (long)this.counter.get());
            workingMemory.flushPropagations();
            Assert.assertEquals((long)0L, (long)this.counter.get());
        }
    }
}

