/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.runtime.help.impl;

import com.thoughtworks.xstream.XStream;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.core.command.runtime.rule.ClearActivationGroupCommand;
import org.drools.core.command.runtime.rule.ClearAgendaCommand;
import org.drools.core.command.runtime.rule.ClearAgendaGroupCommand;
import org.drools.core.command.runtime.rule.ClearRuleFlowGroupCommand;
import org.drools.core.runtime.help.impl.XStreamXML;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XStreamXMLTest {
    private XStream xstream;

    @Before
    public void setup() {
        this.xstream = XStreamXML.newXStreamMarshaller((XStream)new XStream());
    }

    @Test
    public void testMarshallStartProcessCmd() {
        StartProcessCommand cmd = new StartProcessCommand("some-process-id", "some-out-identifier");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertTrue((boolean)xmlString.contains("processId=\"some-process-id\""));
        Assert.assertTrue((boolean)xmlString.contains("out-identifier=\"some-out-identifier\""));
    }

    @Test
    public void testMarshallStartProcessCmdWithNoOutIdentifier() {
        StartProcessCommand cmd = new StartProcessCommand("some-process-id");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertTrue((boolean)xmlString.contains("processId=\"some-process-id\""));
    }

    @Test
    public void testUnMarshallStartProcessCmdWithNoOutIdentifier() {
        Object obj = this.xstream.fromXML("<start-process processId=\"some-process-id\"/>");
        Assert.assertEquals(StartProcessCommand.class, obj.getClass());
        StartProcessCommand cmd = (StartProcessCommand)obj;
        Assert.assertEquals((Object)"some-process-id", (Object)cmd.getProcessId());
    }

    @Test
    public void testMarshallAgendaGroupSetFocusCommand() {
        AgendaGroupSetFocusCommand cmd = new AgendaGroupSetFocusCommand("foo-group");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<set-focus name=\"foo-group\"/>", (Object)xmlString);
        AgendaGroupSetFocusCommand cmd2 = (AgendaGroupSetFocusCommand)this.xstream.fromXML(xmlString);
        Assert.assertEquals((Object)cmd.getName(), (Object)cmd2.getName());
    }

    @Test
    public void testClearActivationGroupCommand() {
        ClearActivationGroupCommand cmd = new ClearActivationGroupCommand("foo-group");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<clear-activation-group name=\"foo-group\"/>", (Object)xmlString);
        ClearActivationGroupCommand cmd2 = (ClearActivationGroupCommand)this.xstream.fromXML(xmlString);
        Assert.assertEquals((Object)cmd.getName(), (Object)cmd2.getName());
    }

    @Test
    public void testClearAgendaGroupCommand() {
        ClearAgendaGroupCommand cmd = new ClearAgendaGroupCommand("foo-group");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<clear-agenda-group name=\"foo-group\"/>", (Object)xmlString);
        ClearAgendaGroupCommand cmd2 = (ClearAgendaGroupCommand)this.xstream.fromXML(xmlString);
        Assert.assertEquals((Object)cmd.getName(), (Object)cmd2.getName());
    }

    @Test
    public void testClearAgendaCommand() {
        ClearAgendaCommand cmd = new ClearAgendaCommand();
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<clear-agenda/>", (Object)xmlString);
        ClearAgendaCommand cmd2 = (ClearAgendaCommand)this.xstream.fromXML(xmlString);
    }

    @Test
    public void testClearRuleFlowGroupCommand() {
        ClearRuleFlowGroupCommand cmd = new ClearRuleFlowGroupCommand("foo-group");
        String xmlString = this.xstream.toXML((Object)cmd);
        Assert.assertEquals((Object)"<clear-ruleflow-group name=\"foo-group\"/>", (Object)xmlString);
        ClearRuleFlowGroupCommand cmd2 = (ClearRuleFlowGroupCommand)this.xstream.fromXML(xmlString);
        Assert.assertEquals((Object)cmd.getName(), (Object)cmd2.getName());
    }
}

