/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.test.dsl;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.DefaultBetaConstraints;
import org.drools.core.common.DoubleBetaConstraints;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.QuadroupleBetaConstraints;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.common.TripleBetaConstraints;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.test.dsl.ReteTesterHelper;
import org.drools.core.reteoo.test.dsl.Step;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.BetaNodeFieldConstraint;

public class NotNodeStep
implements Step {
    private ReteTesterHelper reteTesterHelper;

    public NotNodeStep(ReteTesterHelper reteTesterHelper) {
        this.reteTesterHelper = reteTesterHelper;
    }

    @Override
    public void execute(Map<String, Object> context, List<String[]> args) {
        EmptyBetaConstraints constraints;
        ObjectSource rightObjectSource;
        LeftTupleSource leftTupleSource;
        String name;
        BuildContext buildContext = (BuildContext)context.get("BuildContext");
        if (args.size() != 0) {
            String[] a = args.get(0);
            name = a[0].trim();
            String leftInput = a[1].trim();
            String rightInput = a[2].trim();
            Class cls = null;
            leftTupleSource = leftInput.startsWith("mock") ? new MockTupleSource(buildContext.getNextId()) : (LeftTupleSource)context.get(leftInput);
            if (rightInput.startsWith("mock")) {
                String type = rightInput.substring(5, rightInput.length() - 1);
                try {
                    cls = this.reteTesterHelper.getTypeResolver().resolveType(type);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                rightObjectSource = new MockObjectSource(buildContext.getNextId());
            } else {
                ObjectSource source = rightObjectSource = (ObjectSource)context.get(rightInput);
                while (!(source instanceof ObjectTypeNode)) {
                    source = source.getParentObjectSource();
                }
                cls = ((ClassObjectType)((ObjectTypeNode)source).getObjectType()).getClassType();
            }
            ArrayList<BetaNodeFieldConstraint> list = new ArrayList<BetaNodeFieldConstraint>();
            for (int i = 1; i < args.size(); ++i) {
                a = args.get(i);
                String fieldName = a[0].trim();
                String operator = a[1].trim();
                String var = a[2].trim();
                Declaration declr = (Declaration)context.get(var);
                try {
                    BetaNodeFieldConstraint betaConstraint = this.reteTesterHelper.getBoundVariableConstraint(cls, fieldName, declr, operator);
                    list.add(betaConstraint);
                    continue;
                }
                catch (IntrospectionException e) {
                    throw new IllegalArgumentException();
                }
            }
            switch (list.size()) {
                case 0: {
                    constraints = new EmptyBetaConstraints();
                    break;
                }
                case 1: {
                    constraints = new SingleBetaConstraints((BetaNodeFieldConstraint)list.get(0), buildContext.getKnowledgeBase().getConfiguration());
                    break;
                }
                case 2: {
                    constraints = new DoubleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[2]), buildContext.getKnowledgeBase().getConfiguration());
                    break;
                }
                case 3: {
                    constraints = new TripleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[2]), buildContext.getKnowledgeBase().getConfiguration());
                    break;
                }
                case 4: {
                    constraints = new QuadroupleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[2]), buildContext.getKnowledgeBase().getConfiguration());
                    break;
                }
                default: {
                    constraints = new DefaultBetaConstraints(list.toArray(new BetaNodeFieldConstraint[2]), buildContext.getKnowledgeBase().getConfiguration());
                }
            }
        } else {
            throw new IllegalArgumentException("Cannot arguments " + args);
        }
        NotNode notNode = new NotNode(buildContext.getNextId(), leftTupleSource, rightObjectSource, (BetaConstraints)constraints, buildContext);
        notNode.attach(buildContext);
        context.put(name, notNode);
    }
}

