/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.test.dsl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.drools.core.base.ClassObjectType;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.test.dsl.ReteTesterHelper;
import org.drools.core.reteoo.test.dsl.Step;
import org.drools.core.spi.ObjectType;

public class ObjectTypeNodeStep
implements Step {
    ReteTesterHelper reteTesterHelper;

    public ObjectTypeNodeStep(ReteTesterHelper reteTesterHelper) {
        this.reteTesterHelper = reteTesterHelper;
    }

    @Override
    public void execute(Map<String, Object> context, List<String[]> args) {
        ObjectTypeNode otn;
        BuildContext buildContext = (BuildContext)context.get("BuildContext");
        if (args.size() != 1) {
            throw new IllegalArgumentException("Cannot execute arguments " + args);
        }
        String[] c = args.get(0);
        String name = c[0].trim();
        String type = c[1].trim();
        try {
            EntryPointNode epn = new EntryPointNode(buildContext.getNextId(), (ObjectSource)buildContext.getKnowledgeBase().getRete(), buildContext);
            epn.attach(buildContext);
            Class clazz = this.reteTesterHelper.getTypeResolver().resolveType(type);
            otn = new ObjectTypeNode(buildContext.getNextId(), epn, (ObjectType)new ClassObjectType(clazz), buildContext);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot create OTN " + Arrays.asList(args, e));
        }
        context.put(name, otn);
    }
}

