/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.rule.constraint.MvelConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.test.model.Cheese;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.index.RightTupleList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FieldIndexEntryTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testSingleEntry() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, null, MvelConstraint.INDEX_EVALUATOR);
        AbstractHashTable.SingleIndex singleIndex = new AbstractHashTable.SingleIndex(new AbstractHashTable.FieldIndex[]{fieldIndex}, 1);
        RightTupleList index = new RightTupleList((AbstractHashTable.Index)singleIndex, "stilton".hashCode());
        Assert.assertNull((Object)index.first);
        Assert.assertEquals((long)"stilton".hashCode(), (long)index.hashCode());
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle h1 = new DefaultFactHandle(1, (Object)stilton1);
        RightTuple h1RightTuple = new RightTuple((InternalFactHandle)h1, null);
        index.add(h1RightTuple);
        RightTuple entry1 = index.first;
        Assert.assertSame((Object)h1, (Object)entry1.getFactHandle());
        Assert.assertNull((Object)entry1.getNext());
        Assert.assertSame((Object)entry1, (Object)index.get((InternalFactHandle)h1));
        RightTuple entry2 = index.get(new RightTuple((InternalFactHandle)h1, null));
        Assert.assertSame((Object)entry1, (Object)entry2);
        index.remove(h1RightTuple);
        Assert.assertNull((Object)index.first);
    }

    @Test
    public void testTwoEntries() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, null, MvelConstraint.INDEX_EVALUATOR);
        AbstractHashTable.SingleIndex singleIndex = new AbstractHashTable.SingleIndex(new AbstractHashTable.FieldIndex[]{fieldIndex}, 1);
        RightTupleList index = new RightTupleList((AbstractHashTable.Index)singleIndex, "stilton".hashCode());
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle h1 = new DefaultFactHandle(1, (Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 59);
        DefaultFactHandle h2 = new DefaultFactHandle(2, (Object)stilton2);
        RightTuple h1RightTuple = new RightTuple((InternalFactHandle)h1, null);
        RightTuple h2RightTuple = new RightTuple((InternalFactHandle)h2, null);
        index.add(h1RightTuple);
        index.add(h2RightTuple);
        Assert.assertEquals((Object)h1, (Object)index.first.getFactHandle());
        Assert.assertEquals((Object)h2, (Object)((RightTuple)index.first.getNext()).getFactHandle());
        Assert.assertEquals((Object)h1, (Object)index.get((InternalFactHandle)h1).getFactHandle());
        Assert.assertEquals((Object)h2, (Object)index.get((InternalFactHandle)h2).getFactHandle());
        index.remove(h2RightTuple);
        Assert.assertEquals((Object)h1RightTuple.getFactHandle(), (Object)index.first.getFactHandle());
        index.add(h2RightTuple);
        index.remove(h1RightTuple);
        Assert.assertEquals((Object)h2RightTuple.getFactHandle(), (Object)index.first.getFactHandle());
        stilton1.setType("cheddar");
    }

    @Test
    public void testThreeEntries() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, null, MvelConstraint.INDEX_EVALUATOR);
        AbstractHashTable.SingleIndex singleIndex = new AbstractHashTable.SingleIndex(new AbstractHashTable.FieldIndex[]{fieldIndex}, 1);
        RightTupleList index = new RightTupleList((AbstractHashTable.Index)singleIndex, "stilton".hashCode());
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle h1 = new DefaultFactHandle(1, (Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 59);
        DefaultFactHandle h2 = new DefaultFactHandle(2, (Object)stilton2);
        Cheese stilton3 = new Cheese("stilton", 59);
        DefaultFactHandle h3 = new DefaultFactHandle(3, (Object)stilton3);
        RightTuple h1RightTuple = new RightTuple((InternalFactHandle)h1, null);
        RightTuple h2RightTuple = new RightTuple((InternalFactHandle)h2, null);
        RightTuple h3RightTuple = new RightTuple((InternalFactHandle)h3, null);
        index.add(h1RightTuple);
        index.add(h2RightTuple);
        index.add(h3RightTuple);
        Assert.assertEquals((Object)h1, (Object)index.first.getFactHandle());
        Assert.assertEquals((Object)h2, (Object)((RightTuple)index.first.getNext()).getFactHandle());
        Assert.assertEquals((Object)h3, (Object)((RightTuple)index.first.getNext().getNext()).getFactHandle());
        Assert.assertEquals((Object)h1, (Object)index.get((InternalFactHandle)h1).getFactHandle());
        Assert.assertEquals((Object)h2, (Object)index.get((InternalFactHandle)h2).getFactHandle());
        Assert.assertEquals((Object)h3, (Object)index.get((InternalFactHandle)h3).getFactHandle());
        index.remove(h3RightTuple);
        Assert.assertEquals((Object)h1, (Object)index.first.getFactHandle());
        Assert.assertEquals((Object)h2, (Object)((RightTuple)index.first.getNext()).getFactHandle());
        index.add(h3RightTuple);
        index.remove(h2RightTuple);
        Assert.assertEquals((Object)h1, (Object)index.first.getFactHandle());
        Assert.assertEquals((Object)h3, (Object)((RightTuple)index.first.getNext()).getFactHandle());
        index.add(h2RightTuple);
        index.remove(h1RightTuple);
        Assert.assertEquals((Object)h3, (Object)index.first.getFactHandle());
        Assert.assertEquals((Object)h2, (Object)((RightTuple)index.first.getNext()).getFactHandle());
        index.remove(index.first);
        stilton2.setType("cheddar");
    }
}

