/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.impl.PointInTimeTrigger;

public interface PropagationEntry {
    public void execute(InternalWorkingMemory var1);

    public void execute(InternalKnowledgeRuntime var1);

    public PropagationEntry getNext();

    public void setNext(PropagationEntry var1);

    public boolean isMarshallable();

    public boolean requiresImmediateFlushing();

    public static class Delete
    extends AbstractPropagationEntry {
        private final EntryPointNode epn;
        private final InternalFactHandle handle;
        private final PropagationContext context;
        private final ObjectTypeConf objectTypeConf;

        public Delete(EntryPointNode epn, InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf) {
            this.epn = epn;
            this.handle = handle;
            this.context = context;
            this.objectTypeConf = objectTypeConf;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            this.epn.propagateRetract(this.handle, this.context, this.objectTypeConf, wm);
        }

        public String toString() {
            return "Delete of " + this.handle.getObject();
        }
    }

    public static class Update
    extends AbstractPropagationEntry {
        private final EntryPointNode epn;
        private final InternalFactHandle handle;
        private final PropagationContext context;
        private final ObjectTypeConf objectTypeConf;

        public Update(EntryPointNode epn, InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf) {
            this.epn = epn;
            this.handle = handle;
            this.context = context;
            this.objectTypeConf = objectTypeConf;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            this.epn.propagateModify(this.handle, this.context, this.objectTypeConf, wm);
        }

        public String toString() {
            return "Update of " + this.handle.getObject();
        }
    }

    public static class Insert
    extends AbstractPropagationEntry {
        private static final transient ObjectTypeNode.ExpireJob job = new ObjectTypeNode.ExpireJob();
        private final InternalFactHandle handle;
        private final PropagationContext context;
        private final InternalWorkingMemory workingMemory;
        private final ObjectTypeConf objectTypeConf;
        private final long insertionTime;

        public Insert(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory, ObjectTypeConf objectTypeConf) {
            this.handle = handle;
            this.context = context;
            this.workingMemory = workingMemory;
            this.objectTypeConf = objectTypeConf;
            this.insertionTime = workingMemory.getTimerService().getCurrentTime();
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            for (ObjectTypeNode otn : this.objectTypeConf.getObjectTypeNodes()) {
                otn.propagateAssert(this.handle, this.context, wm);
                this.scheduleExpiration(otn, otn.getExpirationOffset());
            }
            if (this.objectTypeConf.getConcreteObjectTypeNode() == null) {
                this.scheduleExpiration(null, ((ClassObjectTypeConf)this.objectTypeConf).getExpirationOffset());
            }
        }

        private void scheduleExpiration(ObjectTypeNode otn, long expirationOffset) {
            if (expirationOffset < 0L || expirationOffset == Long.MAX_VALUE || this.context.getReaderContext() != null) {
                return;
            }
            EventFactHandle eventFactHandle = (EventFactHandle)this.handle;
            long effectiveEnd = eventFactHandle.getEndTimestamp() + expirationOffset;
            long nextTimestamp = Math.max(this.insertionTime, effectiveEnd >= 0L ? effectiveEnd : Long.MAX_VALUE);
            ObjectTypeNode.ExpireJobContext jobctx = new ObjectTypeNode.ExpireJobContext(new StatefulKnowledgeSessionImpl.WorkingMemoryReteExpireAction((EventFactHandle)this.handle, otn), this.workingMemory);
            if (nextTimestamp < this.workingMemory.getTimerService().getCurrentTime()) {
                job.execute(jobctx);
            } else {
                JobHandle jobHandle = this.workingMemory.getTimerService().scheduleJob(job, jobctx, new PointInTimeTrigger(nextTimestamp, null, null));
                jobctx.setJobHandle(jobHandle);
                eventFactHandle.addJob(jobHandle);
            }
        }

        public String toString() {
            return "Insert of " + this.handle.getObject();
        }
    }

    public static abstract class AbstractPropagationEntry
    implements PropagationEntry {
        private PropagationEntry next;

        @Override
        public void setNext(PropagationEntry next) {
            this.next = next;
        }

        @Override
        public PropagationEntry getNext() {
            return this.next;
        }

        @Override
        public boolean isMarshallable() {
            return false;
        }

        @Override
        public boolean requiresImmediateFlushing() {
            return false;
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((InternalWorkingMemoryEntryPoint)((Object)kruntime)).getInternalWorkingMemory());
        }
    }
}

