/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.ReteDumper;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.WindowNode;
import org.kie.api.runtime.KieSession;

public class ReteMemoryChecker {
    public static void checkNodeMemories(KieSession session) {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)session.getKieBase();
        for (EntryPointNode entryPointNode : kbase.getRete().getEntryPointNodes().values()) {
            ReteMemoryChecker.checkNodeMemory((InternalWorkingMemory)session, (BaseNode)entryPointNode);
        }
    }

    private static void checkNodeMemory(InternalWorkingMemory wm, BaseNode node) {
        Sink[] sinks;
        if (node instanceof MemoryFactory) {
            Memory memory = wm.getNodeMemory((MemoryFactory)node);
            if (30 == node.getType()) {
                if (!(memory instanceof ObjectTypeNode.ObjectTypeNodeMemory)) {
                    throw new RuntimeException("Invalid memory type. Node: " + node + " has memory " + memory);
                }
            } else if (120 == node.getType()) {
                if (!(memory instanceof LeftInputAdapterNode.LiaNodeMemory)) {
                    throw new RuntimeException("Invalid memory type. Node: " + node + " has memory " + memory);
                }
            } else if (NodeTypeEnums.isBetaNode((NetworkNode)node)) {
                if (211 == node.getType() ? !(memory instanceof AccumulateNode.AccumulateMemory) : !(memory instanceof BetaMemory)) {
                    throw new RuntimeException("Invalid memory type. Node: " + node + " has memory " + memory);
                }
            } else if (151 == node.getType()) {
                if (!(memory instanceof FromNode.FromMemory)) {
                    throw new RuntimeException("Invalid memory type. Node: " + node + " has memory " + memory);
                }
            } else if (60 == node.getType()) {
                if (!(memory instanceof WindowNode.WindowMemory)) {
                    throw new RuntimeException("Invalid memory type. Node: " + node + " has memory " + memory);
                }
            } else if (NodeTypeEnums.isTerminalNode((NetworkNode)node)) {
                if (!(memory instanceof PathMemory)) {
                    throw new RuntimeException("Invalid memory type. Node: " + node + " has memory " + memory);
                }
                ReteMemoryChecker.checkPathMemory((PathMemory)memory);
            }
        }
        if ((sinks = ReteDumper.getSinks(node)) != null) {
            for (Sink sink : sinks) {
                if (!(sink instanceof BaseNode)) continue;
                ReteMemoryChecker.checkNodeMemory(wm, (BaseNode)sink);
            }
        }
    }

    private static void checkPathMemory(PathMemory pathMemory) {
        SegmentMemory[] smems = pathMemory.getSegmentMemories();
        if (!NodeTypeEnums.isLeftTupleSource((NetworkNode)smems[0].getRootNode())) {
            throw new RuntimeException("The root node for path " + pathMemory + " has to be a LeftTupleSource but is a " + smems[0].getRootNode());
        }
        if (!NodeTypeEnums.isTerminalNode((NetworkNode)smems[smems.length - 1].getTipNode())) {
            throw new RuntimeException("The tip node for path " + pathMemory + " has to be a TerminalNode but is a " + smems[smems.length - 1].getTipNode());
        }
        for (int i = 0; i < smems.length; ++i) {
            if (smems[i] == null) {
                throw new RuntimeException("Missing segment in position " + i + " for " + pathMemory);
            }
            if (i == smems[i].getPos()) continue;
            throw new RuntimeException("Segment " + smems[i] + " is expected to be in position " + i + " but it is in position " + smems[i].getPos());
        }
    }
}

