/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Arrays;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.FieldFactory;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.MvelConstraintTestUtil;
import org.drools.core.rule.QueryImpl;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.internal.KnowledgeBaseFactory;

@Ignore(value="phreak")
public class QueryTerminalNodeTest {
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext(this.kBase, this.kBase.getReteooBuilder().getIdGenerator());
        this.entryPoint = new EntryPointNode(0, (ObjectSource)this.kBase.getRete(), this.buildContext);
        this.entryPoint.attach(this.buildContext);
    }

    @Test
    public void testQueryTerminalNode() {
        ClassObjectType queryObjectType = new ClassObjectType(DroolsQuery.class);
        ObjectTypeNode queryObjectTypeNode = new ObjectTypeNode(this.buildContext.getNextId(), this.entryPoint, (ObjectType)queryObjectType, this.buildContext);
        queryObjectTypeNode.attach(this.buildContext);
        ClassFieldReader extractor = this.store.getReader(DroolsQuery.class, "name");
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("name == \"query-1\"", FieldFactory.getInstance().getFieldValue((Object)"query-1"), (InternalReadAccessor)extractor);
        QueryImpl query = new QueryImpl("query-1");
        this.buildContext.setRule((RuleImpl)query);
        AlphaNode alphaNode = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)constraint, (ObjectSource)queryObjectTypeNode, this.buildContext);
        alphaNode.attach(this.buildContext);
        LeftInputAdapterNode liaNode = new LeftInputAdapterNode(this.buildContext.getNextId(), (ObjectSource)alphaNode, this.buildContext);
        liaNode.attach(this.buildContext);
        ClassObjectType cheeseObjectType = new ClassObjectType(Cheese.class);
        ObjectTypeNode cheeseObjectTypeNode = new ObjectTypeNode(this.buildContext.getNextId(), this.entryPoint, (ObjectType)cheeseObjectType, this.buildContext);
        cheeseObjectTypeNode.attach(this.buildContext);
        extractor = this.store.getReader(Cheese.class, "type");
        constraint = new MvelConstraintTestUtil("type == \"stilton\"", FieldFactory.getInstance().getFieldValue((Object)"stilton"), (InternalReadAccessor)extractor);
        alphaNode = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)constraint, (ObjectSource)cheeseObjectTypeNode, this.buildContext);
        alphaNode.attach(this.buildContext);
        BuildContext buildContext = new BuildContext(this.kBase, this.kBase.getReteooBuilder().getIdGenerator());
        buildContext.setTupleMemoryEnabled(false);
        JoinNode joinNode = new JoinNode(this.buildContext.getNextId(), (LeftTupleSource)liaNode, (ObjectSource)alphaNode, EmptyBetaConstraints.getInstance(), buildContext);
        joinNode.attach(buildContext);
        QueryTerminalNode queryNode = new QueryTerminalNode(this.buildContext.getNextId(), (LeftTupleSource)joinNode, (RuleImpl)query, query.getLhs(), 0, buildContext);
        queryNode.attach(buildContext);
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("com.drools.test");
        pkg.addRule((RuleImpl)query);
        ((KnowledgeBaseImpl)this.kBase).addPackages(Arrays.asList(pkg));
        KieSession kSession = this.kBase.newKieSession();
        QueryResults results = kSession.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)0L, (long)results.size());
        Cheese stilton1 = new Cheese("stilton", 100);
        FactHandle handle1 = kSession.insert((Object)stilton1);
        results = kSession.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        Cheese cheddar = new Cheese("cheddar", 55);
        kSession.insert((Object)cheddar);
        results = kSession.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        Cheese stilton2 = new Cheese("stilton", 5);
        FactHandle handle2 = kSession.insert((Object)stilton2);
        results = kSession.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)2L, (long)results.size());
        int i = 0;
        for (QueryResultsRow resultRow : results) {
            if (i == 1) {
                // empty if block
            }
            ++i;
        }
        kSession.delete(handle1);
        results = kSession.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        kSession.delete(handle2);
        results = kSession.getQueryResults("query-1", new Object[0]);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    public class Cheese {
        private String type;
        private int price;

        public Cheese(String type, int price) {
            this.type = type;
            this.price = price;
        }

        public int getPrice() {
            return this.price;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "[Cheese type='" + this.type + "' price='" + this.price + "']";
        }
    }
}

