/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.test.parser;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.drools.core.reteoo.test.dsl.DslStep;
import org.drools.core.reteoo.test.dsl.NodeTestCase;
import org.drools.core.reteoo.test.dsl.NodeTestDef;

public class NodeTestDSLFactory {
    private NodeTestCase testCase;
    private NodeTestDef test;
    private DslStep step;
    private Context current;

    public NodeTestCase createTestCase(String name) {
        this.testCase = new NodeTestCase(this.cleanString(name));
        return this.testCase;
    }

    public void createSetup() {
        this.current = Context.SETUP;
    }

    public void createTearDown() {
        this.current = Context.TEARDOWN;
    }

    public void createTest(CommonTree testToken, CommonTree name) {
        this.current = Context.TEST;
        this.test = new NodeTestDef(this.cleanString(name.getText()), testToken.getLine());
        this.testCase.addTest(this.test);
    }

    public void createStep(CommonTree ctx, List<CommonTree> params) {
        this.step = new DslStep(ctx.getLine(), ctx.getText());
        for (CommonTree param : params) {
            String[] cmds = new String[param.getChildCount()];
            int i = 0;
            for (CommonTree child : param.getChildren()) {
                cmds[i++] = child.getText();
            }
            this.step.addCommand(cmds);
        }
        switch (this.current) {
            case SETUP: {
                this.testCase.addSetupStep(this.step);
                break;
            }
            case TEARDOWN: {
                this.testCase.addTearDownStep(this.step);
                break;
            }
            case TEST: {
                this.test.addStep(this.step);
            }
        }
    }

    private String cleanString(String text) {
        return text != null && text.length() > 2 ? text.substring(1, text.length() - 1) : "";
    }

    public static enum Context {
        SETUP,
        TEARDOWN,
        TEST;

    }
}

