/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.util.HashSet;
import org.drools.core.base.ClassTypeResolver;
import org.drools.core.base.SimulateMacOSXClassLoader;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.FirstClass;
import org.drools.core.test.model.Person;
import org.drools.core.test.model.SecondClass;
import org.junit.Assert;
import org.junit.Test;

public class ClassTypeResolverTest {
    @Test
    public void testResolvePrimtiveTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assert.assertEquals(Boolean.TYPE, (Object)resolver.resolveType("boolean"));
        Assert.assertEquals(Double.TYPE, (Object)resolver.resolveType("double"));
        Assert.assertEquals(Float.TYPE, (Object)resolver.resolveType("float"));
        Assert.assertEquals(Integer.TYPE, (Object)resolver.resolveType("int"));
        Assert.assertEquals(Character.TYPE, (Object)resolver.resolveType("char"));
        Assert.assertEquals(Long.TYPE, (Object)resolver.resolveType("long"));
        Assert.assertEquals(Byte.TYPE, (Object)resolver.resolveType("byte"));
        Assert.assertEquals(Short.TYPE, (Object)resolver.resolveType("short"));
    }

    @Test
    public void testResolveArrayOfPrimitiveTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assert.assertEquals(boolean[].class, (Object)resolver.resolveType("boolean[]"));
        Assert.assertEquals(double[].class, (Object)resolver.resolveType("double[]"));
        Assert.assertEquals(float[].class, (Object)resolver.resolveType("float[]"));
        Assert.assertEquals(int[].class, (Object)resolver.resolveType("int[]"));
        Assert.assertEquals(char[].class, (Object)resolver.resolveType("char[]"));
        Assert.assertEquals(long[].class, (Object)resolver.resolveType("long[]"));
        Assert.assertEquals(byte[].class, (Object)resolver.resolveType("byte[]"));
        Assert.assertEquals(short[].class, (Object)resolver.resolveType("short[]"));
    }

    @Test
    public void testResolveMultidimensionnalArrayOfPrimitiveTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assert.assertEquals(int[][].class, (Object)resolver.resolveType("int[][]"));
        Assert.assertEquals(int[][][].class, (Object)resolver.resolveType("int[][][]"));
        Assert.assertEquals(int[][][][].class, (Object)resolver.resolveType("int[][][][]"));
    }

    @Test
    public void testResolveObjectNotFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assert.assertEquals(String.class, (Object)resolver.resolveType("String"));
        Assert.assertEquals(String.class, (Object)resolver.resolveType("java.lang.String"));
        try {
            Assert.assertEquals(Cheese.class, (Object)resolver.resolveType("Cheese"));
            Assert.fail((String)"Should raise a ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals(Cheese.class, (Object)resolver.resolveType("org.drools.core.test.model.Cheese"));
    }

    @Test
    public void testResolveObjectFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.Cheese");
        resolver.addImport("org.drools.core.test.model.FirstClass");
        resolver.addImport("org.drools.core.test.model.FirstClass.AlternativeKey");
        resolver.addImport("org.drools.core.test.model.SecondClass");
        resolver.addImport("org.drools.core.test.model.SecondClass.AlternativeKey");
        Assert.assertEquals(String.class, (Object)resolver.resolveType("String"));
        Assert.assertEquals(String.class, (Object)resolver.resolveType("java.lang.String"));
        Assert.assertEquals(Cheese.class, (Object)resolver.resolveType("Cheese"));
        Assert.assertEquals(Cheese.class, (Object)resolver.resolveType("org.drools.core.test.model.Cheese"));
        Assert.assertEquals(FirstClass.class, (Object)resolver.resolveType("org.drools.core.test.model.FirstClass"));
        Assert.assertEquals(FirstClass.AlternativeKey.class, (Object)resolver.resolveType("org.drools.core.test.model.FirstClass.AlternativeKey"));
        Assert.assertEquals(SecondClass.class, (Object)resolver.resolveType("org.drools.core.test.model.SecondClass"));
        Assert.assertEquals(SecondClass.AlternativeKey.class, (Object)resolver.resolveType("org.drools.core.test.model.SecondClass.AlternativeKey"));
    }

    @Test
    public void testResolveObjectFromImportNested() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.FirstClass");
        Assert.assertEquals(FirstClass.AlternativeKey.class, (Object)resolver.resolveType("FirstClass.AlternativeKey"));
    }

    @Test
    public void testResolveFullTypeName() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.Cheese");
        resolver.addImport("org.drools.core.test.model.FirstClass");
        Assert.assertEquals((Object)"org.drools.core.test.model.Cheese", (Object)resolver.getFullTypeName("Cheese"));
        Assert.assertEquals((Object)"org.drools.core.test.model.FirstClass", (Object)resolver.getFullTypeName("FirstClass"));
    }

    @Test
    public void testResolveObjectFromImportMultipleClassesDifferentPackages() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.Cheese");
        Assert.assertEquals(String.class, (Object)resolver.resolveType("String"));
        Assert.assertEquals(String.class, (Object)resolver.resolveType("java.lang.String"));
        Assert.assertEquals(Cheese.class, (Object)resolver.resolveType("Cheese"));
        Assert.assertEquals(Cheese.class, (Object)resolver.resolveType("org.drools.core.test.model.Cheese"));
    }

    @Test
    public void testResolveArrayOfObjectsNotFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assert.assertEquals(String[].class, (Object)resolver.resolveType("String[]"));
        Assert.assertEquals(String[].class, (Object)resolver.resolveType("java.lang.String[]"));
        try {
            Assert.assertEquals(Cheese[].class, (Object)resolver.resolveType("Cheese[]"));
            Assert.fail((String)"Should raise a ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals(Cheese[].class, (Object)resolver.resolveType("org.drools.core.test.model.Cheese[]"));
    }

    @Test
    public void testResolveArrayOfObjectsFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.Cheese");
        Assert.assertEquals(String[].class, (Object)resolver.resolveType("String[]"));
        Assert.assertEquals(String[].class, (Object)resolver.resolveType("java.lang.String[]"));
        Assert.assertEquals(Cheese[].class, (Object)resolver.resolveType("Cheese[]"));
        Assert.assertEquals(Cheese[].class, (Object)resolver.resolveType("org.drools.core.test.model.Cheese[]"));
    }

    @Test
    public void testResolveMultidimensionnalArrayOfObjectsNotFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        Assert.assertEquals(String[][].class, (Object)resolver.resolveType("String[][]"));
        Assert.assertEquals(String[][].class, (Object)resolver.resolveType("java.lang.String[][]"));
        try {
            Assert.assertEquals(Cheese[][].class, (Object)resolver.resolveType("Cheese[][]"));
            Assert.fail((String)"Should raise a ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals(Cheese[][].class, (Object)resolver.resolveType("org.drools.core.test.model.Cheese[][]"));
    }

    @Test
    public void testResolveMultidimensionnalArrayOfObjectsFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.Cheese");
        Assert.assertEquals(String[][].class, (Object)resolver.resolveType("String[][]"));
        Assert.assertEquals(String[][].class, (Object)resolver.resolveType("java.lang.String[][]"));
        Assert.assertEquals(Cheese[][].class, (Object)resolver.resolveType("Cheese[][]"));
        Assert.assertEquals(Cheese[][].class, (Object)resolver.resolveType("org.drools.core.test.model.Cheese[][]"));
    }

    @Test
    public void testDefaultPackageImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("Goo");
        try {
            resolver.resolveType("Goo");
            Assert.fail((String)"Can't import default namespace classes");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testNestedClassResolving() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.core.test.model.Person.Nested1");
        Assert.assertEquals(Person.Nested1.class, (Object)resolver.resolveType("Nested1"));
        resolver.addImport("org.drools.core.test.model.Person.Nested1.Nested2");
        Assert.assertEquals(Person.Nested1.Nested2.class, (Object)resolver.resolveType("Nested2"));
        resolver.addImport("org.drools.core.test.model.Person.Nested1.Nested2.Nested3");
        Assert.assertEquals(Person.Nested1.Nested2.Nested3.class, (Object)resolver.resolveType("Nested3"));
    }

    @Test
    public void testMacOSXClassLoaderBehavior() throws Exception {
        SimulateMacOSXClassLoader simulatedMacOSXClassLoader = new SimulateMacOSXClassLoader(Thread.currentThread().getContextClassLoader(), new HashSet());
        simulatedMacOSXClassLoader.addClassInScope(Cheese.class);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), (ClassLoader)simulatedMacOSXClassLoader);
        resolver.addImport("org.drools.core.test.model.*");
        Assert.assertEquals(Cheese.class, (Object)resolver.resolveType("Cheese"));
        try {
            resolver.resolveType("cheese");
            Assert.fail((String)"the type cheese (lower-case c) should not exists at all");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testMacOSXClassLoaderBehaviorNested() throws Exception {
        SimulateMacOSXClassLoader simulatedMacOSXClassLoader = new SimulateMacOSXClassLoader(Thread.currentThread().getContextClassLoader(), new HashSet());
        simulatedMacOSXClassLoader.addClassInScope(Person.Nested1.Nested2.class);
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), (ClassLoader)simulatedMacOSXClassLoader);
        resolver.addImport("org.drools.core.test.model.*");
        Assert.assertEquals(Person.Nested1.Nested2.class, (Object)resolver.resolveType("Person.Nested1.Nested2"));
        try {
            resolver.resolveType("Person.nested1.nested2");
            Assert.fail((String)"should have resolved nothing.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

