/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.ArrayList;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.evaluators.EvaluatorRegistry;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.BetaConstraints;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.rule.MvelConstraintTestUtil;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.index.IndexUtil;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.junit.Assert;

public abstract class BaseBetaConstraintsTest {
    public static EvaluatorRegistry registry = new EvaluatorRegistry();

    protected BetaNodeFieldConstraint getConstraint(String identifier, Operator operator, String fieldName, Class clazz) {
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        store.setEagerWire(true);
        ClassFieldReader extractor = store.getReader(clazz, fieldName);
        Declaration declaration = new Declaration(identifier, (InternalReadAccessor)extractor, new Pattern(0, (ObjectType)new ClassObjectType(clazz)));
        String expression = fieldName + " " + operator.getOperatorString() + " " + identifier;
        return new MvelConstraintTestUtil(expression, operator.getOperatorString(), declaration, (InternalReadAccessor)extractor);
    }

    protected void checkBetaConstraints(BetaNodeFieldConstraint[] constraints, Class cls) {
        this.checkBetaConstraints(constraints, cls, (short)181);
    }

    protected void checkBetaConstraints(BetaNodeFieldConstraint[] constraints, Class cls, short betaNodeType) {
        BetaConstraints betaConstraints;
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        int depth = config.getCompositeKeyDepth();
        try {
            betaConstraints = (BetaConstraints)cls.getConstructor(BetaNodeFieldConstraint[].class, RuleBaseConfiguration.class).newInstance(constraints, config);
        }
        catch (Exception e) {
            throw new RuntimeException("could not invoke constructor for " + cls.getName());
        }
        betaConstraints.initIndexes(depth, betaNodeType);
        constraints = betaConstraints.getConstraints();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < constraints.length && list.size() < depth; ++i) {
            if (!((IndexableConstraint)constraints[i]).isIndexable(betaNodeType)) continue;
            list.add(i);
        }
        int[] indexedPositions = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            indexedPositions[i] = i;
        }
        Assert.assertEquals((Object)(indexedPositions.length > 0 ? 1 : 0), (Object)betaConstraints.isIndexed());
        Assert.assertEquals((long)indexedPositions.length, (long)betaConstraints.getIndexCount());
        BetaMemory betaMemory = betaConstraints.createBetaMemory(config, (short)181);
        if (indexedPositions.length > 0) {
            if (((IndexableConstraint)constraints[indexedPositions[0]]).getConstraintType() == IndexUtil.ConstraintType.EQUAL) {
                TupleIndexHashTable tupleHashTable = (TupleIndexHashTable)betaMemory.getLeftTupleMemory();
                Assert.assertTrue((boolean)tupleHashTable.isIndexed());
                AbstractHashTable.Index index = tupleHashTable.getIndex();
                for (int i = 0; i < indexedPositions.length; ++i) {
                    this.checkSameConstraintForIndex((IndexableConstraint)constraints[indexedPositions[i]], index.getFieldIndex(i));
                }
                TupleIndexHashTable factHashTable = (TupleIndexHashTable)betaMemory.getRightTupleMemory();
                Assert.assertTrue((boolean)factHashTable.isIndexed());
                index = factHashTable.getIndex();
                for (int i = 0; i < indexedPositions.length; ++i) {
                    this.checkSameConstraintForIndex((IndexableConstraint)constraints[indexedPositions[i]], index.getFieldIndex(i));
                }
            }
        } else {
            TupleList tupleHashTable = (TupleList)betaMemory.getLeftTupleMemory();
            Assert.assertFalse((boolean)tupleHashTable.isIndexed());
            TupleList factHashTable = (TupleList)betaMemory.getRightTupleMemory();
            Assert.assertFalse((boolean)factHashTable.isIndexed());
        }
    }

    protected void checkSameConstraintForIndex(IndexableConstraint constraint, AbstractHashTable.FieldIndex fieldIndex) {
        Assert.assertSame((Object)constraint.getRequiredDeclarations()[0], (Object)fieldIndex.getDeclaration());
        Assert.assertSame((Object)constraint.getFieldExtractor(), (Object)fieldIndex.getExtractor());
    }

    protected BetaNodeFieldConstraint[] convertToConstraints(LinkedList list) {
        BetaNodeFieldConstraint[] array = new BetaNodeFieldConstraint[list.size()];
        int i = 0;
        for (LinkedListEntry entry = (LinkedListEntry)list.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
            array[i++] = (BetaNodeFieldConstraint)entry.getObject();
        }
        return array;
    }
}

