/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.test.dsl;

import java.beans.IntrospectionException;
import java.util.HashSet;
import java.util.List;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ClassTypeResolver;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.FieldFactory;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorRegistry;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MvelConstraintTestUtil;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;

public class ReteTesterHelper {
    private InternalKnowledgePackage pkg;
    private ClassFieldAccessorStore store;
    private EvaluatorRegistry registry = new EvaluatorRegistry();
    private final ClassTypeResolver typeResolver;

    public ReteTesterHelper() {
        this.pkg = new KnowledgePackageImpl("org.drools.examples.manners");
        this.pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store = this.pkg.getClassFieldAccessorStore();
        this.store.setEagerWire(true);
        this.typeResolver = new ClassTypeResolver(new HashSet(), this.getClass().getClassLoader());
    }

    public InternalKnowledgePackage getPkg() {
        return this.pkg;
    }

    public ClassFieldAccessorStore getStore() {
        return this.store;
    }

    public EvaluatorRegistry getRegistry() {
        return this.registry;
    }

    public ClassTypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public BetaNodeFieldConstraint getBoundVariableConstraint(Class clazz, String fieldName, Declaration declaration, String evaluatorString) throws IntrospectionException {
        ClassFieldReader extractor = this.store.getReader(clazz, fieldName);
        String expression = fieldName + " " + evaluatorString + " " + declaration.getIdentifier();
        return new MvelConstraintTestUtil(expression, declaration, (InternalReadAccessor)extractor);
    }

    public AlphaNodeFieldConstraint getLiteralConstraint(Pattern pattern, String fieldName, String evaluatorString, String value) throws IntrospectionException {
        Class clazz = ((ClassObjectType)pattern.getObjectType()).getClassType();
        ClassFieldReader extractor = this.store.getReader(clazz, fieldName);
        FieldValue fieldValue = FieldFactory.getInstance().getFieldValue((Object)value, extractor.getValueType());
        return new MvelConstraintTestUtil(fieldName + evaluatorString + value, fieldValue, (InternalReadAccessor)extractor);
    }

    public Evaluator getEvaluator(Class<?> cls, String operator) {
        if (cls == DroolsQuery.class) {
            cls = Object.class;
        }
        return this.registry.getEvaluator(ValueType.determineValueType(cls), Operator.determineOperator((String)operator, (boolean)false));
    }

    public Pattern getPattern(int index, String type) throws ClassNotFoundException {
        return new Pattern(index, (ObjectType)new ClassObjectType(this.typeResolver.resolveType(type)));
    }

    public void addImports(List<String> imports) {
        this.typeResolver.clearImports();
        for (String importEntry : imports) {
            this.typeResolver.addImport(importEntry);
        }
    }
}

