/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.DefaultBetaConstraints;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockLeftTupleSink;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.DroolsTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.internal.KnowledgeBaseFactory;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Ignore(value="phreak")
public class NotNodeTest
extends DroolsTestCase {
    RuleImpl rule;
    PropagationContext context;
    StatefulKnowledgeSessionImpl workingMemory;
    MockObjectSource objectSource;
    MockTupleSource tupleSource;
    MockLeftTupleSink sink;
    NotNode node;
    RightInputAdapterNode ria;
    BetaMemory memory;
    BetaNodeFieldConstraint constraint;
    private PropagationContextFactory pctxFactory;

    @Before
    public void setUp() {
        this.constraint = (BetaNodeFieldConstraint)Mockito.mock(BetaNodeFieldConstraint.class);
        ContextEntry c = (ContextEntry)Mockito.mock(ContextEntry.class);
        Mockito.when((Object)this.constraint.createContextEntry()).thenReturn((Object)c);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        this.rule = new RuleImpl("test-rule");
        this.pctxFactory = kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        this.context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        this.workingMemory = new StatefulKnowledgeSessionImpl(1L, kBase);
        RuleBaseConfiguration configuration = new RuleBaseConfiguration();
        kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
        this.objectSource = new MockObjectSource(155);
        this.tupleSource = new MockTupleSource(60);
        this.node = new NotNode(15, (LeftTupleSource)new MockTupleSource(5), (ObjectSource)new MockObjectSource(8), (BetaConstraints)new DefaultBetaConstraints(new BetaNodeFieldConstraint[]{this.constraint}, configuration), buildContext);
        this.sink = new MockLeftTupleSink();
        this.node.addTupleSink((LeftTupleSink)this.sink);
        this.memory = (BetaMemory)this.workingMemory.getNodeMemory((MemoryFactory)this.node);
    }

    public void testNotStandard() {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        Cheese cheddar = new Cheese("cheddar", 10);
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)cheddar);
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f0, (Sink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(1, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
        Assert.assertEquals((Object)new LeftTupleImpl((InternalFactHandle)f0, (Sink)this.sink, true), (Object)((Object[])this.sink.getAsserted().get(0))[0]);
        Assert.assertEquals((long)1L, (long)this.memory.getLeftTupleMemory().size());
        Cheese brie = new Cheese("brie", 10);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)brie);
        this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(1, this.sink.getAsserted());
        this.assertLength(1, this.sink.getRetracted());
        Assert.assertEquals((Object)new LeftTupleImpl((InternalFactHandle)f0, (Sink)this.sink, true), (Object)((Object[])this.sink.getRetracted().get(0))[0]);
        Assert.assertEquals((long)0L, (long)this.memory.getLeftTupleMemory().size());
        DefaultFactHandle f2 = (DefaultFactHandle)this.workingMemory.insert((Object)new Cheese("gouda", 10));
        LeftTupleImpl tuple2 = new LeftTupleImpl((InternalFactHandle)f2, (Sink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple2, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(1, this.sink.getAsserted());
        this.assertLength(1, this.sink.getRetracted());
        Assert.assertEquals((long)0L, (long)this.memory.getLeftTupleMemory().size());
        Assert.assertEquals((long)1L, (long)this.memory.getRightTupleMemory().size());
        this.node.retractRightTuple(f1.getFirstRightTuple(), this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)this.memory.getLeftTupleMemory().size());
        this.assertLength(3, this.sink.getAsserted());
        this.assertLength(1, this.sink.getRetracted());
    }

    @Test
    public void testNotWithConstraints() {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)false);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)false);
        Cheese cheddar = new Cheese("cheddar", 10);
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)cheddar);
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f0, (Sink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(1, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
        Assert.assertEquals((Object)new LeftTupleImpl((InternalFactHandle)f0, (Sink)this.sink, true), (Object)((Object[])this.sink.getAsserted().get(0))[0]);
        Cheese brie = new Cheese("brie", 10);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)brie);
        this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(1, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
        DefaultFactHandle f2 = (DefaultFactHandle)this.workingMemory.insert((Object)new Cheese("gouda", 10));
        LeftTupleImpl tuple2 = new LeftTupleImpl((InternalFactHandle)f2, (Sink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple2, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(2, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
    }

    public void TestNotMemoryManagement() {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        try {
            Cheese cheddar = new Cheese("cheddar", 10);
            DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)cheddar);
            LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f0, (Sink)this.node, true);
            this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
            Cheese brie = new Cheese("brie", 10);
            DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)brie);
            Assert.assertEquals((long)0L, (long)this.memory.getRightTupleMemory().size());
            this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
            Assert.assertEquals((long)1L, (long)this.memory.getRightTupleMemory().size());
            this.node.retractRightTuple(f1.getFirstRightTuple(), this.context, (InternalWorkingMemory)this.workingMemory);
            this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
            Assert.assertEquals((long)1L, (long)this.memory.getRightTupleMemory().size());
            this.node.retractRightTuple(f1.getFirstRightTuple(), this.context, (InternalWorkingMemory)this.workingMemory);
            Assert.assertEquals((long)0L, (long)this.memory.getRightTupleMemory().size());
            Assert.assertEquals((long)1L, (long)this.memory.getLeftTupleMemory().size());
            this.node.retractLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
            this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
            Assert.assertEquals((long)1L, (long)this.memory.getLeftTupleMemory().size());
            this.node.retractLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
            Assert.assertEquals((long)0L, (long)this.memory.getLeftTupleMemory().size());
        }
        catch (Exception e) {
            Assert.fail((String)("No exception should be raised in this procedure, but got: " + e.toString()));
        }
    }

    @Test
    public void testGetConstraints_ReturnsNullEvenWithEmptyBinder() {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        BetaConstraints nullConstraints = EmptyBetaConstraints.getInstance();
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
        NotNode notNode = new NotNode(1, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, nullConstraints, buildContext);
        BetaNodeFieldConstraint[] constraints = notNode.getConstraints();
        Assert.assertEquals((long)0L, (long)constraints.length);
    }

    @Test
    public void testAssertTupleSequentialMode() throws Exception {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setPhreakEnabled(false);
        conf.setSequential(true);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)conf);
        this.workingMemory = new StatefulKnowledgeSessionImpl(1L, kBase);
        BuildContext buildContext = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
        buildContext.setTupleMemoryEnabled(false);
        buildContext.setObjectTypeNodeMemoryEnabled(false);
        this.node = new NotNode(15, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, (BetaConstraints)new DefaultBetaConstraints(new BetaNodeFieldConstraint[]{this.constraint}, conf), buildContext);
        this.node.addTupleSink((LeftTupleSink)this.sink);
        this.memory = (BetaMemory)this.workingMemory.getNodeMemory((MemoryFactory)this.node);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"cheese");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (Sink)this.node, true);
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        this.node.assertLeftTuple((LeftTuple)tuple0, this.pctxFactory.createPropagationContext(0L, 0, null, null, (InternalFactHandle)f0), (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)0L, (long)this.sink.getAsserted().size());
        Assert.assertNull((Object)this.memory.getLeftTupleMemory());
        Assert.assertEquals((long)1L, (long)this.memory.getRightTupleMemory().size());
    }
}

