/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.FieldFactory;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.MockObjectSink;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.MvelConstraintTestUtil;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.DroolsTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBaseFactory;

public class AlphaNodeTest
extends DroolsTestCase {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testLiteralConstraintAssertObjectWithoutMemory() throws Exception {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
        buildContext.setRule(new RuleImpl("test"));
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        RuleImpl rule = new RuleImpl("test-rule");
        PropagationContextFactory pctxFactory = kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        PropagationContext context = pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        MockObjectSource source = new MockObjectSource(buildContext.getNextId());
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        FieldValue field = FieldFactory.getInstance().getFieldValue((Object)"cheddar");
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("type == \"cheddar\"", field, (InternalReadAccessor)extractor);
        AlphaNode alphaNode = new AlphaNode(buildContext.getNextId(), (AlphaNodeFieldConstraint)constraint, (ObjectSource)source, buildContext);
        MockObjectSink sink = new MockObjectSink();
        alphaNode.addObjectSink((ObjectSink)sink);
        Cheese cheddar = new Cheese("cheddar", 5);
        DefaultFactHandle f0 = (DefaultFactHandle)ksession.insert((Object)cheddar);
        this.assertLength(0, sink.getAsserted());
        alphaNode.assertObject((InternalFactHandle)f0, context, (InternalWorkingMemory)ksession);
        Assert.assertEquals((long)1L, (long)sink.getAsserted().size());
        Object[] list = (Object[])sink.getAsserted().get(0);
        Assert.assertSame((Object)cheddar, (Object)ksession.getObject((FactHandle)((DefaultFactHandle)list[0])));
        Cheese stilton = new Cheese("stilton", 6);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)stilton);
        alphaNode.assertObject((InternalFactHandle)f1, context, (InternalWorkingMemory)ksession);
        this.assertLength(1, sink.getAsserted());
        list = (Object[])sink.getAsserted().get(0);
        Assert.assertSame((Object)cheddar, (Object)ksession.getObject((FactHandle)((DefaultFactHandle)list[0])));
    }

    @Test
    public void testReturnValueConstraintAssertObject() throws Exception {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
        buildContext.setRule(new RuleImpl("test"));
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        RuleImpl rule = new RuleImpl("test-rule");
        PropagationContextFactory pctxFactory = kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        PropagationContext context = pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        MockObjectSource source = new MockObjectSource(buildContext.getNextId());
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        FieldValue field = FieldFactory.getInstance().getFieldValue((Object)"cheddar");
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("type == \"cheddar\"", field, (InternalReadAccessor)extractor);
        AlphaNode alphaNode = new AlphaNode(buildContext.getNextId(), (AlphaNodeFieldConstraint)constraint, (ObjectSource)source, buildContext);
        MockObjectSink sink = new MockObjectSink();
        alphaNode.addObjectSink((ObjectSink)sink);
        Cheese cheddar = new Cheese("cheddar", 5);
        DefaultFactHandle f0 = (DefaultFactHandle)ksession.insert((Object)cheddar);
        this.assertLength(0, sink.getAsserted());
        alphaNode.assertObject((InternalFactHandle)f0, context, (InternalWorkingMemory)ksession);
        this.assertLength(1, sink.getAsserted());
        Object[] list = (Object[])sink.getAsserted().get(0);
        Assert.assertSame((Object)cheddar, (Object)ksession.getObject((FactHandle)((DefaultFactHandle)list[0])));
        Cheese stilton = new Cheese("stilton", 6);
        f0.setObject((Object)stilton);
        sink.getAsserted().clear();
        alphaNode.assertObject((InternalFactHandle)f0, context, (InternalWorkingMemory)ksession);
        this.assertLength(0, sink.getAsserted());
    }

    @Test
    public void testUpdateSinkWithoutMemory() {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
        buildContext.setRule(new RuleImpl("test"));
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        RuleImpl rule = new RuleImpl("test-rule");
        PropagationContextFactory pctxFactory = kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        PropagationContext context = pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        MockObjectSource source = new MockObjectSource(buildContext.getNextId());
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        FieldValue field = FieldFactory.getInstance().getFieldValue((Object)"cheddar");
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("type == \"cheddar\"", field, (InternalReadAccessor)extractor);
        AlphaNode alphaNode = new AlphaNode(buildContext.getNextId(), (AlphaNodeFieldConstraint)constraint, (ObjectSource)source, buildContext);
        alphaNode.attach(buildContext);
        MockObjectSink sink1 = new MockObjectSink();
        alphaNode.addObjectSink((ObjectSink)sink1);
        Cheese cheese = new Cheese("cheddar", 0);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)cheese);
        source.addFact((InternalFactHandle)handle1);
        alphaNode.assertObject((InternalFactHandle)handle1, context, (InternalWorkingMemory)ksession);
        Cheese stilton = new Cheese("stilton", 10);
        DefaultFactHandle handle2 = new DefaultFactHandle(2, (Object)stilton);
        source.addFact((InternalFactHandle)handle2);
        alphaNode.assertObject((InternalFactHandle)handle2, context, (InternalWorkingMemory)ksession);
        this.assertLength(1, sink1.getAsserted());
        MockObjectSink sink2 = new MockObjectSink();
        alphaNode.updateSink((ObjectSink)sink2, context, (InternalWorkingMemory)ksession);
        this.assertLength(1, sink1.getAsserted());
        this.assertLength(1, sink2.getAsserted());
        Assert.assertEquals((long)1L, (long)source.getUdated());
    }
}

