/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.ObjectFilter;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.ClassAwareObjectStore;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ClassAwareObjectStoreTest {
    private final ClassAwareObjectStore underTest;
    private static final AtomicInteger factCounter = new AtomicInteger(0);

    @Test
    public void iterateObjectsReturnsObjectsOfAllTypes() throws Exception {
        String aStringValue = "a string";
        BigDecimal bigDecimalValue = new BigDecimal("1");
        this.insertObjectWithFactHandle(aStringValue);
        this.insertObjectWithFactHandle(bigDecimalValue);
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects());
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void iterateByClassFiltersByClass() {
        SimpleClass object = new SimpleClass();
        this.insertObjectWithFactHandle("some string");
        this.insertObjectWithFactHandle(object);
        Collection results = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SimpleClass.class));
        Assert.assertThat((Object)results.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        Assert.assertThat(results, (Matcher)CoreMatchers.hasItem((Object)object));
    }

    @Test
    public void queryBySuperTypeFindsSubType() throws Exception {
        this.insertObjectWithFactHandle(new SubClass());
        this.insertObjectWithFactHandle(new SuperClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SuperClass.class));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        Assert.assertThat(result, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.isA(SubClass.class)));
        Assert.assertThat(result, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.isA(SuperClass.class)));
    }

    @Test
    public void queryBySubtypeDoesNotReturnSuperType() throws Exception {
        this.insertObjectWithFactHandle(new SubClass());
        this.insertObjectWithFactHandle(new SuperClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SubClass.class));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        Assert.assertThat(result, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.isA(SubClass.class)));
    }

    @Test
    public void queryBySubTypeDoesNotPreventInsertionsBeingPropogatedToSuperTypeQueries() throws Exception {
        this.insertObjectWithFactHandle(new SuperClass());
        ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SubClass.class));
        this.insertObjectWithFactHandle(new SubClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SuperClass.class));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        Assert.assertThat(result, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.isA(SubClass.class)));
        Assert.assertThat(result, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.isA(SuperClass.class)));
    }

    @Test
    public void queryBySuperTypeCanFindSubTypeWhenNoSuperTypeInstancesAreInStore() throws Exception {
        this.insertObjectWithFactHandle(new SubClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SuperClass.class));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        Assert.assertThat(result, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.isA(SubClass.class)));
    }

    @Test
    public void isOkayToReinsertSameTypeThenQuery() throws Exception {
        this.insertObjectWithFactHandle(new SubClass());
        this.insertObjectWithFactHandle(new SubClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SuperClass.class));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        Assert.assertThat((Object)new HashSet(result).size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void onceSuperClassIsSetUpForReadingItCanBecomeSetUpForWritingWithoutGettingDuplicateQueryReturns() throws Exception {
        Assert.assertTrue((boolean)ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SuperClass.class)).isEmpty());
        this.insertObjectWithFactHandle(new SubClass());
        this.insertObjectWithFactHandle(new SuperClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects(SuperClass.class));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
        Assert.assertThat((Object)new HashSet(result).size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void clearRemovesInsertedObjects() throws Exception {
        this.insertObjectWithFactHandle(new SimpleClass());
        Assert.assertThat((Object)ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects()).size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        this.underTest.clear();
        Assert.assertThat((Object)ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects()).size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
    }

    @Test
    public void canIterateOverObjectsUsingCustomFilter() throws Exception {
        this.insertObjectWithFactHandle(new SuperClass());
        this.insertObjectWithFactHandle(new SubClass());
        Collection result = ClassAwareObjectStoreTest.collect(this.underTest.iterateObjects((org.kie.api.runtime.ObjectFilter)new ObjectFilter(){

            public boolean accept(Object o) {
                return SubClass.class.isInstance(o);
            }
        }));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        Assert.assertThat(result, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.isA(SubClass.class)));
    }

    @Test
    public void iteratingOverFactHandlesHasSameNumberOfResultsAsIteratingOverObjects() throws Exception {
        this.insertObjectWithFactHandle(new SuperClass());
        this.insertObjectWithFactHandle(new SubClass());
        Assert.assertThat((Object)ClassAwareObjectStoreTest.collect(this.underTest.iterateFactHandles(SubClass.class)).size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        Assert.assertThat((Object)ClassAwareObjectStoreTest.collect(this.underTest.iterateFactHandles(SuperClass.class)).size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    private void insertObjectWithFactHandle(Object objectToInsert) {
        this.underTest.addHandle(this.handleFor(objectToInsert), objectToInsert);
    }

    public ClassAwareObjectStore getUnderTest() {
        return this.underTest;
    }

    private static <T> Collection<T> collect(Iterator<T> objects) {
        ArrayList<T> result = new ArrayList<T>();
        while (objects.hasNext()) {
            result.add(objects.next());
        }
        return result;
    }

    public ClassAwareObjectStoreTest(RuleBaseConfiguration ruleBaseConfiguration) {
        this.underTest = new ClassAwareObjectStore(ruleBaseConfiguration, (Lock)new ReentrantLock());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> ruleBaseConfigurations() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>(2);
        configurations.add(new Object[]{new RuleBaseConfiguration(){
            {
                this.setAssertBehaviour(RuleBaseConfiguration.AssertBehaviour.EQUALITY);
            }
        }});
        configurations.add(new Object[]{new RuleBaseConfiguration(){
            {
                this.setAssertBehaviour(RuleBaseConfiguration.AssertBehaviour.IDENTITY);
            }
        }});
        return configurations;
    }

    private InternalFactHandle handleFor(Object object) {
        return new DefaultFactHandle(factCounter.getAndIncrement(), object);
    }

    private static class SubClass
    extends SuperClass {
        private SubClass() {
        }
    }

    private static class SuperClass {
        private SuperClass() {
        }
    }

    private static class SimpleClass {
        private SimpleClass() {
        }
    }
}

