/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.drools.core.base.SalienceInteger;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.base.mvel.MVELEnabledExpression;
import org.drools.core.base.mvel.MVELSalienceExpression;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryActions;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.ScheduledAgendaItem;
import org.drools.core.common.TruthMaintenanceSystemHelper;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.time.impl.BaseTimer;
import org.kie.api.definition.rule.Rule;
import org.kie.api.event.rule.MatchCancelledCause;

public class RuleTerminalNode
extends AbstractTerminalNode {
    private static final long serialVersionUID = 510L;
    protected RuleImpl rule;
    protected GroupElement subrule;
    protected int subruleIndex;
    protected Declaration[] allDeclarations;
    protected Declaration[] requiredDeclarations;
    protected Declaration[][] timerDeclarations;
    protected Declaration[] salienceDeclarations;
    protected Declaration[] enabledDeclarations;
    protected LeftTupleSinkNode previousTupleSinkNode;
    protected LeftTupleSinkNode nextTupleSinkNode;
    protected boolean fireDirect;
    protected transient ObjectTypeNode.Id leftInputOtnId;
    protected String consequenceName;

    public RuleTerminalNode() {
    }

    public RuleTerminalNode(int id, LeftTupleSource source, RuleImpl rule, GroupElement subrule, int subruleIndex, BuildContext context) {
        super(id, context.getPartitionId(), context.getKnowledgeBase().getConfiguration().isMultithreadEvaluation(), source, context);
        this.rule = rule;
        this.subrule = subrule;
        this.consequenceName = context.getConsequenceName();
        this.initDeclarations();
        this.subruleIndex = subruleIndex;
        this.setFireDirect(rule.getActivationListener().equals("direct"));
        if (this.isFireDirect()) {
            rule.setSalience(new SalienceInteger(Integer.MAX_VALUE));
        }
        this.setDeclarations(this.subrule.getOuterDeclarations());
        this.initDeclaredMask(context);
        this.initInferredMask();
        this.hashcode = this.calculateHashCode();
    }

    public void setDeclarations(Map<String, Declaration> decls) {
        int i;
        Declaration[] declrs;
        MVELCompileable expr;
        if (this.rule.getSalience() instanceof MVELSalienceExpression) {
            expr = (MVELSalienceExpression)this.rule.getSalience();
            declrs = ((MVELSalienceExpression)expr).getMVELCompilationUnit().getPreviousDeclarations();
            this.salienceDeclarations = new Declaration[declrs.length];
            i = 0;
            for (Declaration declr : declrs) {
                this.salienceDeclarations[i++] = decls.get(declr.getIdentifier());
            }
            Arrays.sort(this.salienceDeclarations, SortDeclarations.instance);
        }
        if (this.rule.getEnabled() instanceof MVELEnabledExpression) {
            expr = (MVELEnabledExpression)this.rule.getEnabled();
            declrs = ((MVELEnabledExpression)expr).getMVELCompilationUnit().getPreviousDeclarations();
            this.enabledDeclarations = new Declaration[declrs.length];
            i = 0;
            for (Declaration declr : declrs) {
                this.enabledDeclarations[i++] = decls.get(declr.getIdentifier());
            }
            Arrays.sort(this.enabledDeclarations, SortDeclarations.instance);
        }
        if (this.rule.getTimer() instanceof BaseTimer) {
            this.timerDeclarations = ((BaseTimer)((Object)this.rule.getTimer())).getTimerDeclarations(decls);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.rule = (RuleImpl)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.subruleIndex = in.readInt();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.timerDeclarations = (Declaration[][])in.readObject();
        this.salienceDeclarations = (Declaration[])in.readObject();
        this.enabledDeclarations = (Declaration[])in.readObject();
        this.consequenceName = (String)in.readObject();
        this.fireDirect = this.rule.getActivationListener().equals("direct");
        this.initDeclarations();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.rule);
        out.writeObject(this.subrule);
        out.writeInt(this.subruleIndex);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
        out.writeObject(this.timerDeclarations);
        out.writeObject(this.salienceDeclarations);
        out.writeObject(this.enabledDeclarations);
        out.writeObject(this.consequenceName);
    }

    @Override
    public RuleImpl getRule() {
        return this.rule;
    }

    @Override
    public GroupElement getSubRule() {
        return this.subrule;
    }

    public static PropagationContext findMostRecentPropagationContext(Tuple leftTuple, PropagationContext context) {
        for (Tuple lt = leftTuple; lt != null; lt = lt.getParent()) {
            if (lt.getPropagationContext() == null || lt.getPropagationContext().getPropagationNumber() <= context.getPropagationNumber()) continue;
            context = lt.getPropagationContext();
        }
        return context;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[RuleTerminalNode(").append(this.getId()).append("): rule=").append(this.rule.getName());
        if (this.consequenceName != null) {
            sb.append(", consequence=").append(this.consequenceName);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void attach(BuildContext context) {
        this.getLeftTupleSource().addTupleSink(this, context);
        this.addAssociation(context, (Rule)context.getRule());
    }

    @Override
    public Declaration[] getAllDeclarations() {
        return this.allDeclarations;
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    private void initDeclarations() {
        Map<String, Declaration> decls = this.subrule.getOuterDeclarations();
        this.allDeclarations = decls.values().toArray(new Declaration[decls.size()]);
        Arrays.sort(this.allDeclarations, SortDeclarations.instance);
        String[] requiredDeclarationNames = this.rule.getRequiredDeclarationsForConsequence(this.getConsequenceName());
        this.requiredDeclarations = new Declaration[requiredDeclarationNames.length];
        int i = 0;
        for (String str : requiredDeclarationNames) {
            this.requiredDeclarations[i++] = decls.get(str);
        }
        Arrays.sort(this.requiredDeclarations, SortDeclarations.instance);
    }

    @Override
    public Declaration[][] getTimerDeclarations() {
        return this.timerDeclarations;
    }

    @Override
    public Declaration[] getSalienceDeclarations() {
        return this.salienceDeclarations;
    }

    public void setSalienceDeclarations(Declaration[] salienceDeclarations) {
        this.salienceDeclarations = salienceDeclarations;
    }

    public Declaration[] getEnabledDeclarations() {
        return this.enabledDeclarations;
    }

    public String getConsequenceName() {
        return this.consequenceName == null ? "default" : this.consequenceName;
    }

    public void cancelMatch(AgendaItem match, InternalWorkingMemoryActions workingMemory) {
        match.cancel();
        if (match.isQueued()) {
            Tuple leftTuple = match.getTuple();
            if (match.getRuleAgendaItem() != null && leftTuple.getMemory() != null) {
                leftTuple.getMemory().remove(leftTuple);
            }
            PhreakRuleTerminalNode.doLeftDelete(workingMemory.getAgenda(), ((RuleTerminalNodeLeftTuple)leftTuple).getRuleAgendaItem().getRuleExecutor(), leftTuple);
        }
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    private int calculateHashCode() {
        return 31 * this.rule.hashCode() + (this.consequenceName == null ? 0 : 37 * this.consequenceName.hashCode());
    }

    public boolean equals(Object object) {
        return this == object || this.internalEquals(object);
    }

    @Override
    protected boolean internalEquals(Object object) {
        if (object == null || !(object instanceof RuleTerminalNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        RuleTerminalNode other = (RuleTerminalNode)object;
        return this.rule.equals(other.rule) && (this.consequenceName == null ? other.consequenceName == null : this.consequenceName.equals(other.consequenceName));
    }

    @Override
    public short getType() {
        return 101;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new RuleTerminalNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, Sink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public ObjectTypeNode.Id getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    @Override
    public void setLeftInputOtnId(ObjectTypeNode.Id leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }

    @Override
    public boolean isFireDirect() {
        return this.fireDirect;
    }

    public void setFireDirect(boolean fireDirect) {
        this.fireDirect = fireDirect;
    }

    protected ObjectTypeNode getObjectTypeNode() {
        return this.getLeftTupleSource().getObjectTypeNode();
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("Rete Only");
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("Rete Only");
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("Rete Only");
    }

    public static class RTNCleanupAdapter
    implements RuleRemovalContext.CleanupAdapter {
        private final RuleTerminalNode node;

        public RTNCleanupAdapter(RuleTerminalNode node) {
            this.node = node;
        }

        @Override
        public void cleanUp(LeftTuple leftTuple, InternalWorkingMemory workingMemory) {
            if (leftTuple.getTupleSink() != this.node) {
                return;
            }
            Activation activation = (Activation)leftTuple.getContextObject();
            if (activation instanceof ScheduledAgendaItem) {
                ScheduledAgendaItem scheduled = (ScheduledAgendaItem)activation;
                workingMemory.getTimerService().removeJob(scheduled.getJobHandle());
                scheduled.getJobHandle().setCancel(true);
            }
            if (activation.isQueued()) {
                activation.remove();
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory, MatchCancelledCause.CLEAR);
            }
            PropagationContextFactory pctxFactory = workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
            PropagationContext propagationContext = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), PropagationContext.Type.RULE_REMOVAL, null, null, null);
            TruthMaintenanceSystemHelper.removeLogicalDependencies(activation, propagationContext, this.node.getRule());
            leftTuple.unlinkFromLeftParent();
            leftTuple.unlinkFromRightParent();
        }
    }

    public static class SortDeclarations
    implements Comparator<Declaration> {
        public static final SortDeclarations instance = new SortDeclarations();

        @Override
        public int compare(Declaration d1, Declaration d2) {
            return d1.getIdentifier().compareTo(d2.getIdentifier());
        }
    }
}

