/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.xml;

import java.util.Collection;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.xml.ChangeSetSemanticModule;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.drools.core.xml.XmlChangeSetReader;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.internal.ChangeSet;

public class XmlChangeSetReaderTest {
    @Test
    public void testResourceAttributes() throws Exception {
        SemanticModules semanticModules = new SemanticModules();
        semanticModules.addSemanticModule((SemanticModule)new ChangeSetSemanticModule());
        XmlChangeSetReader changeSetReader = new XmlChangeSetReader(semanticModules);
        changeSetReader.setClassLoader(XmlChangeSetReaderTest.class.getClassLoader(), null);
        ChangeSet changeSet = changeSetReader.read(XmlChangeSetReaderTest.class.getClassLoader().getResourceAsStream("org/drools/core/xml/test-change-set.xml"));
        Assert.assertNotNull((Object)changeSet);
        Collection resourcesAdded = changeSet.getResourcesAdded();
        Assert.assertNotNull((Object)resourcesAdded);
        Assert.assertEquals((long)4L, (long)resourcesAdded.size());
        InternalResource resource1 = null;
        InternalResource resource2 = null;
        InternalResource resource3 = null;
        InternalResource secureResource = null;
        for (Resource r : resourcesAdded) {
            InternalResource resource = (InternalResource)r;
            if (resource.getSourcePath() != null && resource.getSourcePath().equals("resource1")) {
                resource1 = resource;
                continue;
            }
            if (resource.getSourcePath() != null && resource.getSourcePath().equals("secureResource")) {
                secureResource = resource;
                continue;
            }
            if (resource.getSourcePath() == null && resource.getDescription() == null) {
                resource3 = resource;
                continue;
            }
            if (resource.getSourcePath() != null) continue;
            resource2 = resource;
        }
        Assert.assertNotNull(resource1);
        Assert.assertNotNull(resource2);
        Assert.assertNotNull(resource3);
        Assert.assertNotNull(secureResource);
        Assert.assertNull((Object)resource1.getDescription());
        Assert.assertEquals((Object)"another description", (Object)resource2.getDescription());
        Assert.assertEquals((Object)"some useful description", (Object)secureResource.getDescription());
    }
}

