/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import org.kie.api.runtime.rule.AccumulateFunction;

public class BigDecimalSumAccumulateFunction
implements AccumulateFunction {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public Serializable createContext() {
        return new SumData();
    }

    public void init(Serializable context) {
        SumData data = (SumData)context;
        data.total = BigDecimal.ZERO;
    }

    public void accumulate(Serializable context, Object value) {
        if (value != null) {
            SumData data = (SumData)context;
            data.total = data.total.add((BigDecimal)value);
        }
    }

    public void reverse(Serializable context, Object value) {
        if (value != null) {
            SumData data = (SumData)context;
            data.total = data.total.subtract((BigDecimal)value);
        }
    }

    public Object getResult(Serializable context) {
        SumData data = (SumData)context;
        return data.total;
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return BigDecimal.class;
    }

    protected static class SumData
    implements Externalizable {
        public BigDecimal total = BigDecimal.ZERO;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total = (BigDecimal)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.total);
        }
    }
}

