/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.examples.manners;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Context
implements Externalizable {
    private static final long serialVersionUID = 510L;
    public static final int START_UP = 0;
    public static final int ASSIGN_SEATS = 1;
    public static final int MAKE_PATH = 2;
    public static final int CHECK_DONE = 3;
    public static final int PRINT_RESULTS = 4;
    public static final String[] stateStrings = new String[]{"START_UP", "ASSIGN_SEATS", "MAKE_PATH", "CHECK_DONE", "PRINT_RESULTS"};
    private int state;

    public Context() {
    }

    public Context(String state) {
        if (!"start".equals(state)) {
            throw new RuntimeException("Context '" + state + "' does not exist for Context Enum");
        }
        this.state = 0;
    }

    public Context(int state) {
        this.state = state;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.state = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.state);
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isState(int state) {
        return this.state == state;
    }

    public int getState() {
        return this.state;
    }

    public String getStringValue() {
        return stateStrings[this.state];
    }

    public String toString() {
        return "[Context state=" + this.getStringValue() + "]";
    }
}

