/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.HashSet;
import java.util.Set;
import org.drools.core.common.BaseNode;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.Sink;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.internal.runtime.KnowledgeRuntime;

public class ReteDumper {
    private ReteDumper() {
    }

    public static void dumpRete(KieBase kbase) {
        ReteDumper.dumpRete((InternalKnowledgeBase)kbase);
    }

    public static void dumpRete(KnowledgeRuntime session) {
        ReteDumper.dumpRete((InternalKnowledgeBase)session.getKieBase());
    }

    public static void dumpRete(KieSession session) {
        ReteDumper.dumpRete((InternalKnowledgeBase)session.getKieBase());
    }

    public static void dumpRete(InternalKnowledgeBase kBase) {
        ReteDumper.dumpRete(kBase.getRete());
    }

    public static void dumpRete(Rete rete) {
        for (EntryPointNode entryPointNode : rete.getEntryPointNodes().values()) {
            ReteDumper.dumpNode((BaseNode)entryPointNode, "", new HashSet<BaseNode>());
        }
    }

    private static void dumpNode(BaseNode node, String ident, Set<BaseNode> visitedNodes) {
        System.out.println(ident + node + " on " + node.getPartitionId());
        if (!visitedNodes.add(node)) {
            return;
        }
        Sink[] sinks = node.getSinks();
        if (sinks != null) {
            for (Sink sink : sinks) {
                if (!(sink instanceof BaseNode)) continue;
                ReteDumper.dumpNode((BaseNode)sink, ident + "    ", visitedNodes);
            }
        }
    }
}

