/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.drools.core.base.ClassObjectType;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.MockObjectSink;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.ObjectType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.KnowledgeBaseFactory;

public class PropertyChangeListenerTest {
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;

    @Before
    public void setUp() throws Exception {
        this.kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext(this.kBase);
        this.entryPoint = (EntryPointNode)this.buildContext.getKnowledgeBase().getRete().getEntryPointNodes().values().iterator().next();
    }

    @Test
    public void test1() {
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(State.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        State a = new State("go");
        ksession.insert((Object)a, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)sink.getAsserted().size());
        a.setState("stop");
    }

    public static class State {
        private final PropertyChangeSupport changes = new PropertyChangeSupport(this);
        private String state;

        public State(String state) {
            this.state = state;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String newState) {
            String oldState = this.state;
            this.state = newState;
            this.changes.firePropertyChange("state", oldState, newState);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.changes.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.changes.removePropertyChangeListener(l);
        }
    }
}

