/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.drools.core.common.BaseNode;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.Sink;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.internal.runtime.KnowledgeRuntime;

public class ReteDumper {
    private ReteDumper() {
    }

    public static void dumpRete(KieBase kbase) {
        ReteDumper.dumpRete((InternalKnowledgeBase)kbase);
    }

    public static void dumpRete(KnowledgeRuntime session) {
        ReteDumper.dumpRete((InternalKnowledgeBase)session.getKieBase());
    }

    public static void dumpRete(KieSession session) {
        ReteDumper.dumpRete((InternalKnowledgeBase)session.getKieBase());
    }

    public static void dumpRete(InternalKnowledgeBase kBase) {
        ReteDumper.dumpRete(kBase.getRete());
    }

    public static void dumpRete(Rete rete) {
        for (EntryPointNode entryPointNode : rete.getEntryPointNodes().values()) {
            ReteDumper.dumpNode((BaseNode)entryPointNode, "", new HashSet<BaseNode>());
        }
    }

    private static void dumpNode(BaseNode node, String ident, Set<BaseNode> visitedNodes) {
        Object inferreddMask;
        Object declaredMask2;
        System.out.print(ident + node + " on " + node.getPartitionId());
        try {
            declaredMask2 = node.getClass().getMethod("getDeclaredMask", new Class[0]).invoke((Object)node, new Object[0]);
            inferreddMask = node.getClass().getMethod("getInferredMask", new Class[0]).invoke((Object)node, new Object[0]);
            System.out.print(" d " + declaredMask2 + " i " + inferreddMask);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException declaredMask2) {
            // empty catch block
        }
        try {
            declaredMask2 = node.getClass().getMethod("getLeftDeclaredMask", new Class[0]).invoke((Object)node, new Object[0]);
            inferreddMask = node.getClass().getMethod("getLeftInferredMask", new Class[0]).invoke((Object)node, new Object[0]);
            System.out.print(" Ld " + declaredMask2 + " Li " + inferreddMask);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException declaredMask3) {
            // empty catch block
        }
        try {
            declaredMask2 = node.getClass().getMethod("getRightDeclaredMask", new Class[0]).invoke((Object)node, new Object[0]);
            inferreddMask = node.getClass().getMethod("getRightInferredMask", new Class[0]).invoke((Object)node, new Object[0]);
            System.out.print(" Rd " + declaredMask2 + " Ri " + inferreddMask);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException declaredMask4) {
            // empty catch block
        }
        System.out.print("\n");
        if (!visitedNodes.add(node)) {
            return;
        }
        Sink[] sinks = node.getSinks();
        if (sinks != null) {
            for (Sink sink : sinks) {
                if (!(sink instanceof BaseNode)) continue;
                ReteDumper.dumpNode((BaseNode)sink, ident + "    ", visitedNodes);
            }
        }
    }
}

