/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.test.dsl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.drools.core.base.ArrayElements;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.reteoo.test.dsl.ReteTesterHelper;
import org.drools.core.reteoo.test.dsl.Step;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.InternalReadAccessor;

public class BindingStep
implements Step {
    private ReteTesterHelper reteTesterHelper;

    public BindingStep(ReteTesterHelper reteTesterHelper) {
        this.reteTesterHelper = reteTesterHelper;
    }

    @Override
    public void execute(Map<String, Object> context, List<String[]> args) {
        if (args.size() > 0) {
            for (Object[] objectArray : args) {
                if (objectArray.length == 4 || objectArray.length == 5) {
                    this.createBinding(context, (String[])objectArray);
                    continue;
                }
                throw new IllegalArgumentException("Cannot create Binding for arguments: " + Arrays.toString(objectArray));
            }
        } else {
            throw new IllegalArgumentException("Cannot arguments " + args);
        }
    }

    private void createBinding(Map<String, Object> context, String[] bind) {
        String name = bind[0];
        String index = bind[1];
        String type = bind[2];
        String field = bind[3];
        String cast = null;
        if (bind.length == 5) {
            cast = bind[4];
        }
        try {
            Pattern pattern = this.reteTesterHelper.getPattern(Integer.parseInt(index), type);
            ClassFieldAccessorStore store = (ClassFieldAccessorStore)context.get("ClassFieldAccessorStore");
            ClassFieldReader extractor = null;
            if (field.startsWith("[")) {
                extractor = store.getReader(ArrayElements.class, "elements");
                extractor = new ArrayElementReader((InternalReadAccessor)extractor, Integer.parseInt(field.substring(1, field.length() - 1)), this.reteTesterHelper.getTypeResolver().resolveType(cast));
            } else {
                extractor = store.getReader(this.reteTesterHelper.getTypeResolver().resolveType(type), field);
            }
            Declaration declr = new Declaration(name, (InternalReadAccessor)extractor, pattern);
            context.put(name, declr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create Binding for arguments: " + Arrays.toString(bind), e);
        }
    }
}

