/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.rule.EntryPointId;
import org.drools.core.test.model.MockActivation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LazyTMSEnablingTest {
    private StatefulKnowledgeSessionImpl ksession;
    private TruthMaintenanceSystem tms;

    @Before
    public void setUp() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        this.tms = ((NamedEntryPoint)this.ksession.getWorkingMemoryEntryPoint(EntryPointId.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
    }

    @Test
    public void shouldLazilyAdd() throws Exception {
        String fact1 = "logical";
        this.ksession.insert((Object)"logical");
        Assert.assertEquals((String)"Shouldn't have anything, since no logical insert was performed.", (long)0L, (long)this.tms.getEqualityKeyMap().size());
        String fact2 = "logical";
        this.ksession.getTruthMaintenanceSystem().insert((Object)"logical", null, null, new MockActivation());
        Assert.assertEquals((String)"Now that a logical insert was done, it should have an element.", (long)1L, (long)this.tms.getEqualityKeyMap().size());
        ObjectTypeConf typeConf = this.ksession.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.ksession.getEntryPoint(), (Object)"logical");
        Assert.assertTrue((String)"Should have enabled TMS", (boolean)typeConf.isTMSEnabled());
    }

    @Test
    public void shouldEnableTMSForSpecificType() throws Exception {
        String stringFact1 = "toto";
        String stringFact2 = "toto";
        String anotherString = "tata";
        Integer intFact1 = 99;
        Integer intFact2 = 99;
        Double doubleFact = 77.8;
        ObjectTypeConf stringTypeConf = this.ksession.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.ksession.getEntryPoint(), (Object)"toto");
        ObjectTypeConf intTypeConf = this.ksession.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.ksession.getEntryPoint(), (Object)intFact1);
        this.ksession.insert((Object)"toto");
        this.ksession.insert((Object)"tata");
        this.ksession.insert((Object)intFact1);
        this.ksession.insert((Object)doubleFact);
        for (ObjectTypeConf conf : this.ksession.getObjectTypeConfigurationRegistry().values()) {
            Assert.assertFalse((String)"TMS shouldn't be enabled for any type, since no logical insert was done.", (boolean)conf.isTMSEnabled());
        }
        this.ksession.getTruthMaintenanceSystem().insert((Object)"toto", null, null, new MockActivation());
        Assert.assertTrue((String)"Should have enabled TMS for Strings.", (boolean)stringTypeConf.isTMSEnabled());
        Assert.assertFalse((String)"Shouldn't have enabled TMS for Integers.", (boolean)intTypeConf.isTMSEnabled());
        this.ksession.getTruthMaintenanceSystem().insert((Object)intFact2, null, null, new MockActivation());
        Assert.assertTrue((String)"Now it should have enabled TMS for Integers!.", (boolean)intTypeConf.isTMSEnabled());
    }
}

