/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.ruleunit;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.ruleunit.RuleUnitDescription;
import org.drools.core.ruleunit.RuleUnitDescriptionLoader;
import org.drools.core.ruleunit.RuleUnitDescriptionRegistry;
import org.drools.core.ruleunit.RuleUnitTestUtil;
import org.drools.core.ruleunit.TestRuleUnit;
import org.drools.core.ruleunit.TestRuleUnit2;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleUnit;
import org.mockito.Mockito;

public class RuleUnitDescriptionRegistryTest {
    private RuleUnitDescriptionRegistry registry;

    @Before
    public void prepareRuleUnitDescriptionRegistry() {
        this.registry = new RuleUnitDescriptionRegistry();
    }

    @Test
    public void getDescriptionForUnit() {
        TestRuleUnit testRuleUnit = new TestRuleUnit(new Integer[0], BigDecimal.ZERO);
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> this.registry.getDescription((RuleUnit)testRuleUnit));
        this.loadDescriptionIntoRegistry(testRuleUnit.getClass());
        RuleUnitDescription description = this.registry.getDescription((RuleUnit)testRuleUnit);
        Assertions.assertThat((Object)description).isNotNull();
        Assertions.assertThat((Class)description.getRuleUnitClass()).isEqualTo(testRuleUnit.getClass());
    }

    @Test
    public void getDescriptionForUnitClassName() {
        Optional description = this.registry.getDescription(TestRuleUnit.class.getName());
        Assertions.assertThat((Optional)description).isNotPresent();
        this.loadDescriptionIntoRegistry(TestRuleUnit.class);
        description = this.registry.getDescription(TestRuleUnit.class.getName());
        Assertions.assertThat((Optional)description).isPresent();
        Assertions.assertThat((Class)((RuleUnitDescription)description.get()).getRuleUnitClass()).isEqualTo(TestRuleUnit.class);
    }

    @Test
    public void getDescriptionForRuleImpl() {
        RuleImpl ruleImpl = (RuleImpl)Mockito.mock(RuleImpl.class);
        Mockito.when((Object)ruleImpl.getRuleUnitClassName()).thenReturn((Object)TestRuleUnit.class.getName());
        Optional description = this.registry.getDescription(ruleImpl);
        Assertions.assertThat((Optional)description).isNotPresent();
        this.loadDescriptionIntoRegistry(TestRuleUnit.class);
        description = this.registry.getDescription(ruleImpl);
        Assertions.assertThat((Optional)description).isPresent();
        Assertions.assertThat((Class)((RuleUnitDescription)description.get()).getRuleUnitClass()).isEqualTo(TestRuleUnit.class);
    }

    @Test
    public void add() {
        this.loadDescriptionIntoRegistry(TestRuleUnit.class);
        this.assertDescriptionIsLoaded(TestRuleUnit.class);
        Optional description = this.registry.getDescription(TestRuleUnit2.class.getName());
        Assertions.assertThat((Optional)description).isNotPresent();
        this.loadDescriptionIntoRegistry(TestRuleUnit2.class);
        this.assertDescriptionIsLoaded(TestRuleUnit2.class);
        this.assertDescriptionIsLoaded(TestRuleUnit.class);
    }

    @Test
    public void hasUnits() {
        Assertions.assertThat((boolean)this.registry.hasUnits()).isFalse();
        this.loadDescriptionIntoRegistry(TestRuleUnit.class);
        Assertions.assertThat((boolean)this.registry.hasUnits()).isTrue();
    }

    private void loadDescriptionIntoRegistry(Class<? extends RuleUnit> ruleUnitClass) {
        RuleUnitDescriptionLoader loader = new RuleUnitDescriptionLoader(RuleUnitTestUtil.createTypeResolver());
        loader.getDescription(ruleUnitClass.getName());
        Assertions.assertThat((Map)loader.getDescriptions()).hasSize(1);
        this.registry.add(loader);
    }

    private void assertDescriptionIsLoaded(Class<? extends RuleUnit> ruleUnitClass) {
        Optional description = this.registry.getDescription(ruleUnitClass.getName());
        Assertions.assertThat((Optional)description).isPresent();
        Assertions.assertThat((Class)((RuleUnitDescription)description.get()).getRuleUnitClass()).isEqualTo(ruleUnitClass);
    }
}

