/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.ruleunit;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.ruleunit.Guard;
import org.drools.core.ruleunit.TestRuleUnit;
import org.drools.core.test.model.MockActivation;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleUnit;

public class GuardTest {
    private RuleUnit guardedUnit;
    private RuleImpl guardingRule;
    private Guard guard;

    @Before
    public void prepareGuard() {
        this.guardedUnit = new TestRuleUnit(new Integer[0], BigDecimal.TEN);
        this.guardingRule = new RuleImpl();
        this.guard = new Guard(this.guardedUnit, this.guardingRule);
    }

    @Test
    public void testEquals() {
        Assertions.assertThat((Object)this.guard).isEqualTo((Object)new Guard(this.guardedUnit, this.guardingRule));
    }

    @Test
    public void testAddActivation() {
        this.guard.addActivation(new MockActivation());
        Assertions.assertThat((Iterable)this.guard.getActivations()).isNotEmpty();
        Assertions.assertThat((Iterable)this.guard.getActivations()).hasSize(1);
        this.guard.addActivation(new MockActivation());
        this.guard.addActivation(new MockActivation());
        this.guard.addActivation(new MockActivation());
        Assertions.assertThat((Iterable)this.guard.getActivations()).hasSize(4);
    }

    @Test
    public void testRemoveActivation() {
        MockActivation activation = new MockActivation();
        this.guard.addActivation(activation);
        Assertions.assertThat((Iterable)this.guard.getActivations()).isNotEmpty();
        this.guard.removeActivation(activation);
        Assertions.assertThat((Iterable)this.guard.getActivations()).isEmpty();
    }

    @Test
    public void testIsActive() {
        MockActivation activation = new MockActivation();
        this.guard.addActivation(activation);
        Assertions.assertThat((boolean)this.guard.isActive()).isTrue();
        this.guard.removeActivation(activation);
        Assertions.assertThat((boolean)this.guard.isActive()).isFalse();
    }

    @Test
    public void testGetGuardedUnit() {
        Assertions.assertThat((Object)this.guardedUnit).isSameAs((Object)this.guard.getGuardedUnit());
    }
}

