/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.factmodel.BuildUtils;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.AbstractProxyClassBuilderImpl;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitBuilderUtil;
import org.drools.core.factmodel.traits.TraitFactory;
import org.drools.core.factmodel.traits.TraitProxyClassBuilder;
import org.drools.core.factmodel.traits.TraitRegistry;
import org.drools.core.factmodel.traits.TraitTypeMap;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.factmodel.traits.TripleBasedBean;
import org.drools.core.factmodel.traits.TripleBasedTypes;
import org.drools.core.rule.builder.dialect.asm.ClassGenerator;
import org.drools.core.util.Triple;
import org.drools.core.util.TripleFactory;
import org.drools.core.util.TripleStore;
import org.kie.api.definition.type.FactField;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

public class TraitTripleProxyClassBuilderImpl
extends AbstractProxyClassBuilderImpl
implements TraitProxyClassBuilder,
Serializable {
    @Override
    public byte[] buildClass(ClassDefinition core, ClassLoader classLoader) throws IOException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        BitSet mask = this.traitRegistry.getFieldMask(this.getTrait().getName(), core.getDefinedClass().getName());
        String name = TraitFactory.getPropertyWrapperName(this.getTrait(), core);
        String masterName = TraitFactory.getProxyName(this.getTrait(), core);
        Class<?> traitClass = this.getTrait().getDefinedClass();
        String internalWrapper = BuildUtils.getInternalType(name);
        String internalProxy = BuildUtils.getInternalType(masterName);
        String internalCore = Type.getInternalName(core.getDefinedClass());
        String descrCore = Type.getDescriptor(core.getDefinedClass());
        String internalTrait = Type.getInternalName(this.getTrait().getDefinedClass());
        TraitBuilderUtil.MixinInfo mixinInfo = TraitBuilderUtil.findMixinInfo(traitClass);
        ClassWriter cw = ClassGenerator.createClassWriter(classLoader, 33, internalProxy, null, Type.getInternalName((Class)this.proxyBaseClass), new String[]{internalTrait, Type.getInternalName(Externalizable.class)});
        FieldVisitor fv = cw.visitField(26, "__$$trait_Name", Type.getDescriptor(String.class), null, null);
        fv.visitEnd();
        fv = cw.visitField(1, "object", descrCore, null, null);
        fv.visitEnd();
        fv = cw.visitField(2, "store", Type.getDescriptor(TripleStore.class), null, null);
        fv.visitEnd();
        fv = cw.visitField(2, "storeId", Type.getDescriptor(String.class), null, null);
        fv.visitEnd();
        if (mixinInfo != null) {
            for (Class<?> mixinClass : mixinInfo.mixinClasses) {
                fv = cw.visitField(2, TraitBuilderUtil.getMixinName(mixinClass), Type.getDescriptor(mixinClass), null, null);
                fv.visitEnd();
            }
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + descrCore + Type.getDescriptor(TripleStore.class) + Type.getDescriptor(TripleFactory.class) + Type.getDescriptor(BitSet.class) + Type.getDescriptor(BitSet.class) + Type.getDescriptor(Boolean.TYPE) + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, Type.getInternalName(TripleStore.class), "getId", "()" + Type.getDescriptor(String.class), false);
        mv.visitFieldInsn(181, internalProxy, "storeId", Type.getDescriptor(String.class));
        this.buildConstructorCore(mv, internalProxy, internalWrapper, internalCore, descrCore, mixinInfo);
        this.initFields(mv, internalProxy);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setObject", "(" + Type.getDescriptor(Object.class) + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, internalCore);
        mv.visitFieldInsn(181, internalProxy, "object", descrCore);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "writeExternal", "(" + Type.getDescriptor(ObjectOutput.class) + ")V", null, new String[]{Type.getInternalName(IOException.class)});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName((Class)this.proxyBaseClass), "writeExternal", "(" + Type.getDescriptor(ObjectOutput.class) + ")V", false);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, internalProxy, "getObject", "()" + Type.getDescriptor(TraitableBean.class), false);
        mv.visitMethodInsn(185, Type.getInternalName(ObjectOutput.class), "writeObject", "(" + Type.getDescriptor(Object.class) + ")V", true);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "storeId", Type.getDescriptor(String.class));
        mv.visitMethodInsn(185, Type.getInternalName(ObjectOutput.class), "writeObject", "(" + Type.getDescriptor(Object.class) + ")V", true);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "store", Type.getDescriptor(TripleStore.class));
        mv.visitMethodInsn(185, Type.getInternalName(ObjectOutput.class), "writeObject", "(" + Type.getDescriptor(Object.class) + ")V", true);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "readExternal", "(" + Type.getDescriptor(ObjectInput.class) + ")V", null, new String[]{Type.getInternalName(IOException.class), Type.getInternalName(ClassNotFoundException.class)});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName((Class)this.proxyBaseClass), "readExternal", "(" + Type.getDescriptor(ObjectInput.class) + ")V", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(ObjectInput.class), "readObject", "()" + Type.getDescriptor(Object.class), true);
        mv.visitTypeInsn(192, internalCore);
        mv.visitFieldInsn(181, internalProxy, "object", descrCore);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(ObjectInput.class), "readObject", "()" + Type.getDescriptor(Object.class), true);
        mv.visitTypeInsn(192, Type.getInternalName(String.class));
        mv.visitFieldInsn(181, internalProxy, "storeId", Type.getDescriptor(String.class));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(ObjectInput.class), "readObject", "()" + Type.getDescriptor(Object.class), true);
        mv.visitTypeInsn(192, Type.getInternalName(TripleStore.class));
        mv.visitFieldInsn(181, internalProxy, "store", Type.getDescriptor(TripleStore.class));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        this.helpBuildClass(core, cw, internalProxy, descrCore, mask);
        this.buildProxyAccessors(mask, cw, masterName, core, mixinInfo);
        boolean hasKeys = false;
        for (FactField ff : this.getTrait().getFields()) {
            if (!ff.isKey()) continue;
            hasKeys = true;
            break;
        }
        if (!hasKeys) {
            this.buildEqualityMethods((ClassVisitor)cw, masterName, core.getClassName());
        } else {
            this.buildKeyedEqualityMethods((ClassVisitor)cw, this.getTrait(), masterName);
        }
        TraitBuilderUtil.buildMixinMethods(masterName, mixinInfo, cw);
        this.buildCommonMethods(cw, masterName);
        this.buildExtendedMethods(cw, this.getTrait(), core);
        this.buildShadowMethods(cw, this.trait, core);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected void buildShadowMethods(ClassWriter cw, ClassDefinition trait, ClassDefinition core) {
        for (Method m : trait.getDefinedClass().getMethods()) {
            if (TraitFactory.excludeFromShadowing(m, trait)) continue;
            for (Method q : core.getDefinedClass().getMethods()) {
                if (!TraitFactory.isCompatible(m, q)) continue;
                this.buildShadowMethod(cw, trait, core, m);
            }
        }
    }

    protected void buildConstructorCore(MethodVisitor mv, String internalProxy, String internalWrapper, String internalCore, String descrCore, TraitBuilderUtil.MixinInfo mixinInfo) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName((Class)this.proxyBaseClass), "<init>", "()V", false);
        if (mixinInfo != null) {
            for (Class<?> mixinClass : mixinInfo.mixinClasses) {
                try {
                    Class actualArg = this.getPossibleConstructor(mixinClass, this.trait.getDefinedClass());
                    mv.visitVarInsn(25, 0);
                    mv.visitTypeInsn(187, Type.getInternalName(mixinClass));
                    mv.visitInsn(89);
                    mv.visitVarInsn(25, 0);
                    mv.visitMethodInsn(183, Type.getInternalName(mixinClass), "<init>", "(" + Type.getDescriptor((Class)actualArg) + ")V", false);
                    mv.visitFieldInsn(181, internalProxy, TraitBuilderUtil.getMixinName(mixinClass), Type.getDescriptor(mixinClass));
                }
                catch (NoSuchMethodException nsme) {
                    mv.visitVarInsn(25, 0);
                    mv.visitTypeInsn(187, Type.getInternalName(mixinClass));
                    mv.visitInsn(89);
                    mv.visitMethodInsn(183, Type.getInternalName(mixinClass), "<init>", "()V", false);
                    mv.visitFieldInsn(181, internalProxy, TraitBuilderUtil.getMixinName(mixinClass), Type.getDescriptor(mixinClass));
                }
            }
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, internalProxy, "object", descrCore);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, internalProxy, "store", Type.getDescriptor(TripleStore.class));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, internalProxy, "setTripleFactory", "(" + Type.getDescriptor(TripleFactory.class) + ")V", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(182, internalProxy, "setTypeCode", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(BitSet.class)}), false);
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, internalWrapper);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, internalWrapper, "<init>", "(" + descrCore + Type.getDescriptor(TripleStore.class) + Type.getDescriptor(TripleFactory.class) + ")V", false);
        mv.visitFieldInsn(181, internalProxy, "fields", Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, internalCore, "_getDynamicProperties", "()" + Type.getDescriptor(Map.class), false);
        Label l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(187, Type.getInternalName(TripleBasedBean.class));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedBean.class), "<init>", "(" + Type.getDescriptor(Object.class) + Type.getDescriptor(TripleStore.class) + Type.getDescriptor(TripleFactory.class) + ")V", false);
        mv.visitMethodInsn(182, internalCore, "_setDynamicProperties", "(" + Type.getDescriptor(Map.class) + ")V", false);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, internalCore, "_getTraitMap", "()" + Type.getDescriptor(Map.class), false);
        Label l1 = new Label();
        mv.visitJumpInsn(199, l1);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(187, Type.getInternalName(TraitTypeMap.class));
        mv.visitInsn(89);
        mv.visitTypeInsn(187, Type.getInternalName(TripleBasedTypes.class));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedTypes.class), "<init>", "(" + Type.getDescriptor(Object.class) + Type.getDescriptor(TripleStore.class) + Type.getDescriptor(TripleFactory.class) + ")V", false);
        mv.visitMethodInsn(183, Type.getInternalName(TraitTypeMap.class), "<init>", "(" + Type.getDescriptor(Map.class) + ")V", false);
        mv.visitMethodInsn(182, internalCore, "_setTraitMap", "(" + Type.getDescriptor(Map.class) + ")V", false);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 5);
        mv.visitMethodInsn(182, internalCore, "_setBottomTypeCode", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(BitSet.class)}), false);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)(this.trait.getName().endsWith("_Trait__Extension") ? this.trait.getName().replace("_Trait__Extension", "") : this.trait.getName()));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, internalCore, "addTrait", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(Thing.class)}), false);
    }

    protected void initFields(MethodVisitor mv, String internalProxy) {
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 6);
        mv.visitMethodInsn(183, internalProxy, "synchFields", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE}), false);
    }

    protected void buildProxyAccessors(BitSet mask, ClassWriter cw, String masterName, ClassDefinition core, TraitBuilderUtil.MixinInfo mixinInfo) {
        int j = 0;
        for (FieldDefinition field : this.getTrait().getFieldsDefinitions()) {
            boolean isSoftField = TraitRegistry.isSoftField(field, j++, mask);
            this.buildProxyAccessor(cw, masterName, core, mixinInfo, field, isSoftField);
        }
    }

    protected void buildProxyAccessor(ClassWriter cw, String masterName, ClassDefinition core, TraitBuilderUtil.MixinInfo mixinInfo, FieldDefinition field, boolean isSoftField) {
        if (core.isFullTraiting()) {
            this.buildLogicalGetter((ClassVisitor)cw, field, masterName, core);
            if (!isSoftField) {
                this.buildHardSetter((ClassVisitor)cw, field, masterName, this.trait, core);
            } else {
                this.buildSoftSetter(cw, field, masterName, core);
            }
        } else if (isSoftField) {
            if (mixinInfo == null || !mixinInfo.isMixinGetter(field)) {
                this.buildSoftGetter(cw, field, masterName);
                this.buildSoftSetter(cw, field, masterName, core);
            }
        } else {
            this.buildHardGetter((ClassVisitor)cw, field, masterName, this.trait, core);
            this.buildHardSetter((ClassVisitor)cw, field, masterName, this.trait, core);
        }
    }

    protected void buildHardGetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition proxy, ClassDefinition core) {
        this.buildHardGetter(cw, field, masterName, proxy, core, BuildUtils.getterName(field.getName(), field.getTypeName()), 1);
    }

    protected void buildHardGetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition proxy, ClassDefinition core, String getterName, int accessMode) {
        Class<?> fieldType = field.getType();
        MethodVisitor mv = cw.visitMethod(accessMode, getterName, "()" + Type.getDescriptor(fieldType), null, null);
        mv.visitCode();
        TraitFactory.invokeExtractor(mv, masterName, proxy, core, field);
        if (!BuildUtils.isPrimitive(field.getTypeName())) {
            mv.visitTypeInsn(192, Type.getInternalName(fieldType));
        }
        mv.visitInsn(BuildUtils.returnType(fieldType.getName()));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildHardSetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition trait, ClassDefinition core) {
        this.buildHardSetter(cw, field, masterName, trait, core, BuildUtils.setterName(field.getName(), field.getTypeName()), 1);
    }

    private void buildSoftSetter(ClassWriter cw, FieldDefinition field, String masterName, ClassDefinition core) {
        this.buildSoftSetter((ClassVisitor)cw, field, masterName, core, BuildUtils.setterName(field.getName(), field.getTypeName()), 1);
    }

    protected void buildSoftSetter(ClassVisitor cw, FieldDefinition field, String proxy, ClassDefinition core, String setterName, int accessMode) {
        String type = field.getTypeName();
        MethodVisitor mv = cw.visitMethod(accessMode, setterName, "(" + Type.getDescriptor(field.getType()) + ")V", null, null);
        mv.visitCode();
        if (core.isFullTraiting()) {
            this.logicalSetter(mv, field, proxy, core);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxy), "store", Type.getDescriptor(TripleStore.class));
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)field.resolveAlias());
        mv.visitVarInsn(BuildUtils.varType(type), 1);
        if (BuildUtils.isPrimitive(type)) {
            TraitFactory.valueOf(mv, type);
        }
        mv.visitMethodInsn(182, BuildUtils.getInternalType(proxy), "property", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Triple.class), false);
        mv.visitMethodInsn(182, Type.getInternalName(TripleStore.class), "put", "(" + Type.getDescriptor(Triple.class) + ")Z", false);
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildSoftGetter(ClassWriter cw, FieldDefinition field, String masterName) {
        this.buildSoftGetter((ClassVisitor)cw, field, masterName, BuildUtils.getterName(field.getName(), field.getTypeName()), 1);
    }

    protected void buildSoftGetter(ClassVisitor cw, FieldDefinition field, String proxy, String getterName, int accessMode) {
        String type = field.getTypeName();
        MethodVisitor mv = cw.visitMethod(accessMode, getterName, "()" + Type.getDescriptor(field.getType()), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxy), "store", Type.getDescriptor(TripleStore.class));
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)field.resolveAlias());
        mv.visitMethodInsn(182, BuildUtils.getInternalType(proxy), "propertyKey", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(Triple.class), false);
        mv.visitMethodInsn(182, Type.getInternalName(TripleStore.class), "get", "(" + Type.getDescriptor(Triple.class) + ")" + Type.getDescriptor(Triple.class), false);
        String actualType = BuildUtils.isPrimitive(type) ? BuildUtils.box(type) : type;
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(198, l0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(Triple.class), "getValue", "()" + Type.getDescriptor(Object.class), true);
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(193, BuildUtils.getInternalType(actualType));
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, BuildUtils.getInternalType(actualType));
        if (BuildUtils.isPrimitive(type)) {
            TraitFactory.primitiveValue(mv, type);
            mv.visitInsn(BuildUtils.returnType(type));
            mv.visitLabel(l1);
            mv.visitInsn(BuildUtils.zero(type));
            mv.visitInsn(BuildUtils.returnType(type));
            mv.visitLabel(l0);
            mv.visitInsn(BuildUtils.zero(type));
            mv.visitInsn(BuildUtils.returnType(type));
        } else {
            mv.visitInsn(176);
            mv.visitLabel(l1);
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitLabel(l0);
            mv.visitInsn(1);
            mv.visitInsn(176);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @Override
    protected void buildKeyedEquals(ClassVisitor cw, ClassDefinition classDef, String proxyType) {
        MethodVisitor mv = cw.visitMethod(1, "equals", "(" + Type.getDescriptor(Object.class) + ")Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(166, l0);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(198, l1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", "()" + Type.getDescriptor(Class.class), false);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", "()" + Type.getDescriptor(Class.class), false);
        Label l2 = new Label();
        mv.visitJumpInsn(165, l2);
        mv.visitLabel(l1);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, proxyType);
        mv.visitVarInsn(58, 2);
        int x = 2;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            if (!BuildUtils.isPrimitive(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                Label l11 = new Label();
                mv.visitJumpInsn(198, l11);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitMethodInsn(182, BuildUtils.getInternalType(field.getTypeName()), "equals", "(" + Type.getDescriptor(Object.class) + ")Z", false);
                Label l12 = new Label();
                mv.visitJumpInsn(154, l12);
                Label l13 = new Label();
                mv.visitJumpInsn(167, l13);
                mv.visitLabel(l11);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitJumpInsn(198, l12);
                mv.visitLabel(l13);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l12);
                continue;
            }
            if ("double".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "compare", "(DD)I", false);
                Label l5 = new Label();
                mv.visitJumpInsn(153, l5);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l5);
                x = Math.max(x, 4);
                continue;
            }
            if ("float".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitMethodInsn(184, Type.getInternalName(Float.class), "compare", "(FF)I", false);
                Label l6 = new Label();
                mv.visitJumpInsn(153, l6);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l6);
                continue;
            }
            if ("long".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitInsn(148);
                Label l8 = new Label();
                mv.visitJumpInsn(153, l8);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l8);
                x = Math.max(x, 4);
                continue;
            }
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
            Label l4 = new Label();
            mv.visitJumpInsn(159, l4);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(l4);
        }
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @Override
    protected void buildKeyedHashCode(ClassVisitor cw, ClassDefinition classDef, String proxyType) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitIntInsn(16, 31);
        mv.visitVarInsn(54, 1);
        int x = 2;
        int y = 2;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            if (!BuildUtils.isPrimitive(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                Label l8 = new Label();
                mv.visitJumpInsn(198, l8);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitMethodInsn(182, BuildUtils.getInternalType(field.getTypeName()), "hashCode", "()I", false);
                Label l9 = new Label();
                mv.visitJumpInsn(167, l9);
                mv.visitLabel(l8);
                mv.visitInsn(3);
                mv.visitLabel(l9);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                continue;
            }
            if ("double".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitInsn(14);
                mv.visitInsn(151);
                Label l2 = new Label();
                mv.visitJumpInsn(153, l2);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "doubleToLongBits", "(D)J", false);
                Label l3 = new Label();
                mv.visitJumpInsn(167, l3);
                mv.visitLabel(l2);
                mv.visitInsn(9);
                mv.visitLabel(l3);
                mv.visitVarInsn(55, 2);
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(22, 2);
                mv.visitVarInsn(22, 2);
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                x = Math.max(6, x);
                y = Math.max(4, y);
                continue;
            }
            if ("boolean".equals(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                Label l4 = new Label();
                mv.visitJumpInsn(153, l4);
                mv.visitInsn(4);
                Label l5 = new Label();
                mv.visitJumpInsn(167, l5);
                mv.visitLabel(l4);
                mv.visitInsn(3);
                mv.visitLabel(l5);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                continue;
            }
            if ("float".equals(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitInsn(11);
                mv.visitInsn(149);
                Label l6 = new Label();
                mv.visitJumpInsn(153, l6);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitMethodInsn(184, Type.getInternalName(Float.class), "floatToIntBits", "(F)I", false);
                Label l7 = new Label();
                mv.visitJumpInsn(167, l7);
                mv.visitLabel(l6);
                mv.visitInsn(3);
                mv.visitLabel(l7);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                x = Math.max(3, x);
                continue;
            }
            if ("long".equals(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                x = Math.max(6, x);
                continue;
            }
            mv.visitIntInsn(16, 31);
            mv.visitVarInsn(21, 1);
            mv.visitInsn(104);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()), false);
            mv.visitInsn(96);
            mv.visitVarInsn(54, 1);
        }
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildCommonMethods(ClassWriter cw, String proxy) {
        MethodVisitor mv = cw.visitMethod(1, "toString", "()" + Type.getDescriptor(String.class), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", "()V", false);
        mv.visitLdcInsn((Object)("(@" + proxy + ") : "));
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(StringBuilder.class), false);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(proxy), "getFields", "()" + Type.getDescriptor(Map.class), false);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "entrySet", "()" + Type.getDescriptor(Set.class), true);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "toString", "()" + Type.getDescriptor(String.class), false);
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(StringBuilder.class), false);
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "toString", "()" + Type.getDescriptor(String.class), false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildExtendedMethods(ClassWriter cw, ClassDefinition trait, ClassDefinition core) {
        this.buildSynchFields(cw, TraitFactory.getProxyName(trait, core), trait, core);
    }
}

