/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import org.drools.core.ClassObjectFilter;
import org.drools.core.ClassObjectSerializationFilter;
import org.drools.core.base.RuleNameEndsWithAgendaFilter;
import org.drools.core.base.RuleNameEqualsAgendaFilter;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.base.RuleNameStartsWithAgendaFilter;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.GetGlobalCommand;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.core.command.runtime.rule.ClearActivationGroupCommand;
import org.drools.core.command.runtime.rule.ClearAgendaCommand;
import org.drools.core.command.runtime.rule.ClearAgendaGroupCommand;
import org.drools.core.command.runtime.rule.ClearRuleFlowGroupCommand;
import org.drools.core.command.runtime.rule.DeleteCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.FireUntilHaltCommand;
import org.drools.core.command.runtime.rule.GetObjectCommand;
import org.drools.core.command.runtime.rule.GetObjectsCommand;
import org.drools.core.command.runtime.rule.InsertElementsCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.ModifyCommand;
import org.drools.core.command.runtime.rule.QueryCommand;
import org.drools.core.command.runtime.rule.UpdateCommand;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.DisconnectedFactHandle;
import org.drools.core.xml.jaxb.util.JaxbListWrapper;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.command.Setter;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.FactHandle;

public class CommandSerializationTest {
    private Class<?>[] annotatedJaxbClasses = new Class[]{JaxbListWrapper.class};
    private static final Random random = new Random();

    private void verifyDisconnectedFactHandle(DisconnectedFactHandle orig, DisconnectedFactHandle copy) {
        Assert.assertNotNull((String)"copy disconnected fact handle is null", (Object)copy);
        Assert.assertEquals((String)"id", (long)orig.getId(), (long)copy.getId());
        Assert.assertEquals((String)"identity hash code", (long)orig.getIdentityHashCode(), (long)copy.getIdentityHashCode());
        Assert.assertEquals((String)"object hash code", (long)orig.getObjectHashCode(), (long)copy.getObjectHashCode());
        Assert.assertEquals((String)"recency", (long)orig.getRecency(), (long)copy.getRecency());
        Assert.assertEquals((String)"entry point id", (Object)orig.getEntryPointId(), (Object)copy.getEntryPointId());
        Assert.assertEquals((String)"trait type", (Object)orig.getTraitType(), (Object)copy.getTraitType());
    }

    private <T> T roundTrip(Object obj) throws Exception {
        Class[] classes = new Class[]{obj.getClass()};
        JAXBContext ctx = this.getJaxbContext(classes);
        String xmlOut = this.marshall(ctx, obj);
        return this.unmarshall(ctx, xmlOut);
    }

    private <T> T unmarshall(JAXBContext ctx, String xmlIn) throws Exception {
        ByteArrayInputStream xmlStrInputStream = new ByteArrayInputStream(xmlIn.getBytes(Charset.forName("UTF-8")));
        Object out = ctx.createUnmarshaller().unmarshal((InputStream)xmlStrInputStream);
        return (T)out;
    }

    private String marshall(JAXBContext ctx, Object obj) throws Exception {
        StringWriter writer = new StringWriter();
        ctx.createMarshaller().marshal(obj, (Writer)writer);
        return writer.getBuffer().toString();
    }

    private JAXBContext getJaxbContext(Class<?> ... classes) throws Exception {
        ArrayList jaxbClassList = new ArrayList();
        jaxbClassList.addAll(Arrays.asList(classes));
        jaxbClassList.addAll(Arrays.asList(this.annotatedJaxbClasses));
        Class[] jaxbClasses = jaxbClassList.toArray(new Class[jaxbClassList.size()]);
        return JAXBContext.newInstance((Class[])jaxbClasses);
    }

    @Test
    public void updateCommandTest() throws Exception {
        DisconnectedFactHandle discFactHandle = new DisconnectedFactHandle(2L, 3, 4, 5L, "entry-point-id", (Object)"str-obj", true);
        DisconnectedFactHandle copyDiscFactHandle = (DisconnectedFactHandle)this.roundTrip(discFactHandle);
        this.verifyDisconnectedFactHandle(discFactHandle, copyDiscFactHandle);
        UpdateCommand cmd = new UpdateCommand((FactHandle)discFactHandle, (Object)"new-str-object");
        UpdateCommand copyCmd = (UpdateCommand)this.roundTrip(cmd);
        this.verifyDisconnectedFactHandle(discFactHandle, copyCmd.getHandle());
        Assert.assertEquals((String)"entry point", (Object)cmd.getEntryPoint(), (Object)copyCmd.getEntryPoint());
        Assert.assertEquals((String)"object", (Object)cmd.getObject(), (Object)copyCmd.getObject());
    }

    @Test
    public void insertObjectCommandTest() throws Exception {
        InsertObjectCommand cmd = new InsertObjectCommand((Object)"obj", "out-id");
        cmd.setReturnObject(false);
        cmd.setEntryPoint("entry-point");
        InsertObjectCommand copyCmd = (InsertObjectCommand)this.roundTrip(cmd);
        Assert.assertEquals((String)"object", (Object)cmd.getObject(), (Object)copyCmd.getObject());
        Assert.assertEquals((String)"out id", (Object)cmd.getOutIdentifier(), (Object)copyCmd.getOutIdentifier());
        Assert.assertEquals((String)"return obj", (Object)cmd.isReturnObject(), (Object)copyCmd.isReturnObject());
        Assert.assertEquals((String)"entry point", (Object)cmd.getEntryPoint(), (Object)copyCmd.getEntryPoint());
        Assert.assertEquals((String)"disconnected", (Object)cmd.isDisconnected(), (Object)copyCmd.isDisconnected());
    }

    @Test
    public void insertObjectCommandListTest() throws Exception {
        ArrayList<String> objectList = new ArrayList<String>();
        objectList.add("obj");
        InsertObjectCommand cmd = new InsertObjectCommand(objectList, "out-id");
        InsertObjectCommand copyCmd = (InsertObjectCommand)this.roundTrip(cmd);
        Assert.assertNotNull((Object)copyCmd);
        Assert.assertThat((Object)copyCmd.getObject(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        Assert.assertEquals((String)"object", (Object)cmd.getObject(), (Object)copyCmd.getObject());
    }

    @Test
    public void insertObjectCommandEmptyListTest() throws Exception {
        ArrayList<String> objectList = new ArrayList<String>();
        objectList.add("one-element");
        InsertObjectCommand cmd = new InsertObjectCommand(objectList, "out-id");
        InsertObjectCommand copyCmd = (InsertObjectCommand)this.roundTrip(cmd);
        Assert.assertNotNull((Object)copyCmd);
        Assert.assertThat((Object)copyCmd.getObject(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        Assert.assertEquals((String)"object", (Object)cmd.getObject(), (Object)copyCmd.getObject());
        objectList.clear();
        copyCmd = (InsertObjectCommand)this.roundTrip(cmd);
        Assert.assertNotNull((Object)copyCmd);
        Assert.assertThat((Object)copyCmd.getObject(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        Assert.assertEquals((String)"object", (Object)cmd.getObject(), (Object)copyCmd.getObject());
    }

    private static String randomString() {
        return UUID.randomUUID().toString();
    }

    @Test
    public void batchExecutionImplSerializationTest() throws Exception {
        FireAllRulesCommand cmd;
        DefaultFactHandle factHandle = new DefaultFactHandle(13L, "entry-point-id", 42, 84, 400L, (Object)"fact");
        BatchExecutionCommandImpl batchCmd = new BatchExecutionCommandImpl();
        batchCmd.setLookup("lookup");
        AbortWorkItemCommand cmd2 = new AbortWorkItemCommand(23L);
        batchCmd.addCommand((Command)cmd2);
        String externalForm = factHandle.toExternalForm();
        Assert.assertEquals((String)"FactHandle string", (Object)externalForm, (Object)DisconnectedFactHandle.newFrom((FactHandle)factHandle).toExternalForm());
        Object cmd3 = new DeleteCommand((FactHandle)factHandle);
        batchCmd.addCommand((Command)cmd3);
        cmd2 = new GetGlobalCommand("global-id");
        cmd2.setOutIdentifier("out-id");
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new SetGlobalCommand("global-id", (Object)new Integer(23));
        cmd2.setOutIdentifier("out-id");
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new InsertElementsCommand();
        cmd2.setEntryPoint("entry-point");
        cmd2.setOutIdentifier("out-id");
        cmd2.setReturnObject(true);
        HashMap<String, String> mapObj = new HashMap<String, String>();
        mapObj.put("key", "value");
        ArrayList<HashMap<String, String>> objects = new ArrayList<HashMap<String, String>>(1);
        objects.add(mapObj);
        cmd2.setObjects(objects);
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new QueryCommand();
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add("this");
        args.add(42);
        args.add("other");
        cmd2.setArguments(args);
        cmd2.setName("query-name");
        cmd2.setOutIdentifier("out-id");
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new InsertObjectCommand();
        cmd2.setEntryPoint("entry-point");
        cmd2.setOutIdentifier("out-id");
        cmd2.setReturnObject(true);
        cmd2.setObject((Object)"object");
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new ModifyCommand();
        cmd2.setFactHandle(DisconnectedFactHandle.newFrom((FactHandle)factHandle));
        AgendaFilter[] setters = new ArrayList(2);
        Object setter = new Setter(){

            public String getValue() {
                return "blue";
            }

            public String getAccessor() {
                return "heart";
            }
        };
        setters.add(setter);
        setter = new Setter(){

            public String getValue() {
                return "hot";
            }

            public String getAccessor() {
                return "fingers";
            }
        };
        setters.add(setter);
        cmd2.setSetters(setters);
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new GetObjectCommand((FactHandle)factHandle, "out-id");
        batchCmd.addCommand((Command)cmd2);
        AgendaFilter[] filters = new AgendaFilter[]{new RuleNameEndsWithAgendaFilter("suffix", false), new RuleNameEqualsAgendaFilter("name", true), new RuleNameMatchesAgendaFilter("regexp", false), new RuleNameStartsWithAgendaFilter("prefix", false)};
        for (AgendaFilter filter : filters) {
            cmd = new FireAllRulesCommand(CommandSerializationTest.randomString(), random.nextInt(1000), filter);
            batchCmd.addCommand((Command)cmd);
        }
        filters = new AgendaFilter[]{new RuleNameEndsWithAgendaFilter("suffix", false), new RuleNameEqualsAgendaFilter("name", true), new RuleNameMatchesAgendaFilter("regexp", false), new RuleNameStartsWithAgendaFilter("prefix", false)};
        for (AgendaFilter filter : filters) {
            cmd = new FireUntilHaltCommand(filter);
            batchCmd.addCommand((Command)cmd);
        }
        HashMap results = new HashMap(1);
        ArrayList<String> resultValList = new ArrayList<String>(2);
        resultValList.add("yellow");
        resultValList.add("chances");
        results.put("list", resultValList);
        CompleteWorkItemCommand cmd4 = new CompleteWorkItemCommand((long)random.nextInt(1000), results);
        batchCmd.addCommand((Command)cmd4);
        ClassObjectFilter filter = new ClassObjectFilter(String.class);
        cmd3 = new GetObjectsCommand((ObjectFilter)filter, "out-id");
        batchCmd.addCommand((Command)cmd3);
        cmd2 = new AgendaGroupSetFocusCommand(CommandSerializationTest.randomString());
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new ClearActivationGroupCommand(CommandSerializationTest.randomString());
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new ClearAgendaCommand();
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new ClearAgendaGroupCommand(CommandSerializationTest.randomString());
        batchCmd.addCommand((Command)cmd2);
        cmd2 = new ClearRuleFlowGroupCommand(CommandSerializationTest.randomString());
        batchCmd.addCommand((Command)cmd2);
        BatchExecutionCommandImpl batchCmdCopy = (BatchExecutionCommandImpl)this.roundTrip(batchCmd);
        Assert.assertEquals((String)"Batch cmd lookup", (Object)batchCmd.getLookup(), (Object)batchCmdCopy.getLookup());
        Assert.assertEquals((String)"Batch cmd num commands", (long)batchCmd.getCommands().size(), (long)batchCmdCopy.getCommands().size());
        for (Command copyCmd : batchCmdCopy.getCommands()) {
            for (Command origCmd : batchCmd.getCommands()) {
                Object afFieldCopyVal;
                Iterator afFieldOrigVal;
                AgendaFilter origFilter;
                Class<?> cmdClass = origCmd.getClass();
                if (!copyCmd.getClass().equals(cmdClass)) continue;
                if (cmdClass.equals(DeleteCommand.class)) {
                    CommandSerializationTest.compareFactHandles(((DeleteCommand)origCmd).getFactHandle(), ((DeleteCommand)copyCmd).getFactHandle(), DeleteCommand.class);
                    continue;
                }
                if (cmdClass.equals(FireAllRulesCommand.class)) {
                    origFilter = ((FireAllRulesCommand)origCmd).getAgendaFilter();
                    AgendaFilter copyFilter = ((FireAllRulesCommand)copyCmd).getAgendaFilter();
                    if (!origFilter.getClass().equals(copyFilter.getClass())) continue;
                    Class<?> agendaFilterClass = origFilter.getClass();
                    for (Field agendaFilterField : agendaFilterClass.getDeclaredFields()) {
                        agendaFilterField.setAccessible(true);
                        afFieldOrigVal = agendaFilterField.get(origFilter);
                        afFieldCopyVal = agendaFilterField.get(copyFilter);
                        if (afFieldOrigVal instanceof Pattern) {
                            afFieldOrigVal = ((Pattern)((Object)afFieldOrigVal)).pattern();
                            afFieldCopyVal = ((Pattern)afFieldCopyVal).pattern();
                        }
                        Assert.assertEquals((String)(agendaFilterClass.getSimpleName() + "." + agendaFilterField.getName()), (Object)afFieldOrigVal, (Object)afFieldCopyVal);
                    }
                    Assert.assertEquals((String)(FireAllRulesCommand.class.getSimpleName() + ".max"), (long)((FireAllRulesCommand)origCmd).getMax(), (long)((FireAllRulesCommand)copyCmd).getMax());
                    Assert.assertEquals((String)(FireAllRulesCommand.class.getSimpleName() + ".outIdentifier"), (Object)((FireAllRulesCommand)origCmd).getOutIdentifier(), (Object)((FireAllRulesCommand)copyCmd).getOutIdentifier());
                    continue;
                }
                if (cmdClass.equals(FireUntilHaltCommand.class)) {
                    origFilter = ((FireUntilHaltCommand)origCmd).getAgendaFilter();
                    AgendaFilter copyFilter = ((FireUntilHaltCommand)copyCmd).getAgendaFilter();
                    if (!origFilter.getClass().equals(copyFilter.getClass())) continue;
                    Class<?> agendaFilterClass = origFilter.getClass();
                    for (Field agendaFilterField : agendaFilterClass.getDeclaredFields()) {
                        agendaFilterField.setAccessible(true);
                        afFieldOrigVal = agendaFilterField.get(origFilter);
                        afFieldCopyVal = agendaFilterField.get(copyFilter);
                        if (afFieldOrigVal instanceof Pattern) {
                            afFieldOrigVal = ((Pattern)((Object)afFieldOrigVal)).pattern();
                            afFieldCopyVal = ((Pattern)afFieldCopyVal).pattern();
                        }
                        Assert.assertEquals((String)(agendaFilterClass.getSimpleName() + "." + agendaFilterField.getName()), (Object)afFieldOrigVal, (Object)afFieldCopyVal);
                    }
                    continue;
                }
                for (Field cmdField : cmdClass.getDeclaredFields()) {
                    cmdField.setAccessible(true);
                    if (Modifier.isTransient(cmdField.getModifiers())) continue;
                    Object origVal = cmdField.get(origCmd);
                    Assert.assertNotNull((String)(cmdClass.getSimpleName() + "." + cmdField.getName()), (Object)origVal);
                    Object copyVal = cmdField.get(copyCmd);
                    Assert.assertNotNull((String)("Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName()), (Object)copyVal);
                    if (origVal instanceof FactHandle) {
                        CommandSerializationTest.compareFactHandles((FactHandle)origVal, (FactHandle)copyVal, cmdClass);
                        continue;
                    }
                    if (origVal instanceof ClassObjectSerializationFilter) {
                        Assert.assertEquals((String)("Original compared to Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName()), ((ClassObjectSerializationFilter)origVal).getClass(), ((ClassObjectSerializationFilter)copyVal).getClass());
                        continue;
                    }
                    if (origVal instanceof List) {
                        List origList = (List)origVal;
                        if (((List)copyVal).isEmpty()) {
                            Assert.assertTrue((String)("Original compared to Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName()), (boolean)origList.isEmpty());
                            continue;
                        }
                        if (origList.get(0) instanceof Setter) {
                            for (Object obj : (List)origVal) {
                                Assert.assertTrue((String)("Expected a " + Setter.class.getSimpleName() + " instance (not " + obj.getClass().getSimpleName() + " in " + cmdClass.getSimpleName() + "." + cmdField.getName()), (boolean)(obj instanceof Setter));
                                Iterator iter = ((List)copyVal).iterator();
                                while (iter.hasNext()) {
                                    Setter copySetter = (Setter)iter.next();
                                    if (!((Setter)obj).getAccessor().equals(copySetter.getAccessor())) continue;
                                    Assert.assertEquals((String)("Original compared to Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName()), (Object)((Setter)obj).getValue(), (Object)copySetter.getValue());
                                    iter.remove();
                                }
                            }
                            Assert.assertTrue((String)("Original compared to Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName()), (boolean)((List)copyVal).isEmpty());
                            continue;
                        }
                        if (!(origList.get(0) instanceof Map)) continue;
                        Map copyMap = (Map)((List)copyVal).get(0);
                        for (Map.Entry entry : ((Map)origList.get(0)).entrySet()) {
                            Assert.assertTrue((String)("Original compared to Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName()), (boolean)copyMap.containsKey(entry.getKey()));
                        }
                        continue;
                    }
                    Assert.assertTrue((String)("Original compared to Round-tripped " + cmdClass.getSimpleName() + "." + cmdField.getName()), (boolean)origVal.equals(copyVal));
                }
            }
        }
        Field commandsField = BatchExecutionCommandImpl.class.getDeclaredField("commands");
        XmlElements xmlElemsAnno = commandsField.getAnnotation(XmlElements.class);
        ArrayList<Class> cmdTypes = new ArrayList<Class>(xmlElemsAnno.value().length);
        for (XmlElement xmlElem : xmlElemsAnno.value()) {
            cmdTypes.add(xmlElem.type());
        }
        cmdTypes.remove(SignalEventCommand.class);
        cmdTypes.remove(StartProcessCommand.class);
        for (Command cmd5 : batchCmd.getCommands()) {
            cmdTypes.remove(cmd5.getClass());
        }
    }

    private static void compareFactHandles(FactHandle orig, FactHandle copy, Class cmdClass) {
        String origFHString = orig.toExternalForm();
        origFHString = origFHString.substring(0, origFHString.lastIndexOf(":"));
        String copyFHString = copy.toExternalForm();
        copyFHString = copyFHString.substring(0, copyFHString.lastIndexOf(":"));
        Assert.assertEquals((String)(cmdClass.getSimpleName() + ".facthandle string"), (Object)origFHString, (Object)copyFHString);
    }
}

