/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event;

import java.io.Serializable;
import java.util.ArrayList;
import org.drools.core.event.RuleRuntimeEventSupport;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.test.model.Cheese;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class RuleRuntimeEventSupportTest {
    @Test
    public void testIsSerializable() {
        Assert.assertTrue((boolean)Serializable.class.isAssignableFrom(RuleRuntimeEventSupport.class));
    }

    @Test
    public void testRuleRuntimeEventListener() {
        InternalKnowledgeBase rb = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession wm = rb.newKieSession();
        final ArrayList wmList = new ArrayList();
        RuleRuntimeEventListener workingMemoryListener = new RuleRuntimeEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                wmList.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                wmList.add(event);
            }

            public void objectDeleted(ObjectDeletedEvent event) {
                wmList.add(event);
            }
        };
        wm.addEventListener(workingMemoryListener);
        Assert.assertEquals((long)1L, (long)wm.getRuleRuntimeEventListeners().size());
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 17);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        ObjectInsertedEvent oae = (ObjectInsertedEvent)wmList.get(0);
        Assert.assertSame((Object)stiltonHandle, (Object)oae.getFactHandle());
        wm.update(stiltonHandle, (Object)cheddar);
        ObjectUpdatedEvent ome = (ObjectUpdatedEvent)wmList.get(1);
        Assert.assertSame((Object)stiltonHandle, (Object)ome.getFactHandle());
        Assert.assertEquals((Object)cheddar, (Object)ome.getObject());
        Assert.assertEquals((Object)stilton, (Object)ome.getOldObject());
        wm.retract(stiltonHandle);
        ObjectDeletedEvent ore = (ObjectDeletedEvent)wmList.get(2);
        Assert.assertSame((Object)stiltonHandle, (Object)ore.getFactHandle());
        FactHandle cheddarHandle = wm.insert((Object)cheddar);
        oae = (ObjectInsertedEvent)wmList.get(3);
        Assert.assertSame((Object)cheddarHandle, (Object)oae.getFactHandle());
    }
}

