/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.lang.reflect.Field;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.EmptyObjectSinkAdapter;
import org.drools.core.reteoo.MockObjectSink;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.SingleObjectSinkAdapter;
import org.drools.core.test.model.DroolsTestCase;
import org.junit.Assert;
import org.junit.Test;

public class ObjectSourceTest
extends DroolsTestCase {
    @Test
    public void testObjectSourceConstructor() {
        MockObjectSource source = new MockObjectSource(15);
        Assert.assertEquals((long)15L, (long)source.getId());
        Assert.assertEquals((long)0L, (long)source.getAttached());
        source.attach();
        Assert.assertEquals((long)1L, (long)source.getAttached());
    }

    @Test
    public void testAddObjectSink() throws Exception {
        MockObjectSource source = new MockObjectSource(15);
        Field field = ObjectSource.class.getDeclaredField("sink");
        field.setAccessible(true);
        ObjectSinkPropagator sink = (ObjectSinkPropagator)field.get((Object)source);
        Assert.assertSame((Object)EmptyObjectSinkAdapter.getInstance(), (Object)sink);
        MockObjectSink sink1 = new MockObjectSink();
        source.addObjectSink((ObjectSink)sink1);
        sink = (ObjectSinkPropagator)field.get((Object)source);
        Assert.assertSame(SingleObjectSinkAdapter.class, sink.getClass());
        Assert.assertEquals((long)1L, (long)sink.getSinks().length);
        MockObjectSink sink2 = new MockObjectSink();
        source.addObjectSink((ObjectSink)sink2);
        sink = (ObjectSinkPropagator)field.get((Object)source);
        Assert.assertSame(CompositeObjectSinkAdapter.class, sink.getClass());
        Assert.assertEquals((long)2L, (long)sink.getSinks().length);
        MockObjectSink sink3 = new MockObjectSink();
        source.addObjectSink((ObjectSink)sink3);
        Assert.assertSame(CompositeObjectSinkAdapter.class, sink.getClass());
        Assert.assertEquals((long)3L, (long)sink.getSinks().length);
        source.removeObjectSink((ObjectSink)sink2);
        Assert.assertSame(CompositeObjectSinkAdapter.class, sink.getClass());
        Assert.assertEquals((long)2L, (long)sink.getSinks().length);
        source.removeObjectSink((ObjectSink)sink1);
        sink = (ObjectSinkPropagator)field.get((Object)source);
        Assert.assertSame(SingleObjectSinkAdapter.class, sink.getClass());
        Assert.assertEquals((long)1L, (long)sink.getSinks().length);
        source.removeObjectSink((ObjectSink)sink3);
        sink = (ObjectSinkPropagator)field.get((Object)source);
        Assert.assertSame((Object)EmptyObjectSinkAdapter.getInstance(), (Object)sink);
        Assert.assertEquals((long)0L, (long)sink.getSinks().length);
    }
}

