/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.asm;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import org.drools.core.util.asm.BeanInherit;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.core.util.asm.InterfaceChild;
import org.drools.core.util.asm.InterfaceChildImpl;
import org.drools.core.util.asm.TestAbstract;
import org.drools.core.util.asm.TestInterface;
import org.junit.Assert;
import org.junit.Test;

public class ClassFieldInspectorTest {
    @Test
    public void testIt() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(Person.class);
        Assert.assertEquals((long)7L, (long)ext.getFieldNames().size());
        Assert.assertEquals((Object)"getAge", (Object)((Method)ext.getGetterMethods().get("age")).getName());
        Assert.assertEquals((Object)"isHappy", (Object)((Method)ext.getGetterMethods().get("happy")).getName());
        Assert.assertEquals((Object)"getName", (Object)((Method)ext.getGetterMethods().get("name")).getName());
        Map names = ext.getFieldNames();
        Assert.assertNotNull((Object)names);
        Assert.assertEquals((long)7L, (long)names.size());
        Assert.assertNull(names.get("nAme"));
    }

    @Test
    public void testInterface() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(TestInterface.class);
        Assert.assertEquals((long)2L, (long)ext.getFieldNames().size());
        Assert.assertEquals((Object)"getSomething", (Object)((Method)ext.getGetterMethods().get("something")).getName());
        Assert.assertEquals((Object)"getAnother", (Object)((Method)ext.getGetterMethods().get("another")).getName());
        Map names = ext.getFieldNames();
        Assert.assertNotNull((Object)names);
        Assert.assertEquals((long)2L, (long)names.size());
    }

    @Test
    public void testAbstract() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(TestAbstract.class);
        Assert.assertEquals((long)5L, (long)ext.getFieldNames().size());
        Assert.assertEquals((Object)"getSomething", (Object)((Method)ext.getGetterMethods().get("something")).getName());
        Assert.assertEquals((Object)"getAnother", (Object)((Method)ext.getGetterMethods().get("another")).getName());
        Map names = ext.getFieldNames();
        Assert.assertNotNull((Object)names);
        Assert.assertEquals((long)5L, (long)names.size());
    }

    @Test
    public void testInheritedFields() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(BeanInherit.class);
        Assert.assertEquals((long)5L, (long)ext.getFieldNames().size());
        Assert.assertNotNull(ext.getFieldTypesField().get("text"));
        Assert.assertNotNull(ext.getFieldTypesField().get("number"));
        ext = new ClassFieldInspector(InterfaceChildImpl.class);
        Assert.assertEquals((long)8L, (long)ext.getFieldNames().size());
        Assert.assertNotNull(ext.getFieldNames().get("HTML"));
        Assert.assertNotNull(ext.getFieldTypesField().get("HTML"));
        Assert.assertNotNull(ext.getFieldNames().get("baz"));
        Assert.assertNotNull(ext.getFieldTypesField().get("baz"));
        Assert.assertNotNull(ext.getFieldNames().get("URI"));
        Assert.assertNotNull(ext.getFieldTypesField().get("URI"));
    }

    @Test
    public void testIntefaceInheritance() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(InterfaceChild.class);
        Map fields = ext.getFieldNames();
        Assert.assertTrue((boolean)fields.containsKey("foo"));
        Assert.assertTrue((boolean)fields.containsKey("bar"));
        Assert.assertTrue((boolean)fields.containsKey("baz"));
        Assert.assertTrue((boolean)fields.containsKey("URI"));
    }

    @Test
    public void testFieldIndexCalculation() {
        try {
            ClassFieldInspector ext = new ClassFieldInspector(SubPerson.class);
            Map map = ext.getFieldNames();
            String[] fields = new String[map.size()];
            for (Map.Entry entry : map.entrySet()) {
                String fieldName = (String)entry.getKey();
                int fieldIndex = (Integer)entry.getValue();
                if (fields[fieldIndex] == null) {
                    fields[fieldIndex] = fieldName;
                    continue;
                }
                Assert.fail((String)("Duplicate index found for 2 fields: index[" + fieldIndex + "] = [" + fields[fieldIndex] + "] and [" + fieldName + "]"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception thrown");
        }
    }

    @Test
    public void testGetReturnTypes() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(Person.class);
        Map types = ext.getFieldTypes();
        Assert.assertNotNull((Object)types);
        Assert.assertEquals(Boolean.TYPE, types.get("happy"));
        Assert.assertEquals(Integer.TYPE, types.get("age"));
        Assert.assertEquals(String.class, types.get("name"));
    }

    @Test
    public void testGetMethodForField() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(Person.class);
        Map methods = ext.getGetterMethods();
        Assert.assertNotNull((Object)methods);
        Assert.assertEquals((Object)"isHappy", (Object)((Method)methods.get("happy")).getName());
        Assert.assertEquals((Object)"getName", (Object)((Method)methods.get("name")).getName());
        Assert.assertNull(methods.get("nAme"));
        Assert.assertEquals((Object)"getAge", (Object)((Method)methods.get("age")).getName());
    }

    @Test
    public void testNonGetter() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(NonGetter.class);
        Map methods = ext.getGetterMethods();
        Assert.assertEquals((Object)"getFoo", (Object)((Method)methods.get("foo")).getName());
        Assert.assertEquals((long)5L, (long)methods.size());
        Assert.assertTrue((boolean)ext.getFieldNames().containsKey("foo"));
        Assert.assertTrue((boolean)ext.getFieldNames().containsKey("baz"));
        Assert.assertEquals(String.class, ext.getFieldTypes().get("foo"));
    }

    @Test
    public void testWierdCapsForField() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(Person.class);
        Map methods = ext.getGetterMethods();
        Assert.assertEquals((Object)"getURI", (Object)((Method)methods.get("URI")).getName());
        Assert.assertEquals((long)7L, (long)methods.size());
    }

    @Test
    public void testOverridingMethodWithCovariantReturnType() throws Exception {
        ClassFieldInspector ext = new ClassFieldInspector(SuperCar.class);
        Class engine = (Class)ext.getFieldTypes().get("engine");
        Assert.assertEquals(SuperEngine.class, (Object)engine);
    }

    static class SuperEngine
    extends NormalEngine {
        SuperEngine() {
        }
    }

    static class NormalEngine {
        NormalEngine() {
        }
    }

    static class SuperCar
    extends Car {
        SuperCar() {
        }

        @Override
        public SuperEngine getEngine() {
            return new SuperEngine();
        }
    }

    static class Car
    extends Vehicle<NormalEngine> {
        Car() {
        }

        @Override
        public NormalEngine getEngine() {
            return new NormalEngine();
        }
    }

    static class Vehicle<T> {
        private T engine;

        Vehicle() {
        }

        public T getEngine() {
            return this.engine;
        }
    }

    static class SubPerson {
        private int childField;

        SubPerson() {
        }

        public int getChildField() {
            return this.childField;
        }

        public void setChildField(int childField) {
            this.childField = childField;
        }
    }

    static class Person {
        public static String aStaticString = "A static String";
        private boolean happy;
        private String name;
        private int age;
        private String URI;

        Person() {
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public boolean isHappy() {
            return this.happy;
        }

        public void setHappy(boolean happy) {
            this.happy = happy;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void getNotAGetter() {
        }

        private boolean isBogus() {
            return false;
        }

        public String getAlsoBad(String s) {
            return "ignored";
        }

        public String getURI() {
            return this.URI;
        }

        public void setURI(String URI2) {
            this.URI = URI2;
        }
    }

    static class NonGetter {
        NonGetter() {
        }

        public int foo() {
            return 42;
        }

        public String getFoo() {
            return "foo";
        }

        public String baz() {
            return "";
        }

        public void bas() {
        }
    }
}

