/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Iterator;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.phreak.ExecutableEntry;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.PropagationList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedPropagationList
implements PropagationList {
    protected static final transient Logger log = LoggerFactory.getLogger(SynchronizedPropagationList.class);
    protected final InternalWorkingMemory workingMemory;
    protected volatile PropagationEntry head;
    protected volatile PropagationEntry tail;
    private volatile boolean disposed = false;
    private volatile boolean hasEntriesDeferringExpiration = false;

    public SynchronizedPropagationList(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public void addEntry(final PropagationEntry entry) {
        if (entry.requiresImmediateFlushing()) {
            if (entry.isCalledFromRHS()) {
                entry.execute(this.workingMemory);
            } else {
                this.workingMemory.getAgenda().executeTask(new ExecutableEntry(){

                    @Override
                    public void execute() {
                        if (entry instanceof PhreakTimerNode.TimerAction) {
                            ((PhreakTimerNode.TimerAction)entry).execute(SynchronizedPropagationList.this.workingMemory, true);
                        } else {
                            entry.execute(SynchronizedPropagationList.this.workingMemory);
                        }
                    }

                    @Override
                    public void enqueue() {
                        SynchronizedPropagationList.this.internalAddEntry(entry);
                    }
                });
            }
        } else {
            this.internalAddEntry(entry);
        }
    }

    synchronized void internalAddEntry(PropagationEntry entry) {
        if (this.head == null) {
            this.head = entry;
            this.notifyWaitOnRest();
        } else {
            this.tail.setNext(entry);
        }
        this.tail = entry;
        this.hasEntriesDeferringExpiration |= entry.defersExpiration();
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @Override
    public void flush() {
        this.flush(this.workingMemory, this.takeAll());
    }

    @Override
    public void flush(PropagationEntry currentHead) {
        this.flush(this.workingMemory, currentHead);
    }

    private void flush(InternalWorkingMemory workingMemory, PropagationEntry currentHead) {
        for (PropagationEntry entry = currentHead; !this.disposed && entry != null; entry = entry.getNext()) {
            entry.execute(workingMemory);
        }
    }

    @Override
    public boolean hasEntriesDeferringExpiration() {
        return this.hasEntriesDeferringExpiration;
    }

    @Override
    public synchronized PropagationEntry takeAll() {
        PropagationEntry currentHead = this.head;
        this.head = null;
        this.tail = null;
        this.hasEntriesDeferringExpiration = false;
        return currentHead;
    }

    @Override
    public synchronized void reset() {
        this.head = null;
        this.tail = null;
        this.disposed = false;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public synchronized void waitOnRest() {
        this.workingMemory.onSuspend();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void notifyWaitOnRest() {
        this.notifyAll();
        this.workingMemory.onResume();
    }

    @Override
    public synchronized Iterator<PropagationEntry> iterator() {
        return new PropagationEntryIterator(this.head);
    }

    @Override
    public void onEngineInactive() {
    }

    public static class PropagationEntryIterator
    implements Iterator<PropagationEntry> {
        private PropagationEntry next;

        public PropagationEntryIterator(PropagationEntry head) {
            this.next = head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public PropagationEntry next() {
            PropagationEntry current = this.next;
            this.next = current.getNext();
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

