/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.spi.Tuple;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.junit.Assert;
import org.junit.Test;

public class IndexedHashtableIteratorTest {
    @Test
    public void testCanReachAllEntriesInLastTableRowRightTupleIndexHashTable() {
        RightTupleImpl rightTuple;
        int i;
        TupleList rtList;
        int numEntries = 3;
        TupleList[] table = new TupleList[3];
        table[0] = rtList = new TupleList();
        for (i = 0; i < numEntries; ++i) {
            rightTuple = new RightTupleImpl();
            rightTuple.setMemory(rtList);
            rtList.add((Tuple)rightTuple);
        }
        table[2] = rtList = new TupleList();
        for (i = 0; i < numEntries; ++i) {
            rightTuple = new RightTupleImpl();
            rightTuple.setMemory(rtList);
            rtList.add((Tuple)rightTuple);
        }
        rtList = new TupleList();
        table[2].setNext(rtList);
        for (i = 0; i < numEntries; ++i) {
            rightTuple = new RightTupleImpl();
            rightTuple.setMemory(rtList);
            rtList.add((Tuple)rightTuple);
        }
        TupleIndexHashTable.FullFastIterator iter = new TupleIndexHashTable.FullFastIterator((Entry[])table);
        ArrayList<RightTuple> list = new ArrayList<RightTuple>();
        RightTuple rightTuple2 = (RightTuple)iter.next(null);
        while (rightTuple2 != null) {
            Assert.assertFalse((boolean)IndexedHashtableIteratorTest.contains(list, rightTuple2));
            list.add(rightTuple2);
            rightTuple2 = (RightTuple)iter.next((Entry)rightTuple2);
        }
        TupleIndexHashTable rthTable = new TupleIndexHashTable();
        rthTable.init((Entry[])table, 3, numEntries * 3);
        TupleIndexHashTable.FieldIndexHashTableFullIterator iter2 = new TupleIndexHashTable.FieldIndexHashTableFullIterator((AbstractHashTable)rthTable);
        list = new ArrayList();
        RightTuple rightTuple3 = (RightTuple)iter2.next();
        while (rightTuple3 != null) {
            Assert.assertFalse((boolean)IndexedHashtableIteratorTest.contains(list, rightTuple3));
            list.add(rightTuple3);
            rightTuple3 = (RightTuple)iter2.next();
        }
        Assert.assertEquals((long)(numEntries * 3), (long)list.size());
    }

    @Test
    public void testCanReachAllEntriesInLastTableRowLeftTupleIndexHashTable() {
        LeftTupleImpl leftTuple;
        int i;
        TupleList rtList;
        int numEntries = 3;
        TupleList[] table = new TupleList[3];
        table[0] = rtList = new TupleList();
        for (i = 0; i < numEntries; ++i) {
            leftTuple = new LeftTupleImpl();
            leftTuple.setMemory(rtList);
            rtList.add((Tuple)leftTuple);
        }
        table[2] = rtList = new TupleList();
        for (i = 0; i < numEntries; ++i) {
            leftTuple = new LeftTupleImpl();
            leftTuple.setMemory(rtList);
            rtList.add((Tuple)leftTuple);
        }
        rtList = new TupleList();
        table[2].setNext(rtList);
        for (i = 0; i < numEntries; ++i) {
            leftTuple = new LeftTupleImpl();
            leftTuple.setMemory(rtList);
            rtList.add((Tuple)leftTuple);
        }
        TupleIndexHashTable.FullFastIterator iter = new TupleIndexHashTable.FullFastIterator((Entry[])table);
        ArrayList<LeftTupleImpl> list = new ArrayList<LeftTupleImpl>();
        LeftTupleImpl leftTuple2 = (LeftTupleImpl)iter.next(null);
        while (leftTuple2 != null) {
            Assert.assertFalse((boolean)IndexedHashtableIteratorTest.contains(list, leftTuple2));
            list.add(leftTuple2);
            leftTuple2 = (LeftTupleImpl)iter.next((Entry)leftTuple2);
        }
        Assert.assertEquals((long)(numEntries * 3), (long)list.size());
        TupleIndexHashTable lthTable = new TupleIndexHashTable();
        lthTable.init((Entry[])table, 3, numEntries * 3);
        TupleIndexHashTable.FieldIndexHashTableFullIterator iter2 = new TupleIndexHashTable.FieldIndexHashTableFullIterator((AbstractHashTable)lthTable);
        list = new ArrayList();
        LeftTupleImpl leftTuple3 = (LeftTupleImpl)iter2.next();
        while (leftTuple3 != null) {
            Assert.assertFalse((boolean)IndexedHashtableIteratorTest.contains(list, leftTuple3));
            list.add(leftTuple3);
            leftTuple3 = (LeftTupleImpl)iter2.next();
        }
        Assert.assertEquals((long)(numEntries * 3), (long)list.size());
    }

    public static boolean contains(List list, Object object) {
        for (Object o : list) {
            if (o != object) continue;
            return true;
        }
        return false;
    }
}

