/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SimulateMacOSXClassLoader
extends ClassLoader {
    private ClassLoader wrappedRealClassLoader;
    private Set<Class<?>> forClasses = Collections.emptySet();

    public SimulateMacOSXClassLoader(ClassLoader wrappedRealClassLoader, Set<Class<?>> forClasses) {
        this.wrappedRealClassLoader = wrappedRealClassLoader;
        this.forClasses = forClasses;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> macOSXSimilar = null;
        for (Class<?> curElement : this.forClasses) {
            if (!curElement.getName().equalsIgnoreCase(name)) continue;
            macOSXSimilar = curElement;
        }
        Class<?> loaded = null;
        loaded = macOSXSimilar != null ? this.wrappedRealClassLoader.loadClass(macOSXSimilar.getName()) : this.wrappedRealClassLoader.loadClass(name);
        if (loaded.getName().equals(name)) {
            return loaded;
        }
        String resolvedPackage = loaded.getPackage().getName();
        String declaringClasses = "";
        for (Class<?> p = loaded.getDeclaringClass(); p != null; p = p.getDeclaringClass()) {
            declaringClasses = p.getSimpleName() + "$" + declaringClasses;
        }
        throw new NoClassDefFoundError(resolvedPackage.replace(".", "/") + "/" + name.replace(resolvedPackage + ".", "") + " (wrong name: " + resolvedPackage.replace(".", "/") + "/" + declaringClasses + loaded.getSimpleName() + ")");
    }

    public void addClassInScope(Class<?> clazz) {
        if (this.forClasses == Collections.EMPTY_SET) {
            this.forClasses = new HashSet();
        }
        this.forClasses.add(clazz);
    }
}

