/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.text.ParseException;
import java.util.Set;
import org.drools.core.time.impl.TestCronExpression;
import org.junit.Assert;
import org.junit.Test;

public class Quartz601Test {
    @Test
    public void testNormal() {
        for (int i = 0; i < 6; ++i) {
            this.assertParsesForField("0 15 10 * * ? 2005", i);
        }
    }

    @Test
    public void testSecond() {
        this.assertParsesForField("58-4 5 21 ? * MON-FRI", 0);
    }

    @Test
    public void testMinute() {
        this.assertParsesForField("0 58-4 21 ? * MON-FRI", 1);
    }

    @Test
    public void testHour() {
        this.assertParsesForField("0 0/5 21-3 ? * MON-FRI", 2);
    }

    @Test
    public void testDayOfWeekNumber() {
        this.assertParsesForField("58 5 21 ? * 6-2", 5);
    }

    @Test
    public void testDayOfWeek() {
        this.assertParsesForField("58 5 21 ? * FRI-TUE", 5);
    }

    @Test
    public void testDayOfMonth() {
        this.assertParsesForField("58 5 21 28-5 1 ?", 3);
    }

    @Test
    public void testMonth() {
        this.assertParsesForField("58 5 21 ? 11-2 FRI", 4);
    }

    @Test
    public void testAmbiguous() {
        System.err.println(this.assertParsesForField("0 0 14-6 ? * FRI-MON", 2));
        System.err.println(this.assertParsesForField("0 0 14-6 ? * FRI-MON", 5));
        System.err.println(this.assertParsesForField("55-3 56-2 6 ? * FRI", 0));
        System.err.println(this.assertParsesForField("55-3 56-2 6 ? * FRI", 1));
    }

    private Set assertParsesForField(String expression, int constant) {
        try {
            TestCronExpression cronExpression = new TestCronExpression(expression);
            Set set = cronExpression.getSetPublic(constant);
            if (set.size() == 0) {
                Assert.fail((String)("Empty field [" + constant + "] returned for " + expression));
            }
            return set;
        }
        catch (ParseException pe) {
            Assert.fail((String)("Exception thrown during parsing: " + pe));
            return null;
        }
    }
}

