/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.drools.core.util.ClassUtils;
import org.junit.Assert;
import org.junit.Test;

public class ClassUtilsTest {
    @Test
    public void testCanonicalNameSimpleClass() {
        String name = ClassUtils.canonicalName(ClassUtilsTest.class);
        Assert.assertEquals((Object)"org.drools.core.util.ClassUtilsTest", (Object)name);
    }

    @Test
    public void testCanonicalNameInnerClass() {
        String name = ClassUtils.canonicalName(A.class);
        Assert.assertEquals((Object)"org.drools.core.util.ClassUtilsTest.A", (Object)name);
    }

    @Test
    public void testCanonicalNameInnerInnerClass() {
        String name = ClassUtils.canonicalName(A.B.class);
        Assert.assertEquals((Object)"org.drools.core.util.ClassUtilsTest.A.B", (Object)name);
    }

    @Test
    public void testCanonicalNameArray() {
        String name = ClassUtils.canonicalName(Object[].class);
        Assert.assertEquals((Object)"java.lang.Object[]", (Object)name);
    }

    @Test
    public void testCanonicalNameMultiIndexArray() {
        String name = ClassUtils.canonicalName(Object[][][].class);
        Assert.assertEquals((Object)"java.lang.Object[][][]", (Object)name);
    }

    @Test
    public void testCanonicalNameMultiIndexArrayInnerClass() {
        String name = ClassUtils.canonicalName(A.B[][][].class);
        Assert.assertEquals((Object)"org.drools.core.util.ClassUtilsTest.A.B[][][]", (Object)name);
    }

    @Test
    public void testCanonicalNameMultiIndexArrayPrimitives() {
        String name = ClassUtils.canonicalName(long[][][].class);
        Assert.assertEquals((Object)"long[][][]", (Object)name);
    }

    public static class A {

        public static class B {
        }
    }
}

